VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsINIManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'********************************************************************************
'Copyright (c) 2003 DoneEx Software
'
'DESCRIPTION:
'   This class module consists of methods and properties which let to use
'   "DoneEx INI-file Manager Library" in VB and VBA code by the easiest way.
'   In order to use "DoneEx INI-file Manager Library" just import clsINIManager.cls
'   file in VB project and create variable(s) with clsINIManager type.
'********************************************************************************
Private Declare Function CreateINI_dll Lib "INIMngr.dll" Alias "CreateINI" () As Long

Private Declare Function LoadINI_dll Lib "INIMngr.dll" Alias "LoadINI" _
                                (ByVal str As String) As Long
                                
Private Declare Function CloseINI_dll Lib "INIMngr.dll" Alias "CloseINI" _
                                (ByVal fileNum As Long) As Long
                                
Private Declare Function UpdateINI_dll Lib "INIMngr.dll" Alias "UpdateINI" _
                                (ByVal fileNum As Long, ByVal fileName As String) As Long
                            
Private Declare Function GetSection_dll Lib "INIMngr.dll" Alias "GetSection" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByRef retName As String, _
                                 ByVal bufLen As Long) As Long
                             
Private Declare Function GetSectionCount_dll Lib "INIMngr.dll" Alias "GetSectionCount" _
                                (ByVal fileNum As Long) As Long
                                        
Private Declare Function SearchSection_dll Lib "INIMngr.dll" Alias "SearchSection" _
                                (ByVal fileNum As Long, ByVal sectName As String) As Long
                                    
Private Declare Function GetKeyCount_dll Lib "INIMngr.dll" Alias "GetKeyCount" _
                                (ByVal fileNum As Long, ByVal sectNum As Long) As Long
                                    
Private Declare Function SearchKey_dll Lib "INIMngr.dll" Alias "SearchKey" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByVal keyName As String) As Long
                                
Private Declare Function GetKeyName_dll Lib "INIMngr.dll" Alias "GetKeyName" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByVal indxKey As Long, _
                                 ByRef retName As String, _
                                 ByVal bufLen As Long) As Long
                            
Private Declare Function GetKeyValue_dll Lib "INIMngr.dll" Alias "GetKeyValue" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByVal indxKey As Long, _
                                 ByRef retVal As String, _
                                 ByVal bufLen As Long) As Long
                            
Private Declare Function AddKey_dll Lib "INIMngr.dll" Alias "AddKey" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByVal keyName As String, _
                                 ByVal keyValue As String) As Long
                                 
Private Declare Function AddSection_dll Lib "INIMngr.dll" Alias "AddSection" _
                                (ByVal fileNum As Long, _
                                 ByVal sectName As String) As Long
                                 
Private Declare Function DeleteSection_dll Lib "INIMngr.dll" Alias "DeleteSection" _
                                (ByVal fileNum As Long, _
                                 ByVal sectIndex As Long) As Long
                                 
                                    
Private Declare Function DeleteKey_dll Lib "INIMngr.dll" Alias "DeleteKey" _
                                (ByVal fileNum As Long, _
                                 ByVal sectNum As Long, _
                                 ByVal keyIndex As Long) As Long
                                     

Private Declare Sub ClearLastErr_dll Lib "INIMngr.dll" Alias "ClearLastErr" ()

Private Declare Function GetLastErr_dll Lib "INIMngr.dll" Alias "GetLastErr" () As Long

Private Declare Sub SetLastErr_dll Lib "INIMngr.dll" Alias "SetLastErr" (ByVal err As Long)

Private Declare Sub GetLastErrDescr_dll Lib "INIMngr.dll" Alias "GetLastErrDescr" _
                                (ByRef retVal As String, _
                                 ByVal bufLen As Long)

Private Declare Function EncryptKeyValue_dll Lib "INIMngr.dll" Alias "EncryptKeyValue" _
                                        (ByVal fileNum As Long, _
                                          ByVal indexSection As Long, _
                                          ByVal indexKey As Long, _
                                          ByVal strKeyCrypt As String, _
                                          ByRef retCryptStr As String, _
                                          ByVal nBufSize As Long) As Long
                                          
Private Declare Function DecodeKeyValue_dll Lib "INIMngr.dll" Alias "DecodeKeyValue" _
                                        (ByVal fileNum As Long, _
                                          ByVal indexSection As Long, _
                                          ByVal indexKey As Long, _
                                          ByVal strKeyCrypt As String, _
                                          ByRef retDecodeStr As String, _
                                          ByVal nBufSize As Long) As Long
                                          
Private Declare Function SetKeyValue_dll Lib "INIMngr.dll" Alias "SetKeyValue" _
                                (ByVal fileNum As Long, _
                                 ByVal indexSection As Long, _
                                 ByVal indexKey As Long, _
                                 ByVal keyValue As String) As Long

Private Declare Function Info_dll Lib "INIMngr.dll" Alias "Info" ( _
                                  ByVal param_name As String, _
                                  ByRef out_info As String, _
                                  ByVal buf_size As Long) As Long
Private nIniFileNum As Integer
Private txtCurINIFileName As String

Private Const ERR_INI_ALREADY_OPEN As Long = 8


'*******************************************************************************
'*******************************************************************************
Private Sub Class_Initialize()
    nIniFileNum = -1
    txtCurINIFileName = ""
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Shows last error description in message box.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Sub ShowErr()
Dim errDescr As String * 1024
    GetLastErrDescr_dll errDescr, 1024
    If errDescr <> "" Then
        MsgBox errDescr, vbExclamation Or vbOKOnly, "Error"
    End If
End Sub
'*******************************************************************************
'DESCRIPTION:
'   Recieve sign of error. Returns true if previous procedure's or function's call
'   was failed. Otherwize returns false.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Property Get Error() As Boolean
    Error = (GetLastErr_dll() <> 0)
End Property

'*******************************************************************************
'DESCRIPTION:
'   Return internal number of INI-file. If returns -1 that means Create or Load
'   procedure was not called.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Property Get IniFileNum() As Integer
    IniFileNum = nIniFileNum
End Property

'*******************************************************************************
'DESCRIPTION:
'   Creates structure in memory and initializes data.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Sub Create()
    If nIniFileNum = -1 Then
        nIniFileNum = CreateINI_dll
    Else
        SetLastErr_dll (ERR_INI_ALREADY_OPEN)
    End If
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Creates structure in memory and loads data from INI-file to it.
'
' PARAMETERS:
' (In) - ini_file_name: full path to a ini-file.
'*******************************************************************************
Public Sub Load(ini_file_name As String)
    
    If nIniFileNum = -1 Then
        nIniFileNum = LoadINI_dll(ini_file_name)
    Else
        SetLastErr_dll (ERR_INI_ALREADY_OPEN)
    End If

End Sub
'*******************************************************************************
'DESCRIPTION:
'   Updates INI-file data from memory structure.
'
' PARAMETERS:
' (In) - ini_file_name: full path to a ini-file.
'*******************************************************************************
Public Sub Update(ini_file_name As String)

    UpdateINI_dll nIniFileNum, ini_file_name
    If Error Then ShowErr
End Sub
'*******************************************************************************
'DESCRIPTION:
'   Stops the access to INI-file, deletes data from memory and frees memory.
'   After this procedure none of another is available from current object.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Sub CloseDown()
    
    If nIniFileNum <> -1 Then
        If CloseINI_dll(nIniFileNum) = 0 Then
            nIniFileNum = -1
        End If
    End If
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Returns the number of sections in memory structure. The amount of sections
'   can not be less than one. If the function fails, the return value is zero.
'
'PARAMETERS:
'   None
'*******************************************************************************
Public Property Get SectionCount() As Long
    
    If nIniFileNum > -1 Then
        SectionCount = GetSectionCount_dll(nIniFileNum)
    End If
End Property

'*******************************************************************************
'DESCRIPTION:
'   Returns the section's name by its index.
'   If the function fails, the return value is empty string.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   section_index - index of requested section in memory.
'*******************************************************************************
Public Function GetSection(ByVal section_index As Long) As String
    Dim retName As String * 1000
    Dim ret As Long
    
    If nIniFileNum > -1 Then
        retName = ""
        ret = GetSection_dll(nIniFileNum, section_index, retName, 1000)
        If ret = 0 Then 'no error
            GetSection = RTrim(retName)
        End If
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   If the function succeeds, the return value is index of section.
'   If the function fails, the return value is -1.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_name - requested section name.
'*******************************************************************************
Public Function SearchSection(ByVal section_name As String) As Long

    If nIniFileNum > -1 Then
        SearchSection = SearchSection_dll(nIniFileNum, section_name)
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Returns the number of keys in section from memory structure.
'   If the function fails, the return value is -1.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_name - name of section where the keys are located.
'*******************************************************************************
Public Function GetKeyCount(ByVal section_name As String) As Long

    If nIniFileNum > -1 Then
        GetKeyCount = GetKeyCount_dll(nIniFileNum, section_name)
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Returns the index of requested key by its name inside indicated
'   section from memory structure.
'   If the function fails, the return value is -1.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_name - name of key which is searched.
'*******************************************************************************
Public Function SearchKey(ByVal section_index As Long, ByVal key_name As String) As Long

    If nIniFileNum > -1 Then
        SearchKey = SearchKey_dll(nIniFileNum, section_index, key_name)
    End If

End Function

'*******************************************************************************
'DESCRIPTION:
'   Returns the key name of requested key by its index inside indicated
'   section from memory structure.
'   If the function fails, the return value is empty string.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_index - index of key which name is searched.
'*******************************************************************************
Public Function GetKeyName(ByVal section_index As Long, ByVal key_index As Long) As String
    Dim keyName As String * 1000
    
    If nIniFileNum > -1 Then
        keyName = ""
        If GetKeyName_dll(nIniFileNum, section_index, key_index, keyName, 1000) > -1 Then
            GetKeyName = RTrim(keyName)
        End If
    End If
            
End Function
'*******************************************************************************
'DESCRIPTION:
'   Returns the key value of requested key by its index inside indicated
'   section from memory structure.
'   In order to find out was the function failed or succeeded test Error property.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_index - index of key which name is searched.
'*******************************************************************************
Public Function GetKeyValue(ByVal section_index As Long, ByVal key_index As Long) As String
    Dim keyVal As String * 3000
    
    If nIniFileNum > -1 Then
        keyVal = ""
        If GetKeyValue_dll(nIniFileNum, section_index, key_index, keyVal, 3000) > -1 Then
            GetKeyValue = RTrim(keyVal)
        End If
    End If
End Function
'*******************************************************************************
'DESCRIPTION:
'   Returns the key value of requested key by its name inside indicated
'   section from memory structure.
'   In order to find out was the function failed or succeeded test Error property.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_name - name of key which is searched.
'*******************************************************************************
Public Function GetKeyValueByName(ByVal section_index As Long, ByVal key_name As String) As String
    Dim keyVal As String * 3000
    Dim key_index As Long
    
    If nIniFileNum > -1 Then
        key_index = SearchKey(section_index, key_name)
        If key_index >= 0 Then
            keyVal = ""
            If GetKeyValue_dll(nIniFileNum, section_index, key_index, keyVal, 3000) > -1 Then
                GetKeyValueByName = RTrim(keyVal)
            End If
        End If
    End If
End Function

'*******************************************************************************
'DESCRIPTION:
'   Sets new value of key by its index inside indicated section into memory structure.
'   In order to find out was the procedure failed or succeeded test Error property.
'   To get extended error information, test LastErr property.
'
' PARAMETERS:
'   (In) section_index - defines index of section where the key value is set.
'   (In) key_index - index of key which is searched.
'   (In) newKeyVal- new value of key
'*******************************************************************************
Public Sub SetKeyValue(ByVal section_index As Long, ByVal key_index As Long, ByVal newKeyVal As String)

    If nIniFileNum > -1 Then
        SetKeyValue_dll nIniFileNum, section_index, key_index, newKeyVal
    End If

End Sub


'*******************************************************************************
'DESCRIPTION:
'   Adds new key into indicated section into memory structure.
'   If succeed returns index of added key inside section. If failed returns -1.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key value is set.
'   (In) key_name - name of new key.
'   (In) key_value - new value of key
'*******************************************************************************
Public Function AddKey(ByVal section_index As Long, ByVal key_name As String, ByVal key_value As String) As Long
    AddKey = -1
    If nIniFileNum > -1 Then
        AddKey = AddKey_dll(nIniFileNum, section_index, key_name, key_value)
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Adds new section into memory structure.
'   If succeed returns index of added section. If failed returns -1.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_name - name of new sectionlue is set.
'*******************************************************************************
Public Function AddSection(ByVal section_name As String) As Long
    AddSection = -1
    If nIniFileNum > -1 Then
        AddSection = AddSection_dll(nIniFileNum, section_name)
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Deletes section from memory structure by its index.
'   In order to find out was the procedure failed or succeeded test Error property.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - long integer number specifying index of section to delete.
'*******************************************************************************
Public Sub DeleteSection(ByVal section_index As Long)

    If nIniFileNum > -1 Then
        Call DeleteSection_dll(nIniFileNum, section_index)
    End If
    
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Deletes key from indicated section from memory structure by its index.
'   In order to find out was the procedure failed or succeeded test Error property.
'   To get extended error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - long integer number specifying index of section where
'                   deleted key is located.
'   (In) key_index - long integer number specifying index of key to delete
'*******************************************************************************
Public Sub DeleteKey(ByVal section_index As Long, ByVal key_index As Long)

    If nIniFileNum > -1 Then
        Call DeleteKey_dll(nIniFileNum, section_index, key_index)
    End If
    
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Sets up last error value to 0, that means NO ERROR.
'PARAMETERS:
'   None
'*******************************************************************************
Public Sub ClearLastErr()
    ClearLastErr_dll
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Read only property that returns last error value.
'PARAMETERS:
'   None
'*******************************************************************************
Public Property Get LastErr() As Long
    LastErr = GetLastErr_dll
End Property

'*******************************************************************************
'DESCRIPTION:
'   Assigns new value for last error.
'PARAMETERS:
'   (In) errCode - long integer number specifying new value for last error.
'   Zero means no error.
'*******************************************************************************
Public Sub SetLastErr(ByVal errCode As Long)
    SetLastErr_dll (errCode)
End Sub

'*******************************************************************************
'DESCRIPTION:
'   Read only property that returns last error description as a string.
' PARAMETERS:
'   None
'*******************************************************************************
Public Property Get LastErrDescr() As String
Dim errDescr As String * 3000
    errDescr = ""
    GetLastErrDescr_dll errDescr, 3000
    LastErrDescr = RTrim(errDescr)
End Property

'*******************************************************************************
'DESCRIPTION:
'   Encodes original key value by user's crypto-key string and sets new encrypted
'   key in memory structure. Returns the encrypted key value.
'   To get error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_name - name of key which is searched.
'   (In) crypt_key - string specifying crypto-key for encode key value.
'*******************************************************************************
Public Function EncryptKeyValue(ByVal section_index As Long, ByVal key_index As Long, crypt_key As String) As String
    Dim encodedStr As String * 6000
    
    If nIniFileNum > -1 Then
        encodedStr = ""
        If EncryptKeyValue_dll(nIniFileNum, section_index, key_index, crypt_key, encodedStr, 6000) = 0 Then
            EncryptKeyValue = RTrim(encodedStr)
            SetKeyValue section_index, key_index, RTrim(encodedStr)
        End If
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Decodes original key value by user's crypto-key string and sets decoded value
'   key in memory structure. Returns the decoded key value.
'   To get error information, test LastErr property.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) key_name - name of key which is searched.
'   (In) decode_key - string specifying decode-key for decode key value.
'*******************************************************************************

Public Function DecodeKeyValue(ByVal section_index As Long, ByVal key_index As Long, decode_key As String) As String
    Dim decodedStr As String * 3000
    
    If nIniFileNum > -1 Then
        decodedStr = ""
        If DecodeKeyValue_dll(nIniFileNum, section_index, key_index, decode_key, decodedStr, 3000) = 0 Then
            DecodeKeyValue = RTrim(decodedStr)
            SetKeyValue section_index, key_index, RTrim(decodedStr)
        End If
    End If
End Function

'*******************************************************************************
'DESCRIPTION:
'   Searches specifying key value among keys with equal names inside one section
'   If in INI-file are presented more then one key with equal name and value, then
'   function returns the first one from them.
'   Returns index of key or -1 if function was failed.
'
'PARAMETERS:
'   (In) section_index - defines index of section where the key is searched.
'   (In) keysName - string specifying keys name.
'   (In) value - string specifying key value.
'*******************************************************************************
Public Function SearchKeysVal(ByVal section_index As Long, keysName As String, ByVal value As String) As Long
    Dim keyCount, i As Long
    Dim keyName, keyVal As String
    
    SearchKeysVal = -1

    keyCount = GetKeyCount_dll(nIniFileNum, section_index)
    If keyCount > 0 Then
        For i = 0 To keyCount
            keyName = GetKeyName(nIniFileNum, i)
            If Error = 0 And keyName = "style" Then
                keyVal = GetKeyValue(nIniFileNum, i)
                If Error = 0 And keyVal = value Then
                    SearchKeysVal = i
                    Exit Function
                End If
            End If
        Next i
    End If
    
End Function

'*******************************************************************************
'DESCRIPTION:
'   Splits source string by delimiter and saves results to string array.
'   Returns number of elements in result array.
'   To get error information, test LastErr property.
'
'PARAMETERS:
'   (In) str - source string
'   (In) dlmtr - string with dilimeter.
'   (Out) arrStr - string array with results.
'*******************************************************************************
Public Function Split(ByVal str As String, dlmtr As String, ByRef arrStr() As String) As Integer
Dim tmpStr As String
Dim pos, start, nArrSize As Integer

    start = 1
    nArrSize = 0
    pos = InStr(start, str, dlmtr)
    While pos <> 0
        nArrSize = nArrSize + 1
        tmpStr = Mid(str, start, pos - start)
        ReDim Preserve arrStr(1 To nArrSize)
        arrStr(UBound(arrStr)) = tmpStr
        start = pos + 1
        pos = InStr(start, str, dlmtr)
    Wend
    
    tmpStr = RTrim(Mid(str, start))
    If Len(tmpStr) > 0 Then
        nArrSize = nArrSize + 1
        ReDim Preserve arrStr(1 To nArrSize)
        arrStr(UBound(arrStr)) = tmpStr
    End If
    Split = nArrSize
End Function
'*******************************************************************************
'DESCRIPTION:
'   Read only property. Receives current dll version information
'*******************************************************************************
Public Property Get Version() As String
Dim strVer As String * 1000
    If nIniFileNum > -1 Then
        strVer = ""
        If Info_dll("ver", strVer, 1000) = 0 Then
            Version = RTrim(strVer)
        End If
    End If
End Property
'*******************************************************************************
'DESCRIPTION:
'   Read only property. Receives current DLL registered user name
'*******************************************************************************
Public Property Get UserName() As String
Dim strName As String * 1000
    If nIniFileNum > -1 Then
        strName = ""
        If Info_dll("user name", strName, 1000) = 0 Then
            UserName = RTrim(strName)
        End If
    End If
End Property
'*******************************************************************************
'DESCRIPTION:
'   Read only property. Receives current DLL registered user e-mail
'*******************************************************************************
Public Property Get UserEMail() As String
Dim strMail As String * 1000
    If nIniFileNum > -1 Then
        strMail = ""
        If Info_dll("user email", strMail, 1000) = 0 Then
            UserEMail = RTrim(strMail)
        End If
    End If
End Property

