// RobTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RobTest.h"
#include "RobTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRobTestDlg dialog

CRobTestDlg::CRobTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRobTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRobTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRobTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRobTestDlg)
	DDX_Control(pDX, RED, m_EdtRed);
	DDX_Control(pDX, GREEN, m_EdtGreen);
	DDX_Control(pDX, EDT_RANGE2, m_EdtRange2);
	DDX_Control(pDX, EDT_RANGE1, m_EdtRange1);
	DDX_Control(pDX, EDT_POSITIONS, m_EdtPositions);
	DDX_Control(pDX, BLUE, m_EdtBlue);
	DDX_Control(pDX, IDC_ROBCOUNTERCTRL1, m_SmallCounter);
	DDX_Control(pDX, IDC_ROBCOUNTERCTRL2, m_MediumCounter);
	DDX_Control(pDX, IDC_ROBCOUNTERCTRL3, m_LargeCounter);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRobTestDlg, CDialog)
	//{{AFX_MSG_MAP(CRobTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDOK, OnShowMe)
	ON_BN_CLICKED(IDC_BUTTON1, OnColors)
	ON_BN_CLICKED(RADIO_BITMAP, OnBitmap)
	ON_BN_CLICKED(RADIO_LED, OnLed)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRobTestDlg message handlers

BOOL CRobTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	CButton	*Radio = (CButton *)GetDlgItem(RADIO_BITMAP);	
	Radio->SetCheck(TRUE);
	m_iType = 1;

	m_SmallCounter.SetSize(1); //Small
	m_MediumCounter.SetSize(2); //Medium
	m_LargeCounter.SetSize(3); //Large

	m_SmallCounter.SetCounterAsBitmap();
	m_MediumCounter.SetCounterAsBitmap();
	m_LargeCounter.SetCounterAsBitmap();

	m_SmallCounter.SetPositions(5);
	m_MediumCounter.SetPositions(5);
	m_LargeCounter.SetPositions(5);
	
	m_EdtPositions.SetWindowText("5");

	m_EdtRed.SetWindowText("255");
	m_EdtGreen.SetWindowText("255");
	m_EdtBlue.SetWindowText("100");

	m_EdtRange1.SetWindowText("1");
	m_EdtRange2.SetWindowText("100");
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CRobTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CRobTestDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRobTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRobTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CRobTestDlg::OnShowMe() 
{
char szRed[80], szGreen[80], szBlue[80];

m_EdtRed.GetWindowText(szRed, sizeof(szRed));
m_EdtGreen.GetWindowText(szGreen, sizeof(szGreen));
m_EdtBlue.GetWindowText(szBlue, sizeof(szBlue));

short sRed, sGreen, sBlue;
if (strlen(szRed) > 1)
	sRed = atoi(szRed);
if (strlen(szGreen) > 1)
	sGreen = atoi(szGreen);
if (strlen(szBlue) > 1)
	sBlue = atoi(szBlue);

//Set Color
m_SmallCounter.SetBarColor(sRed, sGreen, sBlue);
m_MediumCounter.SetBarColor(sRed, sGreen, sBlue);
m_LargeCounter.SetBarColor(sRed, sGreen, sBlue);

//Set Type
if (m_iType == 1) {
	m_SmallCounter.SetCounterAsBitmap();
	m_MediumCounter.SetCounterAsBitmap();
	m_LargeCounter.SetCounterAsBitmap();
}
else {
	m_SmallCounter.SetCounterAsLED();
	m_MediumCounter.SetCounterAsLED();
	m_LargeCounter.SetCounterAsLED();
	}

//Set Positions
char szPos[80];
short sPos;

m_EdtPositions.GetWindowText(szPos, sizeof(szPos)); 
if (strlen(szPos) > 0)
sPos = atoi(szPos);

	m_SmallCounter.SetPositions(sPos);
	m_MediumCounter.SetPositions(sPos);
	m_LargeCounter.SetPositions(sPos);

//Range?
char szRange[80];
long lRange1, lRange2;

m_EdtRange1.GetWindowText(szRange, sizeof(szRange)); 
if (strlen(szRange) > 0)
lRange1 = atol(szRange);
m_EdtRange2.GetWindowText(szRange, sizeof(szRange)); 
if (strlen(szRange) > 1)
lRange2 = atol(szRange);

if ((lRange2 - lRange1) > 0) {
	m_SmallCounter.SetRange(lRange1, lRange2);
	m_MediumCounter.SetRange(lRange1, lRange2);
	m_LargeCounter.SetRange(lRange1, lRange2);

///Display

	for (int i=lRange1; i < lRange2+1; i++) {
		m_SmallCounter.SetCounter(i);
		m_MediumCounter.SetCounter(i);
		m_LargeCounter.SetCounter(i);
	}
}
}

void CRobTestDlg::OnColors() 
{
CColorDialog pDlg;

	if (pDlg.DoModal() == IDOK)
	{
     char szRed[80], szGreen[80], szBlue[80];

	  COLORREF color = pDlg.GetColor();
	  wsprintf(szRed, "%u", GetRValue(color));
	  wsprintf(szGreen, "%u", GetGValue(color));
	  wsprintf(szBlue, "%u", GetBValue(color));
	  m_EdtRed.SetWindowText(szRed);
	  m_EdtGreen.SetWindowText(szGreen);
	  m_EdtBlue.SetWindowText(szBlue);
	}	
}

void CRobTestDlg::OnBitmap() 
{
m_iType = 1;	
}

void CRobTestDlg::OnLed() 
{
m_iType = 2;	
}
