VERSION 5.00
Object = "{57B5A17C-6DC0-4776-8F51-5519BF1235A6}#31.0#0"; "rsp-zip-compress-as100.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RSP Zip Compressor  Debug sample"
   ClientHeight    =   5235
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   7965
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   5235
   ScaleWidth      =   7965
   StartUpPosition =   2  'CenterScreen
   Begin ComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   120
      TabIndex        =   26
      Top             =   4800
      Width           =   7695
      _ExtentX        =   13573
      _ExtentY        =   450
      _Version        =   327682
      Appearance      =   1
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   6840
      TabIndex        =   25
      Top             =   1800
      Width           =   975
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Resume"
      Height          =   375
      Left            =   5760
      TabIndex        =   24
      Top             =   1800
      Width           =   975
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Pause"
      Height          =   375
      Left            =   6840
      TabIndex        =   23
      Top             =   1320
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Select"
      Height          =   255
      Left            =   1440
      TabIndex        =   19
      Top             =   720
      Width           =   1215
   End
   Begin VB.ListBox List1 
      Height          =   450
      Left            =   120
      TabIndex        =   22
      Top             =   4320
      Width           =   7695
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   6360
      Top             =   2760
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Select"
      Height          =   255
      Left            =   1440
      TabIndex        =   20
      Top             =   0
      Width           =   1215
   End
   Begin RSPZipCompress100as.RSPZip RSPZip1 
      Left            =   5400
      Top             =   2040
      _ExtentX        =   979
      _ExtentY        =   979
   End
   Begin VB.TextBox Text6 
      Height          =   495
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   18
      Top             =   3600
      Width           =   7695
   End
   Begin VB.TextBox Text5 
      Height          =   735
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   17
      Top             =   2640
      Width           =   7695
   End
   Begin VB.TextBox Text4 
      Height          =   285
      Left            =   1440
      TabIndex        =   15
      Text            =   "*.*"
      Top             =   360
      Width           =   6375
   End
   Begin VB.CheckBox Check4 
      Caption         =   "Test zip file (check whether the zip file is not damaged)"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   2160
      Width           =   4455
   End
   Begin VB.CheckBox Check3 
      Caption         =   "Freshen files (extract only files that exist on disk but are older)"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   1920
      Width           =   4935
   End
   Begin VB.CheckBox Check2 
      Caption         =   "Don't overwrite (don't overwrite files in the destination folder)"
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   1680
      Width           =   4815
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Overwrite (overwrite files on the destination folder)"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   1440
      Value           =   1  'Checked
      Width           =   4095
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Unzip"
      Height          =   375
      Left            =   5760
      TabIndex        =   7
      Top             =   1320
      Width           =   975
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   2760
      TabIndex        =   5
      Text            =   "c:\my destination directory"
      Top             =   720
      Width           =   5055
   End
   Begin VB.TextBox Text2 
      Height          =   285
      Left            =   1440
      TabIndex        =   2
      Text            =   "the password"
      Top             =   1080
      Width           =   3135
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   2760
      TabIndex        =   0
      Text            =   "c:\my zip files\my zip.zip"
      Top             =   0
      Width           =   5055
   End
   Begin VB.Label Label5 
      Caption         =   "Internal error and description:"
      Height          =   255
      Left            =   120
      TabIndex        =   21
      Top             =   4080
      Width           =   2175
   End
   Begin VB.Label Label10 
      Caption         =   "Status:"
      Height          =   255
      Left            =   6240
      TabIndex        =   16
      Top             =   1080
      Width           =   1575
   End
   Begin VB.Label Label9 
      Caption         =   "Files to extract:"
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   390
      Width           =   2415
   End
   Begin VB.Label Label8 
      Caption         =   "RSP Software 1996-2004"
      Height          =   255
      Left            =   6000
      TabIndex        =   9
      Top             =   5040
      Width           =   3015
   End
   Begin VB.Label Label6 
      Caption         =   "Unzip function return code and description:"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   3375
      Width           =   4215
   End
   Begin VB.Label Label4 
      Caption         =   "Command: "
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Destination path:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   750
      Width           =   1935
   End
   Begin VB.Label Label2 
      Caption         =   "Password:"
      Height          =   255
      Left            =   600
      TabIndex        =   3
      Top             =   1110
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Zip file to unzip:"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   30
      Width           =   3375
   End
   Begin VB.Menu about 
      Caption         =   "About"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'RSP Software - Tue Jan 13 18:56:17 2004 - http://rspsoftware.clic3.net
'
'Debug sample to the new RSP Zip Compressor 1.0.0
'
'This sample project for the moment has only unzip capabilities, and several
'options are missing
'
'It can be used to debug and test whether the compression is occurring correctly
'
'It can handle any zip file , with or without passwords , created with pkware or
'Info-zip based compressors
'
'The compressor and decompressor is based on Info-zip
'
'Due to some known Info-Zip limitations the control has several workarounds to
'avoid problems , and a page with the list of workarounds or known Info-Zip bugs
'will be available also at
'http://rspsoftware.clic3.net/rspinfozipbugs.htm
'
'The code receive information about the zip file , destination directory ,
'password , arguments and options regarding compression or decompression using an
'xml like parser that can accept the following commands:
'
'password : This command will define the password to be used when decompressing
'the zip file , if not used , no password will be used to decompress the file ,
'then if the zip is password protected an error will be returned
'example using VB code:
'Ret = RSPZipUncompress("<password=my password>")
'
'test-zipfile : This command will make the decompressor to decompress the
'selected files to the memory and check the CRC of all the selected files , if
'the file is damaged an error will be returned with description
'example using VB code:
'Ret = RSPZipUncompress("<test-zipfile>")
'
'file-extraction-mode : This command will define whether the files will be
'overwritten in the destination folder or not overwritten or freshen , in case of
'freshen , the files will only be exatracted if the destional files exist on the
'disk and are older than the files available on the zip file , the valid
'arguments to this command are overwrite , don't-overwrite or freshen-files , if
'an invalid option is passed as an argument to this command and error will be
'returned with description , if this command is not passed , the control will
'overwrite by default
'example using VB code:
'Ret = RSPZipUncompress("<file-extraction-mode=don't-overwrite>")
'or
'Ret = RSPZipUncompress("<file-extraction-mode=overwrite>")
'or
'Ret = RSPZipUncompress("<file-extraction-mode=freshen-files>")
'
'
'zipfile : This command will define the zip file to be extracted to the
'destination directory , the control has full support to UNC paths , the argument
'to this command need to be a zip file including full path information , this
'command is obligatory in any call to the decompression function
'example using VB code:
'Ret = RSPZipUncompress("<zipfile=c:\mypath\myzip.zip>")
'or
'Ret = RSPZipUncompress("<zipfile=\\UNCpath\sharedfolder\myzip.zip>")
'
'files-selection : This command will select what files in the zip file will be
'processed , if an "*.*" is used , then all files will be processed , and the
'selection is case insensitive , if a selection like this "*.H" is used , all
'files with an extension .h and .H will be extracted , notice that you don't need
'to use "" to pass arguments , even with long path names , the parser will
'evaluate each command and argument as required , this command is obligatory in
'any call to the decompression function
'example using VB code:
'Ret = RSPZipUncompress("<files-selection=*.h>")
'or
'Ret = RSPZipUncompress("<files-selection=my file to extract.mdb>")
'
'destination-path : This command will define the path where the files will be
'extracted , if the command <test-zipfile> is used , then this command is
'irrelevant , since to test the decompressor will extract to the memory , this
'command has full UNC path support , and the parser will check whether the
'destination path is valid , if not an error and description will be returned ,
'this command is obligatory in any call to the decompression function when the
'command <test-zipfile> isnot used
'example using VB code:
'Ret = RSPZipUncompress("<destination-path=c:\mypath to extract\path1>")
'or
'Ret = RSPZipUncompress("<destination-path=\\UNCpath\mysharedfolder>")
'
'In order to execute the decompression you need to contruct a complete command
'like this
'
'ret = RSPZipUncompress("<password=my
'password><file-extraction-mode=don't-overwrite><zipfile=c:\mypath\myzip.zip><fil
'es-selection=*.h><destination-path=c:\mypath to extract\path1>")
'
'In the case above , the file "c:\mypath\myzip.zip", will be extracted to
'"c:\mypath to extract\path1" , and only the files "*.h" will be extracted , and
'it will not overwrite the files in the destination
'
'ret = RSPZipUncompress("<test-zipfile><password=my
'password><zipfile=c:\mypath\myzip.zip><files-selection=*.h>")
'
'In the case above , the file "c:\mypath\myzip.zip", will be tested in memory for
'errors
'
'The commands are constructed in any sequence , the delimiters <> define where a
'command begin and where it finish , there is no sequence to follow when grouping
'commands , and you can put spaces betten commands like this:
'ret = RSPZipUncompress("    <password=my password>
'<file-extraction-mode=don't-overwrite>   <zipfile=c:\mypath\myzip.zip>
'<files-selection=*.h>   <destination-path=c:\mypath to extract\path1>   ")
'
'You only need to be carefull with spaces in the arguments to the command , like
'this:
'Ret = RSPZipUncompress("<password=my password>")
'is equal to
'Ret = RSPZipUncompress("  <   password  =my password>   ")
'but it isnot equal to
'Ret = RSPZipUncompress("  <   password  =my pass word>   ")
'In this case the password now is "my pass word" and will be executed incorrectly
'internally
'
'With the parser it is more easy to detect errors in the information passed to
'The compressor or decompressor
'
'It will avoid ambiguities on the compression or decompression code , since the
'parser will evaluate each command and return an error code if the command isnot
'accepted
'
'And it will inform about missing commands or modifications required in the
'commands in order to work
'
'With the parser it will be more easy to compress or decompress zip files
'since you only need to know about the commands and all the commands are
'intuitive making it a good solution to use zip compression in any application
'using only a few lines of code , and with full zip compression error handling
'
'For each error , a description of the error will return , with the description
'it is very easy to understand what goes wrong , and how to avoid the same error
'in the future
'
'When this software become stable , the possibility of bugs will be almost
'impossible
'
'For the moment it can only unzip files , next release will have unzip , zip ,
'pause , resume and cancel options also
'
'And maybe a progress event with the description of files being compressed or
'decompressed
'
'The goal is to provide as a development tool a control to both OCX and .Net
'framework development capable of generating a winzip clone running very fast in
'order to make it possible to anyone interested in zip compression to use it
'without possible bugs , the case that any possible option will not generate an
'unexpected error in the compression
'or decompression
'
'Thanks for using our software
'

Private Sub about_Click()
RSPZip1.About
End Sub

Private Sub Check1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 1
    Check2.value = 0
    Check3.value = 0
End Sub

Private Sub Check2_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 0
    Check2.value = 1
    Check3.value = 0
End Sub

Private Sub Check3_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 0
    Check2.value = 0
    Check3.value = 1
End Sub

Private Sub Command1_Click()
    
    CommonDialog1.ShowOpen
    Text1.Text = CommonDialog1.filename
    
End Sub

Private Sub Command2_Click()
    Dim Comando As String
    Dim Ret As Long
    Text6.Text = ""
    Label10.Caption = "Status: Working..."
    Form1.Refresh
    
    
    'addition of the <zipfile> command
    'this command will define the zip file that you want to decompress ( or test )
    'this is the name of the zip file with a path like this c:\my path\myzip.zip
    Dim MyString As String
    MyString = Text1.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        'The creation of the command is only a sequence of additions to the Comando string
        Comando = Comando & "<zipfile=" & MyString & ">"
    Else
        MsgBox "A zip file is required , with complete path"
        Label10.Caption = "Status: Finished"
        Form1.Refresh
        Exit Sub
    End If
    
    'addition of the <files-selection> command
    'this command will define the files that you want to extract
    'if you want to extract all files , just select *.*
    'to extract a unique file , just select the filename like this mydatabase.mdb , it will extract only the file  mydatabase.mdb
    MyString = Text4.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<files-selection=" & MyString & ">"
    Else
        MsgBox "The selection of files to test or extract are required in any unzip command"
        Label10.Caption = "Status: Finished"
        Form1.Refresh
        Exit Sub
    End If
    
    'addition of the <password> command
    'this command will define whether a zip file will be encrypted or not
    'if the password is provided , then the file will be encrypted using the password
    MyString = Text2.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<password=" & MyString & ">"
    End If
    
    'addition of the <destination-path> command
    'this is the path where the selected files will be extracted
    'if the path don't exist , it will be created
    MyString = Text3.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<destination-path=" & MyString & ">"
    End If
    
    'addition of the <file-extraction-mode> command
    'the file extraction mode will define whether the files being extracted will overwrite the files in the destination
'or don't overwrite or freshen the files
    If Check1.value = 1 Then
        Comando = Comando & "<file-extraction-mode=overwrite>"
    End If
    If Check2.value = 1 Then
        Comando = Comando & "<file-extraction-mode=don't-overwrite>"
    End If
    If Check3.value = 1 Then
        Comando = Comando & "<file-extraction-mode=freshen-files>"
    End If
    
    'addition of the <test-zipfile> command
    'this command will define whether you will extract the files or just test in the memory the extraction
        If Check4.value = 1 Then
        Comando = Comando & "<test-zipfile>"
    End If
    
    
    'Now just pass the command string the the unzip function , the return information will be available after the Finish event is raised , the event returns error number and error description
    'The RSPZipUncompress don't returns nothing because the code execution occurs in a different thread , and there is no way to predict what will be the return value , this is why
    'we need to wait for the finish event to be raised in order to see what occurred with the information passed
    Text5.Text = Comando
    RSPZip1.RSPZipUncompress (Comando)
    Form1.Refresh
    
    'As you can see , you don't more than a unique command in order to execute the code , you only need to learn about the small number of commands available to the control
    'in order to start using the control without possible problems
    'It is very easy to use , and possible ( we hope ) bug free
    
End Sub



Private Sub Command3_Click()

Text3.Text = RSPZip1.RSPBrowseForFolder("RSP Software", "")

End Sub

Private Sub Command4_Click()
'it will pause the execution
RSPZip1.RSPZipPause

End Sub

Private Sub Command5_Click()
'it will resume the execution
RSPZip1.RSPZipResume
End Sub

Private Sub Command6_Click()
'it will cancel the execution
RSPZip1.RSPZipCancel
End Sub

Private Sub Form_Load()

Form1.Caption = RSPZip1.ControlName & " - Unzip decompression sample"

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
'if the code is executing , just cancel when closing the form
RSPZip1.RSPZipCancel

End Sub

Private Sub RSPZip1_ErrorCode(ErrorNumber As Long, ErrorDescription As String)
    
    Static NumberOfErrors As Long
    NumberOfErrors = NumberOfErrors + 1
    List1.AddItem NumberOfErrors & " : " & ErrorNumber & " : " & ErrorDescription    'This event is raised in any exception
    Dim Ret As Long
    Ret = List1.ListCount
    List1.ListIndex = Ret - 1
    
End Sub

Private Sub RSPZip1_Finished(ReturnCode As Long, ReturnDescription As String)
    'This event is the way to know that the execution is finished , this occurs because the
    'code execution is running  in a different thread created internally by the decompressor
    Text6.Text = ReturnCode & ": " & ReturnDescription
    Label10.Caption = "Status: Finished"
    
End Sub

Private Sub RSPZip1_Progress(Progress As Long)
ProgressBar1.value = Progress
End Sub


