
#ifndef sgSmallString_H
#define sgSmallString_H

#ifdef __ATLBASE_H__  
	inline HINSTANCE GetResInstance() { return _Module.GetResourceInstance(); }
#else
	extern HINSTANCE GetResInstance();
#endif

class SString {
public:
	SString();
	SString(const SString& s);
	SString(LPCTSTR psz);
	SString(int len, TCHAR c);
	~SString();

	bool		loadString(UINT id);
	LPCTSTR	c_str() const			{ return m_pData ? m_pData : _T(""); }
	LPTSTR	getBuffer(int len);
	void		releaseBuffer(int newLen = -1);
	int		length() const			{ return m_nStrLen; }
	int		buffLength() const	{ return m_nBuffLen; }
	void		clear();
	bool		empty() const			{ return length() == 0; }
	void		lower();
	void		upper();

	const SString& operator = (const SString& s);
	const SString& operator = (LPCTSTR psz);
	const SString& operator = (TCHAR ch);
	const SString& operator += (const SString& s);
	const SString& operator += (LPCTSTR psz);
	const SString& operator += (TCHAR ch);
	const TCHAR&	operator [] (int index) const;
	TCHAR&			operator [] (int index);

	const bool operator == (const SString& s) const;
	const bool operator == (LPCTSTR psz) const;

private:
	TCHAR* m_pData;
	int    m_nBuffLen;
	int    m_nStrLen;

	void	allocate(LPCTSTR psz, int len);
};

SString operator + (const SString& s, LPCTSTR pszStr);

inline SString::SString()
{
	m_pData = 0;
	m_nBuffLen = 0;
	m_nStrLen = 0;
}

inline SString::SString(const SString& s)
{
	m_pData = 0;
	m_nBuffLen = 0;
	m_nStrLen = 0;
	*this = s;
}

inline SString::SString(LPCTSTR psz)
{
	m_pData = 0;
	m_nBuffLen = 0;
	m_nStrLen = 0;
	if (HIWORD(psz) == 0)
		loadString(LOWORD(psz));
	else
		*this = psz;
}

inline SString::SString(int len, TCHAR c)
{
	if (len < 0)
		len = -len;
	m_pData = new TCHAR[len+1];
	if (m_pData != 0)
	{
		m_nBuffLen = len+1;
		for (int i = 0; i < len; m_pData[i++] = c);
		m_pData[len] = 0;
		m_nStrLen = lstrlen(m_pData);
	}
	else
	{
		m_nBuffLen = 0;
		m_nStrLen = 0;
	}
}

inline SString::~SString()
{
	clear();
}

inline bool SString::loadString(UINT id)
{
	HINSTANCE hInst = GetResInstance();

	const nBuffSize = 256;
	TCHAR szBuff[nBuffSize]; 
	int nSize = LoadString(hInst, id, szBuff, nBuffSize);
	if (nSize == 0)
	{
		clear();
		return false;
	}
	allocate(szBuff, nSize+1);
	return true;
}

inline void SString::clear()
{
	delete m_pData;
	m_pData = 0;
	m_nBuffLen = 0;
	m_nStrLen = 0;
}

inline void SString::allocate(LPCTSTR psz, int len)
{
	clear();
	m_pData = new TCHAR[len];
	if (m_pData != 0)
	{
		m_pData[0] = 0;
		m_nBuffLen = len;
		m_nStrLen = 0;

		if (psz != 0)
		{
			lstrcpy(m_pData, psz);
			m_nStrLen = lstrlen(m_pData);
		}
	}
}

inline LPTSTR SString::getBuffer(int len)
{
	if (len > m_nBuffLen)
		allocate(0, len);
	if (len > 0)
		memset(m_pData, 0, m_nBuffLen);
	return m_pData;
}

inline void SString::releaseBuffer(int newLen)
{
	if (m_pData == 0)
		return;

	if (newLen == -1)
	{
		m_nStrLen = lstrlen(m_pData);
	}
	else if (newLen < m_nBuffLen)
	{
		m_pData[newLen] = 0;
		m_nStrLen = newLen;
	}
}

inline void SString::lower()
{
	if (m_pData == 0)
		return;
	strlwr(m_pData);
}

inline void SString::upper()
{
	if (m_pData == 0)
		return;
	strupr(m_pData);
}

inline const SString& SString::operator = (const SString& s)
{
	if (this != &s)
		allocate(s.c_str(), s.length() + 1);

	return *this;
}

inline const SString& SString::operator = (LPCTSTR psz)
{
	if (psz == 0)
		clear();
	else
	{
		if (m_pData != psz)
			allocate(psz, lstrlen(psz)+1);
	}

	return *this;
}

inline const SString& SString::operator = (TCHAR ch)
{
	TCHAR sz[2];
	sz[0] = ch;
	sz[1] = 0;
	return operator=(sz);
}

inline const bool SString::operator == (const SString& s) const
{
	return (lstrcmp(c_str(), s.c_str()) == 0) ? true : false;
}

inline const bool SString::operator == (LPCTSTR psz) const
{
	if (psz == 0)
		return false;

	return (lstrcmp(c_str(), psz) == 0) ? true : false;
}

inline SString operator + (const SString& s, LPCTSTR pszStr)
{
	SString result(s);
	result += pszStr;
	return result;
}

inline const SString& SString::operator += (const SString& s)
{
	return operator+=(s.c_str());
}

inline const SString& SString::operator += (LPCTSTR psz)
{
	if (psz == 0)
		return *this;

	int nLen = length() + lstrlen(psz);
	if (nLen < buffLength())
	{
		lstrcat(m_pData, psz);
	}
	else
	{
		SString res(nLen + 1, 0);
		res += c_str();
		res += psz;
		*this = res;
	}
	m_nStrLen = m_pData ? lstrlen(m_pData) : 0;
	return *this;
}

inline const SString& SString::operator += (TCHAR ch)
{
	TCHAR sz[2];
	sz[0] = ch;
	sz[1] = 0;
	return operator+=(sz);
}

inline const TCHAR& SString::operator [] (int index) const
{
	if ((index < 0) || (index >= m_nStrLen))
		throw 0;

	return m_pData[index];
}

inline TCHAR& SString::operator [] (int index)
{
	if ((index < 0) || (index >= m_nStrLen))
		throw 0;

	return m_pData[index];
}

#endif // sgSmallString_H
