#ifndef __REGEXP_H__
#define __REGEXP_H__

#include <string>

#ifdef _UNICODE
	typedef std::wstring str_t;
#else
	typedef std::string str_t;
#endif

class regexp;
class Regexp {
public:
	enum { NSUBEXP = 10 };

	Regexp();
	Regexp(LPCTSTR exp, BOOL iCase = 0);
	Regexp(const Regexp &r);
	~Regexp();

	const Regexp & operator=(const Regexp & r);

	void  SetRegExp(LPCTSTR exp, BOOL iCase = 0);
	bool	Match(LPCTSTR s, long lStartPos);
	int	SubStrings() const;
	
	str_t	operator[](unsigned int i) const;
	int	SubStart(unsigned int i) const;
	int	SubLength(unsigned int i) const;

	str_t	GetReplaceString(LPCTSTR source) const;

	str_t	GetErrorString() const;
	short	GetErrorNumber() const;
	bool	CompiledOK() const;

#if defined(_RE_DEBUG)
	void Dump();
#endif

private:
	const TCHAR*	m_string;	/* used to return substring offsets only */
	mutable str_t	m_sError;
	regexp*			rc;

	void	ClearErrorString() const;
	int	safeIndex(unsigned int i) const;
};

#endif

