//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report6;

interface

procedure Report_6(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Printers,Comctrls,Dialogs;

procedure Report_6(show:Boolean);
var
   Sp:TSprint;
   Re:TRichEdit;
   StartPos,ToEnd,FoundAt:integer;
   s,s1,s2:string;
   MAXWIDTH:integer;
begin
   //in order to print RTF file we will use invisible TRichEdit
   //it will save us a lot of time and work
   Re:=TRichEdit.CreateParented(Form1.Handle);
   Re.Visible:=False;
   if fileexists('manual.rtf') then begin
      Re.Lines.LoadFromFile('manual.rtf');
   end else begin
      showmessage('Cannot find file MANUAL.RTF in directory '+getcurrentdir);
      exit;
   end;

   //initialize sprint
   Sp:=form1.SPrint1;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';

   //we will define 3 fields:
   //  left field justified left
   //  center field
   //  right field justified right
   //because our fields are not wrapping text automatically,
   //it is ok to print strings of any length as long as we
   //take care about string lengths and truncate them as needed
   Sp.AddField('x','lefttext',taLeftJustify);
   Sp.AddField('x','centertext',taCenter);
   Sp.AddField('x','righttext',tarightJustify);
   Sp.Recalculate(-200); {20 mm from both paper edges}
   //string should not be longer than our margins
   MAXWIDTH:=Sp.Fields[3].AbsLeft-Sp.Fields[1].AbsRight;

   //defaults change
   Sp.ShowHeader:=False;
   Sp.LeftMargin:=200;
   Sp.RightMargin:=200;
   Sp.TopMargin:=200;
   Sp.BottomMargin:=200;
   Sp.FooterLeftStr:='$D $T SPRINT - Print & Preview engine for Delphi - Manual.rtf';

   //RTF!
   s:='';
   StartPos:=0;
   repeat
      ToEnd:=Length(Re.Text)-StartPos;
      //we are processing paragraph by paragraph
      FoundAt:=Re.FindText(chr(13),StartPos,ToEnd,[]);
      if (FoundAt<>-1) then begin
         Re.SelStart:=StartPos;
         Re.SelLength:=FoundAt-StartPos;
         s:=s+copy(Re.SelText,1,length(Re.SelText));
         //TRichEdit allready knows all about font
         Sp.Style[tsText].Font.Assign(Re.SelAttributes);
         //Recalculate not only recalculates field coordinates but
         //also vertical spacings for all styles
         //this assures that any Sprint.Add will move CurrY as needed
         Sp.Recalculate(-200); {20 mm from both paper edges}
         Sp.SetStyle(tsText);
         //
         s1:='';
         if s='' then begin
            Sp.Add(['']);
         end else begin
            //here we add word by word and print as many words in
            //one line as we can
            while length(s)>0 do begin
               s1:='';
               repeat
                  if pos(' ',s)>0 then begin
                     s2:=copy(s,1,pos(' ',s));
                  end else begin
                     s2:=s;
                  end;
                  if Sp.Canv.TextWidth(s1+s2)<=MAXWIDTH then begin
                     s1:=s1+s2;
                     if s<>'' then begin
                        s:=copy(s,length(s2)+1,(length(s)-length(s2)));
                     end;
                  end else begin
                     break;
                  end;
               until length(s)=0;
               //here we strip last space in the string
               if s1[length(s1)]=' ' then begin
                  s1:=copy(s1,1,length(s1)-1);
               end;
               if Re.Paragraph.Alignment=taLeftJustify  then Sp.Add([s1]) else
               if Re.Paragraph.Alignment=taCenter       then Sp.Add(['',s1]) else
                  Sp.Add(['','',s1]);
            end;
         end;
         StartPos:=Re.SelStart+Re.SelLength+2;
      end;
   until FoundAt=-1;
   //
   //print or preview?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
   Re.Free;
end;

end.
