#include "mtx.hh"

#ifdef WINDOWS
SECURITY_ATTRIBUTES secattr2 = { sizeof(SECURITY_ATTRIBUTES), NULL, TRUE };
#endif

Mtx::Mtx()
{
#ifdef WINDOWS
  mtx = CreateMutex(&secattr2, FALSE, NULL);
#else
  pthread_mutex_init(&mtx, 0);
#endif
}

Mtx::~Mtx()
{
#ifdef WINDOWS
  CloseHandle(mtx);
#else
  pthread_mutex_destroy(&mtx);
#endif
}

void Mtx::Lock()
{
#ifdef WINDOWS
  WaitForSingleObject(mtx, INFINITE);  
#else
//  printf("lock\n"); 
  pthread_mutex_lock(&mtx);
//  printf("locked\n"); 
#endif
}

void Mtx::Unlock()
{
#ifdef WINDOWS
  ReleaseMutex(mtx);
#else
//  printf("unlock\n"); 
  pthread_mutex_unlock(&mtx);
//   printf("unlocked\n"); 
#endif
}

