#include "proxyconf.hh"
#include "conf.h"
#include <string.h>
#ifdef WINDOWS
#define Win32_Winsock
#include <windows.h>
#else
#include <netdb.h>
#include <unistd.h>
#include <sys/socket.h>
#endif
#include <stdio.h>

const char ri[] =
"HTTP/1.1 200 OK" CRLF_STR
"Content-type: application/x-ns-proxy-autoconfig" CRLF_STR CRLF_STR
"// See\n"
"// http://home.netscape.com/eng/mozilla/2.0/relnotes/demo/proxy-live.html\n"
"// for more info.\n"
"function FindProxyForURL(url, host)\n"
"{\n"
"  if (isPlainHostName(host))\n"
"    return \"DIRECT\";\n"
"  if (dnsDomainIs(host,\"%s\"))\n"
"    return \"DIRECT\";\n"
"  if (!isResolvable(host))\n"
"    return \"DIRECT\";\n"
"  if (url.substring(0, 5) == \"http:\")\n"
"    return \"PROXY %s:%d\";\n"
"  return \"DIRECT\";\n"
"}\n";
  
char * get_autoconf_proxy()
{
  char h[512];
  gethostname(h, sizeof(h));
  hostent *he = gethostbyname(h);
  char *hostname = he->h_name;
  char *domain = strchr(hostname, '.');
  if (domain)
    domain++;
  else
    domain = "localdomain";
  char *s = new char[strlen(ri)+1024];
  sprintf(s, ri, domain, hostname, listen_port);
  return s;
}
