#include <gtk/gtk.h>
#include "parse.h"
#include "block.h"
#include "blist.hh"
#include "hcom.hh"
#include <stdio.h>

GtkWidget *addentry_dialog;
GtkEntry *addentry_ib[6];
GtkWidget *bodyblock_check;

void addentry_sel_received (GtkWidget *widget,
			    GtkSelectionData *selection_data, 
			    gpointer data)
{
  if (selection_data->length < 0)
    return;
  char *h = (char *) selection_data->data;
  if (!h)
    return;
  char *s = new char[strlen((char *) h)+1];
  strcpy(s, (char *) h);
  gtk_entry_set_text(addentry_ib[4], s);
  char *host, *path, *dummy;
  int port, ofs;
  ParseURI(dummy, s, false, host, port, path, ofs);
  //	       printf("h: %s, host: %s, port: %i, path: %s\n", (char *) h, host, port, path);
  if (!host)
    host = "";
  if (!path)
    path = "";
  
  gtk_entry_set_text(addentry_ib[0], (char *) h + ofs);
  gtk_entry_set_text(addentry_ib[2], host);
  gtk_entry_set_text(addentry_ib[3], path);
  /* remove filename from path */
  for(char *s3 = path+strlen(path); s3 >= path; s3--)
    if (*s3 == '/') {
      *(s3+1) = 0;
      break;
    }
  char *s2 = new char[strlen((char *) h)+100];
  if (port != 80)
    sprintf(s2, "http://%s:%i/%s", host, port, path);
  else
    sprintf(s2, "http://%s/%s", host, path);
  gtk_entry_set_text(addentry_ib[1], s2);
}

void addentry_ok(GtkWidget *widget, gpointer data)
{
  char *host, *path;
  int port, ofs, idx;
  int i = (int) data;
  char *buf = gtk_entry_get_text((GtkEntry *) addentry_ib[i]);
  if (i == 3) {
    host = 0;
    port = 0;
    path = buf;
  } else {
    char *dummy;
    ParseURI(dummy, buf, false, host, port, path, ofs);
  }
  bool bodyblock = GTK_CHECK_BUTTON(bodyblock_check)->toggle_button.active;
  char *body = gtk_entry_get_text((GtkEntry *) addentry_ib[4]);
//  printf("%d, host: %s, path: %s, body: %s\n", i, host, path, body);
  switch (i) {
   case 0:
    idx = blist.add_full(host, port, path, body, bodyblock);
    break;
   case 1:
    idx = blist.add_dir(host, port, path, body, bodyblock);
    break;
   case 2:
    idx = blist.add_host(host, port, body, bodyblock);
    break;
   case 3:
    idx = blist.add_path(path, body, bodyblock);
    break;
   case 4:
    idx = blist.add_anypath(path, body, bodyblock);
    break;
  }
  if (idx >= 0) {
    ListChanged(idx);
    ListResize();
  }
  gtk_grab_remove(addentry_dialog);
  gtk_widget_hide(addentry_dialog);
  gtk_widget_destroy(addentry_dialog);    
}

void addentry()
{
  GtkWidget *d = gtk_dialog_new();
  addentry_dialog = d;
  gtk_window_set_title (GTK_WINDOW (d), "Block if:");
  gtk_container_border_width (GTK_CONTAINER (d), 10);  
  const char *lb[] = {"Host and path is:", "Host and begin of path is:",
    "Hostname is:", "Begin of path is:", "Anywhere in path is:", "Body block:"};
  const char *bt[] = {"Add full", "Add dir", "Add host", "Add path", "Add any"};
  GtkWidget *tb = gtk_table_new(5, 3, FALSE);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG (d)->vbox), tb, TRUE, TRUE, 0);
  for(int i=0; i<6; i++) {
    GtkWidget *l;
    if (i!=5)
      l = gtk_label_new(lb[i]);
    else {
      l = gtk_check_button_new_with_label(lb[i]);
      bodyblock_check = l;
    }
    gtk_table_attach_defaults(GTK_TABLE(tb), l, 0, 1, i, i+1);
    gtk_widget_show(l);
    GtkWidget *e = gtk_entry_new_with_max_length(200);
    gtk_table_attach_defaults(GTK_TABLE(tb), e, 1, 2, i, i+1);
    gtk_widget_show(e);
    addentry_ib[i] = (GtkEntry *) e;
    if (i==5)
      break;
    GtkWidget *b = gtk_button_new_with_label(bt[i]);
    gtk_table_attach_defaults(GTK_TABLE(tb), b, 2, 3, i, i+1);
    gtk_widget_show(b);
    gtk_signal_connect (GTK_OBJECT (b),
			       "clicked", GTK_SIGNAL_FUNC(addentry_ok),
			       (gpointer) i);
  }
  gtk_widget_show(tb);
  GtkWidget *  button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG (d)->action_area), button,
		      TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (d));  
  gtk_widget_show (button);
  gtk_widget_show(d);
  gtk_grab_add(d);
  gtk_signal_connect (GTK_OBJECT(d), "selection_received",
		      GTK_SIGNAL_FUNC (addentry_sel_received), NULL);
  static GdkAtom atom = gdk_atom_intern ("STRING", FALSE);
  gtk_selection_convert(d, GDK_SELECTION_PRIMARY, atom, GDK_CURRENT_TIME);
}

void removeentry()
{
  int r = clicked_row;
  if (r == -1 || r < 0 || r >= blist.GetLast())
         return;
  blist.remove_entry(r);
  ResetList();
}
