#include "wins.h"

#ifdef WINDOWS
#define Win32_Winsock
#include <windows.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <fcntl.h>
#endif

#define EHOSTBYNAME -1000
#define EPEERNAME -1001

#ifdef WINDOWS
WSADATA wsaData;
#endif

int s_init()
{
#ifdef WINDOWS
   int ret = WSAStartup(MAKEWORD(1, 1), &wsaData);
//   printf("%x %x\n", wsaData.wHighVersion, wsaData.wVersion);
   return ret;
#else
   return 0;
#endif
}

int s_done()
{
#ifdef WINDOWS
   WSACleanup();
#endif
   return 0;
}

shndl_t s_socket()
{
   return socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
}

int s_connect(shndl_t s, const char *name, int port)
{
   struct sockaddr_in a;
   struct hostent *h;
   h = gethostbyname(name);
   if (h == NULL)
     return EHOSTBYNAME;
   a.sin_family = AF_INET;
   a.sin_port = htons((short) port);
   memcpy(&(a.sin_addr.s_addr), h->h_addr, sizeof(a.sin_addr.s_addr));
   return connect(s, (struct sockaddr *) &a, sizeof(a));
}

int s_bind(shndl_t s, int port)
{
   int on = 1;
   struct sockaddr_in a;
   a.sin_family = AF_INET;
   a.sin_port = htons((short) port);
   a.sin_addr.s_addr = INADDR_ANY;
   setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (const char *) &on, sizeof(on));
   return bind(s, (struct sockaddr *) &a, sizeof(a));
}

int s_recv(shndl_t s, void *buf, int size)
{
  return recv(s, (char *) buf, size, 0);
}

int s_send(shndl_t s, const void *buf, int size)
{
  return send(s, (char *) buf, size, 0);
}

int s_closesocket(shndl_t s)
{
#ifdef WINDOWS
   return closesocket(s);
#else
   return close(s);
#endif
}

int s_listen(shndl_t s, int backlog)
{
   return listen(s, backlog);
}

shndl_t s_accept(shndl_t s)
{
   struct sockaddr_in a;
   int alen = sizeof(a);
   return accept(s, (struct sockaddr *) &a, &alen);
}

int s_sendstr(shndl_t s, const char *str)
{
  return send(s, str, strlen(str), 0);
}

int s_WSAGetLastError()
{
#ifdef WINDOWS
   return WSAGetLastError();
#else
   return errno;
#endif
}

int s_select(shndl_t s1, shndl_t s2)
{
   fd_set st;
   int r;
   int maxfd;
   
   FD_ZERO(&st);
   FD_SET(s1, &st);
   FD_SET(s2, &st);
   
   maxfd = s1 > s2 ? s1 : s2;
   
   r = select(maxfd+1, &st, NULL, NULL, NULL);
   
   if (r <= 0)
     return r;
   
   if (FD_ISSET(s1, &st))
     return s1;
   
   if (FD_ISSET(s2, &st))
     return s2;
   
   return -1;
}

int s_isnonlocal(shndl_t s)
{
   struct sockaddr_in a;     
   struct hostent *h;
   int sz;
   char hs[512];
   char **h1;
   h = gethostbyname("localhost");
   if (h == NULL)
     return EHOSTBYNAME;   
   sz = sizeof(a);
   if (getpeername(s, (struct sockaddr *) &a, &sz))
     return EPEERNAME;
   if (!memcmp(&(a.sin_addr.s_addr), h->h_addr, sizeof(a.sin_addr.s_addr)))
     return 0;
   gethostname(hs, sizeof(hs));
   h = gethostbyname(hs);
   for(h1 = h->h_addr_list; *h1; h1++)
     if (!memcmp(&(a.sin_addr.s_addr), h->h_addr, sizeof(a.sin_addr.s_addr)))
       return 0;
   return 1;
}

#ifdef WINDOWS
/* from http://support.microsoft.com/support/kb/articles/q150/5/37.asp */

struct ws_error_str {
   int num;
   const char *text;
};

struct ws_error_str ws_err[] = { 
{ WSAEINTR, "Interrupted system call." },
{ WSAEBADF, "Bad file number." },
{ WSAEACCES, "Permission denied." },
{ WSAEFAULT, "Bad address." },
{ WSAEINVAL, "Invalid argument." },
{ WSAEMFILE, "Too many open files." },
{ WSAEWOULDBLOCK, "Operation would block." },
{ WSAEINPROGRESS, "Operation now in progress." },
{ WSAEALREADY, "Operation already in progress." },
{ WSAENOTSOCK, "Socket operation on nonsocket." },
{ WSAEDESTADDRREQ, "Destination address required." },
{ WSAEMSGSIZE, "Message too long." },
{ WSAEPROTOTYPE, "Protocol wrong type for socket." },
{ WSAENOPROTOOPT, "Protocol not available." },
{ WSAEPROTONOSUPPORT, "Protocol not supported." },
{ WSAESOCKTNOSUPPORT, "Socket type not supported." },
{ WSAEOPNOTSUPP, "Operation not supported on socket." },
{ WSAEPFNOSUPPORT, "Protocol family not supported." },
{ WSAEAFNOSUPPORT, "Address family not supported by protocol family." },
{ WSAEADDRINUSE , "Address already in use." },
{ WSAEADDRNOTAVAIL, "Cannot assign requested address." },
{ WSAENETDOWN, "Network is down." },
{ WSAENETUNREACH, "Network is unreachable." },
{ WSAENETRESET  , "Network dropped connection on reset." },
{ WSAECONNABORTED, "Software caused connection abort." },
{ WSAECONNRESET, "Connection reset by peer." },
{ WSAENOBUFS, "No buffer space available." },
{ WSAEISCONN, "Socket is already connected." },
{ WSAENOTCONN, "Socket is not connected." },
{ WSAESHUTDOWN, "Cannot send after socket shutdown." },
{ WSAETOOMANYREFS, "Too many references: cannot splice." },
{ WSAETIMEDOUT, "Connection timed out." },
{ WSAECONNREFUSED, "Connection refused." },
{ WSAELOOP, "Too many levels of symbolic links." },
{ WSAENAMETOOLONG, "File name too long." },
{ WSAEHOSTDOWN, "Host is down." },
{ WSAEHOSTUNREACH, "No route to host." },
{ WSASYSNOTREADY, "The network subsystem is unusable." },
{ WSAVERNOTSUPPORTED, "The Windows Sockets DLL cannot support this application." },
{ WSANOTINITIALISED, "Winsock not initialized." },
{ WSAEDISCON, "Disconnect." },
{ WSAHOST_NOT_FOUND, "Host not found." },
{ WSATRY_AGAIN, "Nonauthoritative host not found." },
{ WSANO_RECOVERY, "Nonrecoverable error." },
{ WSANO_DATA, "Valid name, no data record of requested type." },
{ 0, 0 }
};

#endif

const char * winsock_geterror(int num)
{
#ifdef WINDOWS
   struct ws_error_str *a = ws_err;
   for(; a->num; a++)
     if (a->num == num)
       return a->text;
   return NULL;
#else
   return strerror(num);
#endif
}

