#ifndef _block_h_
#define _block_h_

class Mtx;
class BlockListEntry;

const int MaxEntries = 500; // stupid BC can't have class constants

class BlockList {
   int last;
   BlockListEntry *bl[MaxEntries];
   int add_e(BlockListEntry *be);
   Mtx *mtx;
 public:
   bool disabled;
   int total;
   BlockList();
   ~BlockList();
   
   int is_blocked(int count, const char *host, int port, const char *path, bool &is_bodyblock, const char * (&ret_body));

   int add_full(const char *host, int port, const char *path, const char *body, bool bodyblock);
   int add_host(const char *host, int port, const char *body, bool bodyblock);
   int add_dir(const char *host, int port, const char *dir, const char *body, bool bodyblock);
   int add_path(const char *path, const char *body, bool bodyblock);
   int add_anypath(const char *path, const char *body, bool bodyblock);
  
   void remove_entry(int indx);
   
   bool info_entry(int indx, const char * (&host), int &port, const char * (&path), int &accessed, const char * (&body), bool &bodyblock);
   
   void Free();

   void Load(const char *filename);   
   void Save(const char *filename);
   int GetLast() { return last; }
};

extern BlockList blist;

#endif
