#include "blist.hh"
#include "block.h"
#include "conf.h"
#include "chup.hh"

void ListChanged(int idx)
{
//  printf("lc: %d\n", idx);
   const char *host, *path, *body;
   int port, access;
   bool bodyblock;
   if (!blist.info_entry(idx, host, port, path, access, body, bodyblock))
     return;
   if (!*host)
     host = "<any>";
   if (!*path)
     path = "<any>";
   if (!bodyblock)
     body = "";
   ListSetItem(idx, access, host, path, port, body);
}

void ResetList()
{
   ListClear();
   int last = blist.GetLast();
   for (int i = 0; i < last; i++)
     ListChanged(i);
   ListResize();
}

static bool already_checked = false;

void SuccessfullRequest()
{
  if (!already_checked && auto_update == 2) {
    already_checked = true;
    CheckUpdate(true);    
  }
}
