#include <signal.h>
#include "h.h"
#include "h2.h"
#include "utils.hh"
#include "conf.h"
#include "chup.hh"
#include "adb.h"
#include "block.h"
#include <pthread.h>
#include "mtx.hh"
#include "hcom.hh"
#include "blist.hh"
#include "menu.hh"
#include "addentry.hh"

Mtx *gmtx = 0;

GtkWidget *status_bar;
char statusbar_text[200];
int statusbar_fd;
int context_id;

GtkWidget *url_bar;
char urlbar_text[300];
int urlbar_fd;
int url_context_id;

GtkWidget *error_bar;
char error_text[300];
int error_fd;
int error_context_id;

int entry_fd;

GtkWidget *menubar;

void replace_status(GtkWidget *sb, int context_id, const char *statusbar_text)
{
  gtk_statusbar_pop(GTK_STATUSBAR(sb), context_id);
  gtk_statusbar_push(GTK_STATUSBAR(sb), context_id, statusbar_text);
}

void PrintStatus(const char *host, int port, const char *path)
{
  gmtx->Lock();
  if (port != 80)
    g_snprintf(urlbar_text, sizeof(urlbar_text), "http://%s:%i/%s", host, port, path);
  else
    g_snprintf(urlbar_text, sizeof(urlbar_text), "http://%s/%s", host, path);
  char b;
  write(urlbar_fd, &b, sizeof(b));
  gmtx->Unlock();
}

void PrintThreads(int threads)
{
  gmtx->Lock();
  char b;  
  if (threads)
    g_snprintf(statusbar_text, sizeof(statusbar_text), "Threads: %i", threads);
  else {
    if (blist.disabled)
      strcpy(urlbar_text, "Idle (disabled)");
    else
      strcpy(urlbar_text, "Idle");
    write(urlbar_fd, &b, sizeof(b));
    g_snprintf(statusbar_text, sizeof(statusbar_text), "Total: %i", blist.total);
  }
  write(statusbar_fd, &b, sizeof(b));
  gmtx->Unlock();
}

void PrintError(const char *host, int port, const char *path, const char *title, const char *text)
{
//  printf("error: %s\n", title);  
  gmtx->Lock();
  strcpy(error_text, title);
  char b;
  write(error_fd, &b, sizeof(b));  
  gmtx->Unlock();  
}

void UpdateEntry(int idx)
{
  gmtx->Lock();
  write(entry_fd, &idx, sizeof(idx));
  gmtx->Unlock();    
}

void statusbar_update_callback(gpointer data, gint source, GdkInputCondition condition)
{
  gmtx->Lock();
  char b;
  read(source, &b, sizeof(b));
  replace_status(status_bar, context_id, statusbar_text);
  gmtx->Unlock();
}

void entry_update_callback(gpointer data, gint source, GdkInputCondition condition)
{
  gmtx->Lock();  
  int b;
  read(source, &b, sizeof(b));
  ListChanged(b);
  gmtx->Unlock();  
}

void urlbar_update_callback(gpointer data, gint source, GdkInputCondition condition)
{
  gmtx->Lock();  
  int b;
  read(source, &b, sizeof(b));
  replace_status(url_bar, url_context_id, urlbar_text);  
  gmtx->Unlock();  
}

void error_update_callback(gpointer data, gint source, GdkInputCondition condition)
{
  gmtx->Lock();  
  int b;
  read(source, &b, sizeof(b));
  replace_status(error_bar, error_context_id, error_text);  
  gmtx->Unlock();  
}

void * CallServer(void *)
{
   signal(SIGPIPE, SIG_IGN);
   PrintThreads(0);  
   adbmain();
/* !!! FIXME !!!   PostMessage(hwnd, WM_COMMAND, ID_FILE_EXIT, 0); */
   do_wnd_abort = true;
   return 0;  
}

void delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
}

int main(int argc, gchar *argv[])
{
  gmtx = new Mtx();
  gmtx->Lock();
  int stbar_fd[2];
  pipe(stbar_fd);
  statusbar_fd = stbar_fd[1];
  int en_fd[2];
  pipe(en_fd);
  entry_fd = en_fd[1];
  int url_fd[2];
  pipe(url_fd);
  urlbar_fd = url_fd[1];
  int err_fd[2];
  pipe(err_fd);
  error_fd = err_fd[1];
  pthread_t t;
  pthread_create(&t, 0, CallServer, 0);
//  signal(SIGPIPE, SIG_IGN);
  gtk_init(&argc, &argv);
  LoadConf();
  if (auto_save)
    blist.Load(block_filename);
  blist.Load("adb.cfg");
  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize(GTK_WIDGET(window), 450, 200);
  
  gtk_window_set_title(GTK_WINDOW(window), "Ad Buster");
  
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      GTK_SIGNAL_FUNC (delete_event), NULL);
  
  GtkWidget *vbox = gtk_vbox_new(FALSE, 1);
  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show(vbox);

  get_main_menu(window, &menubar);
  gtk_box_pack_start(GTK_BOX(vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show(menubar);
  
  GtkWidget *lbox = gtk_hbox_new(FALSE, 1);
  gtk_container_add(GTK_CONTAINER(vbox), lbox);
  gtk_widget_show(lbox);
  ListInitialize(lbox);  
  ResetList();  
  GtkWidget *sbox = gtk_hbox_new(FALSE, 1);
//  gtk_container_add(GTK_CONTAINER(vbox), sbox);
  gtk_box_pack_start(GTK_BOX(vbox), sbox, FALSE, TRUE, 0);    
  gtk_widget_show(sbox);

  status_bar = gtk_statusbar_new();      
  gtk_box_pack_start (GTK_BOX (sbox), status_bar, TRUE, TRUE, 0);
  gtk_widget_show(status_bar);
  context_id = gtk_statusbar_get_context_id( GTK_STATUSBAR(status_bar), "Statusbar");

  url_bar = gtk_statusbar_new();      
  gtk_box_pack_start(GTK_BOX (sbox), url_bar, TRUE, TRUE, 0);
  gtk_widget_show(url_bar);
  url_context_id = gtk_statusbar_get_context_id( GTK_STATUSBAR(url_bar), "URL bar");

  error_bar = gtk_statusbar_new();      
  gtk_box_pack_start(GTK_BOX (sbox), error_bar, TRUE, TRUE, 0);
  gtk_widget_show(error_bar);
  error_context_id = gtk_statusbar_get_context_id( GTK_STATUSBAR(error_bar), "Error bar");
  
  gdk_input_add(stbar_fd[0], GDK_INPUT_READ, statusbar_update_callback, 0);
  gdk_input_add(en_fd[0], GDK_INPUT_READ, entry_update_callback, 0);
  gdk_input_add(url_fd[0], GDK_INPUT_READ, urlbar_update_callback, 0);
  gdk_input_add(err_fd[0], GDK_INPUT_READ, error_update_callback, 0);
  
  gmtx->Unlock();
  gtk_widget_show(window);
  
  if (auto_update == 1)
    CheckUpdate(true);
  
  gtk_main();
  
  if (auto_save)
    blist.Save(block_filename);
  
  delete gmtx;
  return 0;
}
