#include "reg.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

const char *rcprefix = "/.adb/";

char * retfile(const char *name)
{
  const char *hm = getenv("HOME");
  if (!hm)
    hm = "";
  char *r = new char[strlen(hm)+strlen(rcprefix)+strlen(name)+2];
  sprintf(r, "%s%s%s", hm, rcprefix, name);
  return r;
}

FILE *openf(const char *name, bool do_write)
{
  char *p = retfile(name);
  FILE *f = fopen(p, do_write ? "w" : "r");
  delete p;
  return f;
}

bool get_bool_key(const char *subtree, const char *name)
{
   FILE *f = openf(name, false);
   if (f) {
     char buf[20];
     memset(buf, 0, sizeof(buf));
     fread(buf, sizeof(buf), 1, f);
     bool v = atoi(buf);
     fclose(f);
     return v;
   }
   return false;
}

void set_bool_key(const char *subtree, const char *name, bool val)
{
   FILE *f = openf(name, true);
   if (f) {
     char *buf;
     buf = val ? "1" : "0";
     fwrite(buf, 1, 1, f);
     fclose(f);
   }
}

void get_string_key(const char *subtree, const char *name, char *buf, int buflen)
{
   *buf = 0;
   FILE *f = openf(name, false);
   if (f) {
     memset(buf, 0, buflen);
     fread(buf, buflen, 1, f);
     fclose(f);
   }  
}

void set_string_key(const char *subtree, const char *name, const char *buf)
{
   FILE *f = openf(name, true);
   if (f) {
     fwrite(buf, strlen(buf), 1, f);
     fclose(f);
   }  
}


int get_int_key(const char *subtree, const char *name)
{
   FILE *f = openf(name, false);
   if (f) {
     char buf[20];
     memset(buf, 0, sizeof(buf));
     fread(buf, sizeof(buf), 1, f);
     int v = atoi(buf);
     fclose(f);
     return v;
   }
   return 0;
}

void set_int_key(const char *subtree, const char *name, int val)
{
   FILE *f = openf(name, true);
   if (f) {
     char buf[200];
     sprintf(buf, "%d", val);
     fwrite(buf, strlen(buf), 1, f);
     fclose(f);
   }  
}

