#include "win\rsc.h"
#include <windows.h>
#include <string.h>

#ifdef __MINGW32__
typedef struct _NOTIFYICONDATA {
   DWORD cbSize;
   HWND hWnd;
   UINT uID;
   UINT uFlags;
   UINT uCallbackMessage;
   HICON hIcon;
   char szTip[64];
} NOTIFYICONDATA, *PNOTIFYICONDATA;

extern "C" {
BOOL WINAPI Shell_NotifyIcon(DWORD dwMessage, PNOTIFYICONDATA pnid);
};

#define NIM_ADD         0x00000000
#define NIM_MODIFY      0x00000001
#define NIM_DELETE      0x00000002

#define NIF_MESSAGE     0x00000001
#define NIF_ICON        0x00000002
#define NIF_TIP         0x00000004

#endif

void register_icon(HWND hWnd, bool modify, char *text, HICON hIcon)
{
   NOTIFYICONDATA n;
   n.cbSize = sizeof(n);
   n.hWnd = hWnd;
   n.uID = 0x666333;
   n.uFlags = NIF_MESSAGE | NIF_TIP | NIF_ICON;
   n.uCallbackMessage = WM_SYSTRAY_CALL;
   n.hIcon = hIcon;
   strcpy(n.szTip, text);
   Shell_NotifyIcon(modify ? NIM_MODIFY : NIM_ADD, &n);
}

void remove_icon(HWND hWnd)
{
   NOTIFYICONDATA n;
   n.cbSize = sizeof(n);
   n.hWnd = hWnd;
   n.uID = 0x666333;
   n.uFlags = 0;
   Shell_NotifyIcon(NIM_DELETE, &n);
}
