<%@ page language="java" import="com.kplab.webeasy.Util, com.kplab.webeasy.CategoryBean.*,
    com.kplab.webeasy.ItemBean.*" contentType="text/html" %>

<jsp:useBean id="CategoryBean" scope="session" class="com.kplab.webeasy.CategoryBean" />
<jsp:useBean id="ItemBean" scope="session" class="com.kplab.webeasy.ItemBean" />

<%
    response.setHeader("Pragma", "no-cache");
    response.setHeader("Cache-Control", "no-cache");
    response.setHeader("Expires", "0");
%>

<html>
<head>
<title>123-WebEasy Category Management</title>
<meta http-equiv="Content-Type" content="text/html">
</head>


<script language="javascript">
function editCat(obj, edit_link)
{
  i = obj.selectedIndex;
  window.parent.location = edit_link + obj.options[i].value;
}
</script>


<body background="../images/bg.gif" bgcolor="white" marginheight="0" marginwidth="0"
      topmargin="5" leftmargin="5">

<center>
<image src="../images/header.gif">
<br>

<font color="#800080" size="5" face="Arial"><strong>Edit Category</strong></font>
<br><br>


<%
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int new_level=0, last_catid=0;
    try {
      if (request.getParameter("NewLevel") != null)
      {
        new_level  = Integer.parseInt(request.getParameter("NewLevel"));
        last_catid = Integer.parseInt(request.getParameter(
                     "Cat" + Integer.toString(new_level)));
      }
    }
    catch (Exception e) {
      %>The page you selected does not exist.<%
      return;
    }

    String return_code = request.getParameter("ReturnCode");
    String action = request.getParameter("Action");
    if (action == null)  { action = ""; }

    String admin_servlet = new String(Util.getServletRoot() + 
                              "/com.kplab.webeasy.CategoryAdminServlet");

    String edit_link = "EditCategory.jsp?Action=EDIT";
%>


<table width="75%" border="0">
<%
    /********************************************/
    /*** Show messsage for the last operation ***/
    /********************************************/

    if (return_code != null)
    {
%>
  <tr><td valign="top" align="left" colspan="2">
<%
      if (return_code.equals("OK"))
      {
%>
    <font color="blue"><b>The operation completed successfully.</b></font><br>
<%
      }

      if (return_code.equals("FAILED"))
      {
%>
    <font color="red"><b>The operation failed !! Please check log file.</b></font><br>
<%
      }
%>
  </td></tr>
<%
    }
%>    


<%
    /*********************************************************************************/
    /*** Call this jsp to further select if Action!=EDIT and sub-categories exist. ***/
    /*** Call Admin servlet to edit the selected category if Action=EDIT or the    ***/
    /*** category has no sub-category.                                             ***/
    /*** new_level = level of the category to be selected or edited.               ***/
    /*********************************************************************************/

    CategoryBean.refreshList(last_catid, 1);
    int list_size = CategoryBean.getListSize();

    /* Empty category list */
    if (last_catid == 0 && list_size == 0)
    {
%>
  <br><br><center>There is no category defined yet.</center><br><br>
</table></center></boby></html>
<%
      return;
    }

    if ((! action.equals("EDIT")) && list_size > 0)
    {
      new_level++;
%>
  <form action="EditCategory.jsp" method="post">
<%
    }
    else
    {
%>
  <form action="<%= admin_servlet %>" method="post" ENCTYPE="multipart/form-data">
<%
    }

    edit_link = edit_link + "&NewLevel=" + Integer.toString(new_level);
%>

  <input type="hidden" name="NewLevel" value="<%= Integer.toString(new_level) %>">



<%
    /************************************/
    /***** Show Selected Categories *****/
    /************************************/

    for (int level=1; level<new_level; level++)
    {
      int cat_id=0;
      String cat_alias = "Cat" + Integer.toString(level);
      try {
        cat_id = Integer.parseInt(request.getParameter(cat_alias));
      }
      catch (Exception e) {
        %>The page you selected does not exist.<%
        return;
      }

      Category cat = CategoryBean.getCategory(cat_id, 1);
      String cat_name = cat.getCatName();

      edit_link = edit_link + "&" + cat_alias + "=" + Integer.toString(cat_id);
%>
  <tr>
    <td valign="top" align="left" width="30%" nowrap>
      <b>Level <%= Integer.toString(level) %> Category:</b>
    </td>
    <td valign="top" align="left" width="70%"><%= cat_name %></td>
    <input type="hidden" name="<%= cat_alias %>" value="<%= Integer.toString(cat_id) %>">
  </tr>
<%
    }
%>


<%
    /**********************************/
    /***** Show Category List Box *****/
    /**********************************/

    if ((! action.equals("EDIT")) && list_size > 0)
    {
      String cat_alias = "Cat" + Integer.toString(new_level);
      edit_link = edit_link + "&" + cat_alias + "=";
%>

  <tr>
    <td valign="top" align="left" width="30%" nowrap>
      <b>Level <%= Integer.toString(new_level) %> Category:</b>
    </td>
    <td valign="top" align="left" width="70%">
      <select size="1" name="<%= cat_alias %>">
<%
      for (int i=0; i<list_size; i++)
      {
        Category cat = CategoryBean.getCategoryAt(i);
        int cat_id = cat.getCatID();
        String cat_name = cat.getCatName();
%>
      <option value="<%= Integer.toString(cat_id) %>"><%= cat_name %></option> 
<%
      }
%>
      </select>
      <input type="submit" value="Next">

      <input type="button" name="EditCat" value="Edit"
       onclick="javascript:editCat(this.form.<%= cat_alias %>, '<%= edit_link %>')">
      <a href="index.html">Exit</a>
    </td>
  </tr>
<%
    }
%>


<%
    /*****************************/
    /******* Edit Category *******/
    /*****************************/

    if (action.equals("EDIT") || list_size == 0)
    {
      Category cat      = CategoryBean.getCategory(last_catid, 1);
      String cat_name   = cat.getCatName();
      String cat_des    = cat.getCatDes();
      String leaf_cat   = cat.getLeafCat();
      String leaf_flag  = "";
      if (leaf_cat != null && leaf_cat.equals("Y"))  { leaf_flag = "CHECKED"; }

      boolean has_subcat=false;
      CategoryBean.refreshList(last_catid, 1);
      if (CategoryBean.getListSize() > 0)  has_subcat = true;

      boolean has_item=false;
      ItemBean.refreshList(last_catid, 1);
      if (ItemBean.getListSize() > 0)  has_item = true;
%>
  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Category name:</b></td>
    <td valign="top" align="left" width="70%"><textarea name="CatName"
        wrap="physical" rows="1" cols="50"><%= cat_name %></textarea></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Description:</b></td>
    <td valign="top" align="left" width="70%"><textarea name="CatDes"
        wrap="physical" rows="10" cols="50"><%= cat_des %></textarea></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Image 1 (optional):</b></td>
    <td valign="top" align="left"><input type=FILE name="CatImage1">
        (Nil <input name="NilImage1" type="checkbox">)<br>
        Leave it blank if unchange.
    </td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Image 2 (optional):</b></td>
    <td valign="top" align="left"><input type=FILE name="CatImage2">
        (Nil <input name="NilImage2" type="checkbox">)<br>
        Leave it blank if unchange.
    </td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Leaf Category:</b></td>
<%
      if (has_item == true)
      {
%>
    <td valign="top" align="left" width="70%"><b>Y</b>
        (Cannot update because this category has items)</td>
    <input type="hidden" name="LeafCat" value="on">
<%
      }
      else
      if (has_subcat == true)
      {
%>
    <td valign="top" align="left" width="70%"><b>N</b>
        (Cannot update because this category has sub-categories)</td>
    <input type="hidden" name="LeafCat" value="off">
<%
      }
      else
      {
%>
    <td valign="top" align="left" width="70%"><input name="LeafCat"
        type="checkbox" <%= leaf_flag %>></td>
<%
      }
%>
  </tr>

  <tr>
    <td valign="top" align="left"></td>
    <input type="hidden" name="Action" value="EDIT">
    <input type="hidden" name="CatID" value="<%= Integer.toString(last_catid) %>">
    <td valign="top" align="left"><input type="submit" value="Submit">
        <input type="reset" value="Clear All">&nbsp;<a href="index.html">Exit</a>
    </td>
  </tr>
<%
    }
%>


  </form>
</table>
</center>
</body>
</html> 
