<%
    /*************************************************/
    /*****  Shopping Cart order confirmed Page.  *****/
    /*************************************************/
%>

<%
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    OrderInfo confirmed_info = (OrderInfo) session.getValue("ConfirmedInfo");
    Vector confirmed_detail = (Vector) session.getValue("ConfirmedDetail");
    int num_of_item = confirmed_detail.size();

    int order_id = confirmed_info.getOrderID();
    Timestamp order_time = confirmed_info.getOrderTime();
    int expiry_month = confirmed_info.getExpiryMonth();
    int expiry_year = confirmed_info.getExpiryYear();
    String customer_id = confirmed_info.getCustomerID();
    String customer_last_name = confirmed_info.getCustomerLastName();
    String customer_first_name = confirmed_info.getCustomerFirstName();
    String payment_method = confirmed_info.getPaymentMethod();
    String cardholder_name = confirmed_info.getCardholderName();
    String card_number = confirmed_info.getCardNumber();
    String recipient_last_name = confirmed_info.getRecipientLastName();
    String recipient_first_name = confirmed_info.getRecipientFirstName();
    String recipient_phone = confirmed_info.getRecipientPhone();
    String recipient_address = confirmed_info.getRecipientAddress();
%>

<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr><td valign="top" align="left" colspan="2"><b>Thank you for your order.</b></td></tr>
  <tr><td valign="top" align="left" colspan="2">Please print out this page for your reference.</td></tr>

  <tr>
    <td valign="top" align="left">&nbsp;</td>
    <td valign="top" align="left">&nbsp;</td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap><b>Order number:&nbsp;</b></td>
    <td valign="top" align="left"><b><%= Util.padInteger(order_id, 10) %></b></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap><b>Order date and time:&nbsp;</b></td>
    <td valign="top" align="left"><b><%= order_time.toString() %></b><br>&nbsp;</td>
  </tr>

<%
    /******************************************/
    /********** Customer Information **********/
    /******************************************/
%>

  <tr>
    <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
    <strong>Customer Information</strong></font></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Customer surname:&nbsp;</td>
    <td valign="top" align="left"><%= customer_last_name %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Customer first name:&nbsp;</td>
    <td valign="top" align="left"><%= customer_first_name %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Payment method:&nbsp;</td>
    <td valign="top" align="left"><%= payment_method %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Cardholder's name:&nbsp;</td>
    <td valign="top" align="left"><%= cardholder_name %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Credit card number:&nbsp;</td>
    <td valign="top" align="left"><%= card_number %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Expiration date:&nbsp;</td>
    <td valign="top" align="left">
      <%= Integer.toString(expiry_month) %>/<%= Integer.toString(expiry_year) %>
    </td>
  </tr>

  <tr>
    <td valign="top" align="left">&nbsp;</td>
    <td valign="top" align="left">&nbsp;</td>
  </tr>


<%
    /******************************************/
    /********** Delivery Information **********/
    /******************************************/
%>

  <tr>
    <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
    <strong>Delivery Information</strong></font></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Recipient's surname:&nbsp;</td>
    <td valign="top" align="left"><%= recipient_last_name %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Recipient's first name:&nbsp;</td>
    <td valign="top" align="left"><%= recipient_first_name %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Contact phone number:&nbsp;</td>
    <td valign="top" align="left"><%= recipient_phone %></td>
  </tr>

  <tr>
    <td valign="top" align="left" nowrap>Delivery address:&nbsp;</td>
    <td valign="top" align="left"><%= recipient_address %></td>
  </tr>

  <tr>
    <td valign="top" align="left">&nbsp;</td>
    <td valign="top" align="left">&nbsp;</td>
  </tr>


<%
    /******************************************/
    /************* Order Detail ***************/
    /******************************************/
%>
  <tr>
    <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
    <strong>Order Details</strong></font></td>
  </tr>

  <tr>
    <td valign="top" align="left" colspan="2">
      <table border="1" width="100%" cellspacing="2" cellpadding="2">
        <tr>
          <td valign="top" align="left"  width="50%"><b>Item name&nbsp;</b></td>
          <td valign="top" align="right" width="15%"><b>&nbsp;Quantity</b></td>
          <td valign="top" align="right" width="15%"><b>&nbsp;Price</b><br>(US$)</td>
          <td valign="top" align="right" width="20%"><b>&nbsp;Sub-total</b><br>(US$)</td>
        </tr>

<%
    double total=0;
    for (int i=0; i<num_of_item; i++)
    {
      OrderItem order_item = (OrderItem) confirmed_detail.elementAt(i);
      int item_id = order_item.getItemID();
      String item_name = order_item.getItemName();
      int qty = order_item.getQty();
      double item_price = order_item.getItemPrice();
      double sub_total = ((double) Math.round(item_price * qty * 100)) / 100;
      total += sub_total;
%>
        <tr>
          <td valign="top" align="left"><%= item_name %>&nbsp;</td>
          <td valign="top" align="right">&nbsp;<%= qty %></td>
          <td valign="top" align="right">&nbsp;<%= item_price %></td>
          <td valign="top" align="right">&nbsp;<%= sub_total %></td>
        </tr>
<%
    }
    total = ((double) Math.round(total * 100)) / 100;
%>
        <tr>
          <td valign="top" align="left"><b>Grand total</b></td>
          <td valign="top" align="right">&nbsp;</td>
          <td valign="top" align="right">&nbsp;</td>
          <td valign="top" align="right"><b><%= total %></b></td>
        </tr>
      </table>
    </td>
  </tr>

  <tr>
    <td valign="top" align="left">&nbsp;</td>
    <td valign="top" align="left">&nbsp;</td>
  </tr>

</table>

