/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.VirtualDisk;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;

public class VirtualDisk
implements Serializable {
    private Hashtable hashtable = new Hashtable();
    private boolean modifiedFlag = false;

    public boolean isModified() {
        return this.modifiedFlag;
    }

    public String[] GetDirectory() {
        Enumeration enumeration;
        String[] stringArray = null;
        int n = this.hashtable.size();
        if (n > 0 && (enumeration = this.hashtable.keys()) != null) {
            int n2 = 0;
            stringArray = new String[n];
            while (enumeration.hasMoreElements()) {
                stringArray[n2++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public void DeleteObject(String string) {
        this.hashtable.remove(string);
        this.modifiedFlag = true;
    }

    public void RenameObject(String string, String string2) {
        Object object = this.ReadObject(string);
        if (object != null) {
            this.DeleteObject(string);
            this.WriteObject(string2, object);
            this.modifiedFlag = true;
        }
    }

    public Object ReadObject(String string) {
        return this.hashtable.get(string);
    }

    public void WriteObject(String string, Object object) {
        this.hashtable.put(string, object);
        this.modifiedFlag = true;
    }

    public boolean PostVirtualDisk(String string, String string2) {
        boolean bl = false;
        if (this.modifiedFlag) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                bl = this.PostByteArrayFile(string, string2, byArray);
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException.getMessage());
            }
            if (bl) {
                this.modifiedFlag = false;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean PostByteArrayFile(String string, String string2, byte[] byArray) {
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            long l = System.currentTimeMillis();
            String string3 = "--------------------------" + l;
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
            uRLConnection.setUseCaches(false);
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBytes("--" + string3 + "\r\n");
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"filename\"; filename=\"" + string2 + "\"\r\n");
            dataOutputStream.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
            dataOutputStream.write(byArray);
            dataOutputStream.writeBytes("\r\n");
            dataOutputStream.writeBytes("--" + string3 + "--" + "\r\n\r\n");
            dataOutputStream.close();
            OutputStream outputStream = uRLConnection.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            InputStream inputStream = uRLConnection.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            String string4 = dataInputStream.readLine();
            while (string4 != null) {
                if (string4.indexOf("OK") != -1) {
                    bl = true;
                }
                string4 = dataInputStream.readLine();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MalformedURLException: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
        return bl;
    }
}

