/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Compiler;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import uk.co.visualisationsystems.QuickFire.Compiler.ArgList;
import uk.co.visualisationsystems.QuickFire.Compiler.Backend;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzInstruction;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzProgram;
import uk.co.visualisationsystems.QuickFire.Compiler.FunctionFrame;
import uk.co.visualisationsystems.QuickFire.Compiler.JvmData;
import uk.co.visualisationsystems.QuickFire.Compiler.Operand;
import uk.co.visualisationsystems.QuickFire.Compiler.ParserSupport;
import uk.co.visualisationsystems.QuickFire.Compiler.ParserTab;
import uk.co.visualisationsystems.QuickFire.Compiler.Symbol;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolOperand;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolTable;
import uk.co.visualisationsystems.QuickFire.LicenseManager.LicenseManager;
import uk.co.visualisationsystems.QuickFire.Runtime.JvmBase;
import uk.co.visualisationsystems.QuickFire.Runtime.QuickFireRuntime;

public class JvmBackend
extends Backend {
    private String programName;
    private String runtimeClassName;
    private boolean htmlFlag = false;
    private boolean quietFlag = false;
    private Type[] apply0args = Type.typeArray0;
    private ClassType integerClass;
    private ClassType longClass;
    private ClassType floatClass;
    private ClassType doubleClass;
    private ClassType stringClass;
    private ClassType stringBufferClass;
    private ClassType superClass;
    private ClassType quickFireClassType;
    private ConstantPool constantPool;
    private Method currentMethod;
    private CodeAttr constructorCodeAttr;
    private Field runtimeField;

    public void parseArgs(String[] stringArray) {
        this.quietFlag = false;
        this.htmlFlag = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].compareTo("-html") == 0) {
                    this.htmlFlag = true;
                } else if (stringArray[n].compareTo("-quiet") == 0) {
                    this.quietFlag = true;
                }
                ++n;
            }
        }
    }

    public void InstallSystemCalls(ParserTab parserTab, String string) throws Exception {
        String string2;
        ParserSupport parserSupport = parserTab.parserSupport;
        this.runtimeClassName = string;
        ClassType classType = ClassType.make(string);
        while (classType != null) {
            string2 = classType.getInternalName();
            if (!string2.startsWith("java", 0)) {
                this.InstallSystemCalls(parserSupport, classType);
            }
            classType = classType.getSuperclass();
        }
        if (!LicenseManager.isLicensed()) {
            throw new Exception("License not installed or not valid");
        }
        string2 = LicenseManager.getName() + " <" + LicenseManager.getEMail() + ">";
        if (!this.quietFlag) {
            System.out.println("QuickFire Compiler 1.0");
            System.out.println("Copyright (c) 2003 Visualisation Systems Ltd");
            System.out.println("This copy licensed to: " + string2);
        }
    }

    public void GenerateProgram(String string, ParserTab parserTab) {
        BlitzProgram blitzProgram = parserTab.parserSupport.program;
        this.programName = string;
        this.quickFireClassType = new ClassType(string);
        this.quickFireClassType.access_flags |= 0x21;
        this.quickFireClassType.setSuper("uk.co.visualisationsystems.QuickFire.Runtime.JvmBase");
        this.quickFireClassType.setSourceFile(string);
        this.superClass = this.quickFireClassType.getSuperclass();
        this.GenerateConstructor();
        this.GenerateSetRuntime(this.runtimeClassName);
        this.GenerateByteCode(blitzProgram);
    }

    public void ExecuteProgram(QuickFireRuntime quickFireRuntime) {
        byte[] byArray = this.quickFireClassType.writeToArray();
        this.ExecuteByteCode(byArray, this.programName, quickFireRuntime);
    }

    public byte[] getClassAsByteArray() {
        return this.quickFireClassType.writeToArray();
    }

    public void SaveAs(String string) {
        try {
            if (string.endsWith(".class")) {
                this.quickFireClassType.writeToFile(string);
            } else {
                this.quickFireClassType.writeToFile(string + ".class");
            }
            if (this.htmlFlag) {
                this.WriteHTML(string);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    private Type SymbolTypeToType(int n) {
        Type type;
        switch (n) {
            case 3: {
                type = Type.int_type;
                break;
            }
            case 4: {
                type = Type.long_type;
                break;
            }
            case 5: {
                type = Type.float_type;
                break;
            }
            case 6: {
                type = Type.double_type;
                break;
            }
            case 7: {
                type = Type.string_type;
                break;
            }
            default: {
                type = Type.void_type;
            }
        }
        return type;
    }

    private int TypeToSymbolType(Type type) {
        int n = 2;
        if (type.compare(Type.int_type) == 0) {
            n = 3;
        } else if (type.compare(Type.long_type) == 0) {
            n = 4;
        } else if (type.compare(Type.float_type) == 0) {
            n = 5;
        } else if (type.compare(Type.double_type) == 0) {
            n = 6;
        } else if (type.compare(Type.string_type) == 0) {
            n = 7;
        }
        return n;
    }

    private void InstallSystemCalls(ParserSupport parserSupport, ClassType classType) {
        Method method = classType.getMethod("<init>", this.apply0args);
        Method method2 = classType.getDeclaredMethods();
        while (method2 != null) {
            String string = method2.getName();
            if (string.compareTo("<init>") != 0) {
                Type type = method2.getReturnType();
                Type[] typeArray = method2.getParameterTypes();
                int n = this.TypeToSymbolType(type);
                Symbol symbol = parserSupport.DefineSystemCall(string, n);
                JvmData.setMethod(symbol, method2);
                int n2 = 0;
                while (n2 < typeArray.length) {
                    n = this.TypeToSymbolType(typeArray[n2]);
                    Symbol symbol2 = new Symbol("arg" + n2, 1, n);
                    SymbolOperand symbolOperand = new SymbolOperand(symbol2, -1);
                    symbol.argList.addElement(symbolOperand);
                    ++n2;
                }
            }
            method2 = method2.getNext();
        }
    }

    private void GenerateSetRuntime(String string) {
        Type type = Type.getType("uk.co.visualisationsystems.QuickFire.Runtime.QuickFireRuntime");
        Type type2 = Type.getType(string);
        this.runtimeField = this.quickFireClassType.addField("runtime", type2);
        PrimType primType = Type.void_type;
        Type[] typeArray = new Type[]{type};
        Method method = this.quickFireClassType.addMethod("setRuntime", 1, typeArray, primType);
        CodeAttr codeAttr = method.startCode();
        Variable variable = codeAttr.getArg(1);
        codeAttr.emitPushThis();
        codeAttr.emitLoad(variable);
        codeAttr.emitCheckcast(type2);
        codeAttr.emitPutField(this.runtimeField);
        codeAttr.emitReturn();
    }

    private void GenerateConstructor() {
        Method method = this.superClass.getMethod("<init>", this.apply0args);
        Method method2 = this.quickFireClassType.addMethod("<init>", 1, this.apply0args, Type.void_type);
        this.constructorCodeAttr = method2.startCode();
        this.constructorCodeAttr.emitPushThis();
        this.constructorCodeAttr.emitInvokeSpecial(method);
    }

    private void WriteHTML(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + ".html");
            if (fileOutputStream != null) {
                PrintStream printStream = new PrintStream(fileOutputStream);
                if (printStream != null) {
                    printStream.println("<head>");
                    printStream.println("<title>" + string + "</title>");
                    printStream.println("</head>");
                    printStream.println("<body>");
                    printStream.println("<applet code=\"uk.co.visualisationsystems.QuickFire.Applet.QuickFireApplet.class\" width=\"300\" height=\"200\" alt=\"Please Enable Java to view the QuickFire Applet\" vpsace=\"10\" hspace=\"10\">");
                    printStream.println("<param name=\"archive\" value=\"QuickFireRuntime.jar\">");
                    printStream.println("<param name=\"QuickFireClass\" value=\"" + string + "\">");
                    printStream.println("</applet>");
                    printStream.println("</body>");
                    printStream.println("</html>");
                }
                fileOutputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    private void ExecuteByteCode(byte[] byArray, String string, QuickFireRuntime quickFireRuntime) {
        String[] stringArray = new String[1];
        byte[][] byArrayArray = new byte[][]{byArray};
        stringArray[0] = string;
        ArrayClassLoader arrayClassLoader = new ArrayClassLoader(stringArray, byArrayArray);
        try {
            Class<?> clazz = arrayClassLoader.loadClass(string);
            JvmBase jvmBase = (JvmBase)clazz.newInstance();
            jvmBase.setRuntime(quickFireRuntime);
            jvmBase.main();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            System.err.println("InstantiationException: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("IllegalAccessException: " + illegalAccessException.getMessage());
        }
    }

    private void DumpConstantPool() {
        if (this.constantPool != null) {
            int n = this.constantPool.getCount();
            System.out.println(n + " constant(s) are in the constant pool");
            CpoolEntry cpoolEntry = this.constantPool.addInt(25);
            n = this.constantPool.getCount();
            System.out.println(n + " constant(s) are in the constant pool");
            int n2 = 0;
            while (n2 <= n) {
                cpoolEntry = this.constantPool.getPoolEntry(n2);
                System.out.println(n2 + ": " + cpoolEntry);
                ++n2;
            }
        } else {
            System.out.println("No constant pool found!");
        }
    }

    private void PushOperand(CodeAttr codeAttr, Operand operand) {
        if (operand instanceof SymbolOperand) {
            SymbolOperand symbolOperand = (SymbolOperand)operand;
            Symbol symbol = symbolOperand.GetSymbol();
            if (symbol.GetSymbolClass() == 3) {
                switch (operand.GetType()) {
                    case 3: {
                        codeAttr.emitPushInt(symbol.ival);
                        break;
                    }
                    case 4: {
                        codeAttr.emitPushLong(symbol.lval);
                        break;
                    }
                    case 5: {
                        codeAttr.emitPushFloat(symbol.fval);
                        break;
                    }
                    case 6: {
                        codeAttr.emitPushDouble(symbol.dval);
                        break;
                    }
                    case 7: {
                        codeAttr.emitPushString(symbol.sval);
                        break;
                    }
                    default: {
                        System.out.println("Push???:");
                        break;
                    }
                }
            } else if (symbolOperand.index != null) {
                if (JvmData.getVariable(symbol) != null) {
                    codeAttr.emitLoad(JvmData.getVariable(symbol));
                } else if (JvmData.getField(symbol) != null) {
                    codeAttr.emitPushThis();
                    codeAttr.emitGetField(JvmData.getField(symbol));
                } else {
                    System.out.println("InternalError: PushOperand()");
                }
                this.PushOperand(codeAttr, symbolOperand.index);
                codeAttr.emitArrayLoad(this.SymbolTypeToType(operand.GetType()));
            } else if (JvmData.getVariable(symbol) != null) {
                codeAttr.emitLoad(JvmData.getVariable(symbol));
            } else if (JvmData.getField(symbol) != null) {
                codeAttr.emitPushThis();
                codeAttr.emitGetField(JvmData.getField(symbol));
            } else {
                System.out.println("InternalError: PushOperand()");
            }
        }
    }

    private Variable DeclareLocal(CodeAttr codeAttr, Symbol symbol) {
        Type type;
        Type type2;
        int n = symbol.GetSymbolType();
        switch (n) {
            case 3: {
                type2 = Type.int_type;
                type = Type.int_type;
                break;
            }
            case 4: {
                type2 = Type.long_type;
                type = Type.long_type;
                break;
            }
            case 5: {
                type2 = Type.float_type;
                type = Type.float_type;
                break;
            }
            case 6: {
                type2 = Type.double_type;
                type = Type.double_type;
                break;
            }
            case 7: {
                type2 = Type.string_type;
                type = Type.string_type;
                break;
            }
            case 8: {
                type2 = Type.int_type;
                type = new ArrayType(Type.int_type);
                break;
            }
            case 9: {
                type2 = Type.long_type;
                type = new ArrayType(Type.long_type);
                break;
            }
            case 10: {
                type2 = Type.float_type;
                type = new ArrayType(Type.float_type);
                break;
            }
            case 11: {
                type2 = Type.double_type;
                type = new ArrayType(Type.double_type);
                break;
            }
            case 12: {
                type2 = Type.string_type;
                type = new ArrayType(Type.string_type);
                break;
            }
            default: {
                type2 = Type.void_type;
                type = Type.void_type;
            }
        }
        Variable variable = codeAttr.addLocal(type);
        if (type instanceof ArrayType) {
            int n2 = symbol.getArraySize();
            if (n2 > 0) {
                codeAttr.emitPushInt(n2);
                codeAttr.emitNewArray(type2);
                codeAttr.emitStore(variable);
            }
        } else if (symbol.GetSymbolClass() != 2) {
            switch (n) {
                case 3: {
                    codeAttr.emitPushInt(0);
                    codeAttr.emitStore(variable);
                    break;
                }
                case 4: {
                    codeAttr.emitPushLong(0L);
                    codeAttr.emitStore(variable);
                    break;
                }
                case 5: {
                    codeAttr.emitPushFloat(0.0f);
                    codeAttr.emitStore(variable);
                    break;
                }
                case 6: {
                    codeAttr.emitPushDouble(0.0);
                    codeAttr.emitStore(variable);
                    break;
                }
                case 7: {
                    codeAttr.emitPushString("");
                    codeAttr.emitStore(variable);
                    break;
                }
            }
        }
        return variable;
    }

    private Field DeclareStatic(Symbol symbol) {
        int n;
        Type type;
        Type type2;
        int n2 = symbol.GetSymbolType();
        switch (n2) {
            case 3: {
                type2 = Type.int_type;
                type = Type.int_type;
                break;
            }
            case 4: {
                type2 = Type.long_type;
                type = Type.long_type;
                break;
            }
            case 5: {
                type2 = Type.float_type;
                type = Type.float_type;
                break;
            }
            case 6: {
                type2 = Type.double_type;
                type = Type.double_type;
                break;
            }
            case 7: {
                type2 = Type.string_type;
                type = Type.string_type;
                break;
            }
            case 8: {
                type2 = Type.int_type;
                type = new ArrayType(Type.int_type);
                break;
            }
            case 9: {
                type2 = Type.long_type;
                type = new ArrayType(Type.long_type);
                break;
            }
            case 10: {
                type2 = Type.float_type;
                type = new ArrayType(Type.float_type);
                break;
            }
            case 11: {
                type2 = Type.double_type;
                type = new ArrayType(Type.double_type);
                break;
            }
            case 12: {
                type2 = Type.string_type;
                type = new ArrayType(Type.string_type);
                break;
            }
            default: {
                type2 = Type.void_type;
                type = Type.void_type;
            }
        }
        String string = symbol.GetSymbolName();
        Field field = this.quickFireClassType.addField(string, type);
        if (type instanceof ArrayType && (n = symbol.getArraySize()) > 0) {
            this.constructorCodeAttr.emitPushThis();
            this.constructorCodeAttr.emitPushInt(n);
            this.constructorCodeAttr.emitNewArray(type2);
            this.constructorCodeAttr.emitPutField(field);
        }
        return field;
    }

    private void PrePopOperand(CodeAttr codeAttr, Operand operand) {
        if (operand instanceof SymbolOperand) {
            SymbolOperand symbolOperand = (SymbolOperand)operand;
            Symbol symbol = symbolOperand.GetSymbol();
            if (symbolOperand.index != null) {
                if (JvmData.getVariable(symbol) != null) {
                    codeAttr.emitLoad(JvmData.getVariable(symbol));
                } else if (JvmData.getField(symbol) != null) {
                    codeAttr.emitPushThis();
                    codeAttr.emitGetField(JvmData.getField(symbol));
                } else {
                    System.out.println("InternalError: PrePopOperand()");
                }
                this.PushOperand(codeAttr, symbolOperand.index);
            } else if (JvmData.getField(symbol) != null) {
                codeAttr.emitPushThis();
            }
        }
    }

    private void PopOperand(CodeAttr codeAttr, Operand operand) {
        if (operand instanceof SymbolOperand) {
            SymbolOperand symbolOperand = (SymbolOperand)operand;
            Symbol symbol = symbolOperand.GetSymbol();
            if (symbolOperand.index != null) {
                codeAttr.emitArrayStore(this.SymbolTypeToType(operand.GetType()));
            } else if (JvmData.getVariable(symbol) != null) {
                codeAttr.emitStore(JvmData.getVariable(symbol));
            } else if (JvmData.getField(symbol) != null) {
                codeAttr.emitPutField(JvmData.getField(symbol));
            } else {
                System.out.println("InternalError: PopOperand()");
            }
        }
    }

    private void DeclareVariables(CodeAttr codeAttr, FunctionFrame functionFrame, boolean bl) {
        Vector vector = functionFrame.symbolTableList;
        int n = functionFrame.symbolTableList.size();
        int n2 = 0;
        while (n2 < n) {
            SymbolTable symbolTable = (SymbolTable)vector.elementAt(n2);
            Enumeration enumeration = symbolTable.hashTable.elements();
            while (enumeration.hasMoreElements()) {
                Symbol symbol = (Symbol)enumeration.nextElement();
                if (bl) {
                    if (JvmData.getField(symbol) != null || symbol.GetSymbolClass() != 1 && symbol.GetSymbolClass() != 2) continue;
                    JvmData.setField(symbol, this.DeclareStatic(symbol));
                    continue;
                }
                if (JvmData.getVariable(symbol) != null) continue;
                JvmData.setVariable(symbol, this.DeclareLocal(codeAttr, symbol));
            }
            ++n2;
        }
    }

    private void GenerateRelationalTest(CodeAttr codeAttr, Operand operand, Operand operand2, Operand operand3, int n) {
        Label label = new Label(this.currentMethod);
        Label label2 = new Label(this.currentMethod);
        this.PrePopOperand(codeAttr, operand3);
        this.PushOperand(codeAttr, operand);
        this.PushOperand(codeAttr, operand2);
        codeAttr.emitGotoIfCompare2(label, n);
        codeAttr.emitPushInt(0);
        codeAttr.emitGoto(label2);
        label.define(codeAttr);
        codeAttr.emitPushInt(1);
        label2.define(codeAttr);
        this.PopOperand(codeAttr, operand3);
    }

    private void DumpMethods(ClassType classType) {
        System.out.println("DumpMethods: " + classType);
        System.out.println("NumMethods: " + classType.getMethodCount());
        Method method = classType.getMethods();
        while (method != null) {
            String string = method.getName();
            Type type = method.getReturnType();
            Type[] typeArray = method.getParameterTypes();
            System.out.print(type + string);
            int n = 0;
            while (n < typeArray.length) {
                System.out.print(typeArray[n]);
                ++n;
            }
            System.out.println("");
            method = method.getNext();
        }
    }

    private void GenerateByteCode(BlitzProgram blitzProgram) {
        FunctionFrame functionFrame = blitzProgram.GetGlobalFunctionFrame();
        this.DeclareVariables(null, functionFrame, true);
        CodeAttr codeAttr = null;
        this.constantPool = this.quickFireClassType.getConstants();
        this.integerClass = ClassType.make("java.lang.Integer");
        this.longClass = ClassType.make("java.lang.Long");
        this.floatClass = ClassType.make("java.lang.Float");
        this.doubleClass = ClassType.make("java.lang.Double");
        this.stringClass = ClassType.make("java.lang.String");
        this.stringBufferClass = ClassType.make("java.lang.StringBuffer");
        Type[] typeArray = new Type[]{Type.int_type};
        Method method = this.integerClass.getMethod("toString", typeArray);
        typeArray[0] = Type.long_type;
        Method method2 = this.longClass.getMethod("toString", typeArray);
        typeArray[0] = Type.float_type;
        Method method3 = this.floatClass.getMethod("toString", typeArray);
        typeArray[0] = Type.double_type;
        Method method4 = this.doubleClass.getMethod("toString", typeArray);
        Method method5 = this.stringBufferClass.getDeclaredMethod("<init>", 0);
        Type[] typeArray2 = new Type[]{Type.string_type};
        Method method6 = this.stringBufferClass.getDeclaredMethod("append", typeArray2);
        Method method7 = this.stringBufferClass.getMethod("toString", this.apply0args);
        BlitzInstruction blitzInstruction = blitzProgram.first;
        while (blitzInstruction != null) {
            Operand operand = blitzInstruction.operand1;
            Operand operand2 = blitzInstruction.operand2;
            Operand operand3 = blitzInstruction.operand3;
            switch (blitzInstruction.opcode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!(operand instanceof SymbolOperand)) break;
                    Object object3 = (SymbolOperand)operand;
                    Object object2 = ((SymbolOperand)object3).GetSymbol();
                    if (JvmData.getLabel((Symbol)object2) == null) {
                        JvmData.setLabel((Symbol)object2, new Label(this.currentMethod));
                    }
                    JvmData.getLabel((Symbol)object2).define(codeAttr);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 8: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAdd(Type.int_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 9: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAdd(Type.long_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 10: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAdd(Type.float_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 11: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAdd(Type.double_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 12: {
                    this.PrePopOperand(codeAttr, operand3);
                    codeAttr.emitNew(this.stringBufferClass);
                    codeAttr.emitDup();
                    codeAttr.emitInvokeSpecial(method5);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitInvokeVirtual(method6);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitInvokeVirtual(method6);
                    codeAttr.emitInvokeVirtual(method7);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 13: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitSub(Type.int_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 14: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitSub(Type.long_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 15: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitSub(Type.float_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 16: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitSub(Type.double_type);
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitMul();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitDiv();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 25: 
                case 26: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitRem();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 27: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.int_type, Type.long_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 28: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.int_type, Type.float_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 29: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.int_type, Type.double_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 30: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitInvoke(method);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 31: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.long_type, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 32: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.long_type, Type.float_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 33: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.long_type, Type.double_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 34: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitInvoke(method2);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 35: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.float_type, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 36: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.float_type, Type.long_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 37: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.float_type, Type.double_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 38: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitInvoke(method3);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 39: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.double_type, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 40: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.double_type, Type.long_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 41: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitConvert(Type.double_type, Type.float_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 42: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitInvoke(method4);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 43: {
                    this.PrePopOperand(codeAttr, operand2);
                    codeAttr.emitPushInt(-1);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitXOr();
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 44: {
                    this.PrePopOperand(codeAttr, operand2);
                    codeAttr.emitPushLong(-1L);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitXOr();
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 45: 
                case 46: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAnd();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 47: 
                case 48: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitIOr();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 49: 
                case 50: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitXOr();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 51: 
                case 52: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitShl();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 53: 
                case 54: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitUshr();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 55: 
                case 56: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitShr();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 57: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 153);
                    break;
                }
                case 58: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 154);
                    break;
                }
                case 59: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 155);
                    break;
                }
                case 60: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 158);
                    break;
                }
                case 61: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 157);
                    break;
                }
                case 62: {
                    this.GenerateRelationalTest(codeAttr, operand, operand2, operand3, 156);
                    break;
                }
                case 63: {
                    this.PrePopOperand(codeAttr, operand2);
                    codeAttr.emitPushInt(1);
                    codeAttr.emitDup();
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitAnd();
                    codeAttr.emitXOr();
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 64: {
                    this.PrePopOperand(codeAttr, operand2);
                    codeAttr.emitPushLong(1L);
                    codeAttr.emitDup();
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitAnd();
                    codeAttr.emitXOr();
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 65: 
                case 66: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitAnd();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 67: 
                case 68: {
                    this.PrePopOperand(codeAttr, operand3);
                    this.PushOperand(codeAttr, operand);
                    this.PushOperand(codeAttr, operand2);
                    codeAttr.emitIOr();
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 69: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitPrimop(116, 1, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 70: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitPrimop(117, 1, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 71: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitPrimop(118, 1, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 72: {
                    this.PrePopOperand(codeAttr, operand2);
                    this.PushOperand(codeAttr, operand);
                    codeAttr.emitPrimop(119, 1, Type.int_type);
                    this.PopOperand(codeAttr, operand2);
                    break;
                }
                case 73: {
                    if (!(operand instanceof SymbolOperand)) break;
                    Object object3 = (SymbolOperand)operand;
                    Object object2 = ((SymbolOperand)object3).GetSymbol();
                    if (JvmData.getLabel((Symbol)object2) == null) {
                        JvmData.setLabel((Symbol)object2, new Label(this.currentMethod));
                    }
                    codeAttr.emitGoto(JvmData.getLabel((Symbol)object2));
                    break;
                }
                case 74: {
                    this.PushOperand(codeAttr, operand);
                    if (!(operand2 instanceof SymbolOperand)) break;
                    Object object3 = (SymbolOperand)operand2;
                    Object object2 = ((SymbolOperand)object3).GetSymbol();
                    if (JvmData.getLabel((Symbol)object2) == null) {
                        JvmData.setLabel((Symbol)object2, new Label(this.currentMethod));
                    }
                    codeAttr.emitGotoIfIntNeZero(JvmData.getLabel((Symbol)object2));
                    break;
                }
                case 75: {
                    this.PushOperand(codeAttr, operand);
                    if (!(operand2 instanceof SymbolOperand)) break;
                    Object object3 = (SymbolOperand)operand2;
                    Object object2 = ((SymbolOperand)object3).GetSymbol();
                    if (JvmData.getLabel((Symbol)object2) == null) {
                        JvmData.setLabel((Symbol)object2, new Label(this.currentMethod));
                    }
                    codeAttr.emitGotoIfIntEqZero(JvmData.getLabel((Symbol)object2));
                    break;
                }
                case 76: {
                    Object object;
                    int n;
                    Type[] typeArray3;
                    Type type;
                    Object object3 = operand.GetSymbol();
                    Object object2 = ((Symbol)object3).GetSymbolName();
                    switch (operand.GetType()) {
                        case 3: {
                            type = Type.int_type;
                            break;
                        }
                        case 4: {
                            type = Type.long_type;
                            break;
                        }
                        case 5: {
                            type = Type.float_type;
                            break;
                        }
                        case 6: {
                            type = Type.double_type;
                            break;
                        }
                        case 7: {
                            type = Type.string_type;
                            break;
                        }
                        case 8: {
                            type = new ArrayType(Type.int_type);
                            break;
                        }
                        case 9: {
                            type = new ArrayType(Type.long_type);
                            break;
                        }
                        case 10: {
                            type = new ArrayType(Type.float_type);
                            break;
                        }
                        case 11: {
                            type = new ArrayType(Type.double_type);
                            break;
                        }
                        case 12: {
                            type = new ArrayType(Type.string_type);
                            break;
                        }
                        default: {
                            type = Type.void_type;
                        }
                    }
                    Vector vector = ((Symbol)object3).argList;
                    int n2 = vector.size();
                    if (n2 > 0) {
                        typeArray3 = new Type[n2];
                        n = 0;
                        while (n < n2) {
                            object = (Operand)vector.elementAt(n);
                            if (object instanceof SymbolOperand) {
                                int n3 = ((Operand)object).GetType();
                                switch (n3) {
                                    case 3: {
                                        typeArray3[n] = Type.int_type;
                                        break;
                                    }
                                    case 4: {
                                        typeArray3[n] = Type.long_type;
                                        break;
                                    }
                                    case 5: {
                                        typeArray3[n] = Type.float_type;
                                        break;
                                    }
                                    case 6: {
                                        typeArray3[n] = Type.double_type;
                                        break;
                                    }
                                    case 7: {
                                        typeArray3[n] = Type.string_type;
                                        break;
                                    }
                                    case 8: {
                                        typeArray3[n] = new ArrayType(Type.int_type);
                                        break;
                                    }
                                    case 9: {
                                        typeArray3[n] = new ArrayType(Type.long_type);
                                        break;
                                    }
                                    case 10: {
                                        typeArray3[n] = new ArrayType(Type.float_type);
                                        break;
                                    }
                                    case 11: {
                                        typeArray3[n] = new ArrayType(Type.double_type);
                                        break;
                                    }
                                    case 12: {
                                        typeArray3[n] = new ArrayType(Type.string_type);
                                    }
                                }
                            }
                            ++n;
                        }
                    } else {
                        typeArray3 = this.apply0args;
                    }
                    this.currentMethod = this.quickFireClassType.addMethod((String)object2, 1, typeArray3, type);
                    JvmData.setMethod((Symbol)object3, this.currentMethod);
                    codeAttr = this.currentMethod.startCode();
                    vector = ((Symbol)object3).argList;
                    n = 0;
                    while (n < vector.size()) {
                        object = (Operand)vector.elementAt(n);
                        if (object instanceof SymbolOperand) {
                            SymbolOperand symbolOperand = (SymbolOperand)object;
                            Symbol symbol = symbolOperand.GetSymbol();
                            if (JvmData.getVariable(symbol) == null) {
                                JvmData.setVariable(symbol, codeAttr.getArg(n + 1));
                            } else {
                                System.out.println("Internal Error: Parameter already defined!");
                            }
                        }
                        ++n;
                    }
                    object = operand3.GetFunctionFrame();
                    this.DeclareVariables(codeAttr, (FunctionFrame)object, false);
                    break;
                }
                case 78: {
                    if (operand2 != null) {
                        this.PushOperand(codeAttr, operand2);
                    }
                    codeAttr.emitReturn();
                    break;
                }
                case 77: {
                    Object object2;
                    if (operand3 != null) {
                        this.PrePopOperand(codeAttr, operand3);
                    }
                    Object object3 = null;
                    object3 = operand2.GetArgList();
                    codeAttr.emitPushThis();
                    int n = 0;
                    while (n < ((ArgList)object3).argList.size()) {
                        object2 = (Operand)((ArgList)object3).argList.elementAt(n);
                        this.PushOperand(codeAttr, (Operand)object2);
                        ++n;
                    }
                    Type[] typeArray3 = operand.GetSymbol();
                    codeAttr.emitInvokeVirtual(JvmData.getMethod((Symbol)typeArray3));
                    if (operand3 == null) break;
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
                case 79: {
                    Object object2;
                    if (operand3 != null) {
                        this.PrePopOperand(codeAttr, operand3);
                    }
                    Object object3 = null;
                    object3 = operand2.GetArgList();
                    codeAttr.emitPushThis();
                    codeAttr.emitGetField(this.runtimeField);
                    int n = 0;
                    while (n < ((ArgList)object3).argList.size()) {
                        object2 = (Operand)((ArgList)object3).argList.elementAt(n);
                        this.PushOperand(codeAttr, (Operand)object2);
                        ++n;
                    }
                    Type[] typeArray3 = operand.GetSymbol();
                    codeAttr.emitInvokeVirtual(JvmData.getMethod((Symbol)typeArray3));
                    if (operand3 == null) break;
                    this.PopOperand(codeAttr, operand3);
                    break;
                }
            }
            blitzInstruction = blitzInstruction.next;
        }
        this.constructorCodeAttr.emitReturn();
    }
}

