/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import uk.co.visualisationsystems.QuickFire.Compiler.ArgList;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzInstruction;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzProgram;
import uk.co.visualisationsystems.QuickFire.Compiler.Operand;
import uk.co.visualisationsystems.QuickFire.Compiler.QuickFireRuntimeError;
import uk.co.visualisationsystems.QuickFire.Compiler.Symbol;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolOperand;
import uk.co.visualisationsystems.QuickFire.Runtime.QuickFireRuntime;

public class Interpreter
extends Thread {
    BlitzProgram program;
    QuickFireRuntime runtime;
    Class runtimeClass;

    public Interpreter(String string, BlitzProgram blitzProgram, QuickFireRuntime quickFireRuntime) {
        super(string);
        this.program = blitzProgram;
        this.runtime = quickFireRuntime;
        this.runtimeClass = quickFireRuntime.getClass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        int n = 0;
        ArgList argList = null;
        this.setPriority(1);
        Stack<BlitzInstruction> stack = new Stack<BlitzInstruction>();
        BlitzInstruction blitzInstruction = this.program.GetEntryPoint();
        while (blitzInstruction != null) {
            Operand operand = blitzInstruction.operand1;
            Operand operand2 = blitzInstruction.operand2;
            Operand operand3 = blitzInstruction.operand3;
            switch (blitzInstruction.opcode) {
                case 0: {
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 1: {
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 2: {
                    operand2.PutInteger(operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 3: {
                    operand2.PutLong(operand.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 4: {
                    operand2.PutFloat(operand.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 5: {
                    operand2.PutDouble(operand.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 6: {
                    operand2.PutString(operand.GetString());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 7: {
                    operand2.PutObjectArray(operand.GetObjectArray());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 8: {
                    operand3.PutInteger(operand.GetInteger() + operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 9: {
                    operand3.PutLong(operand.GetLong() + operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 10: {
                    operand3.PutFloat(operand.GetFloat() + operand2.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 11: {
                    operand3.PutDouble(operand.GetDouble() + operand2.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 12: {
                    operand3.PutString(operand.GetString() + operand2.GetString());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 13: {
                    operand3.PutInteger(operand.GetInteger() - operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 14: {
                    operand3.PutLong(operand.GetLong() - operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 15: {
                    operand3.PutFloat(operand.GetFloat() - operand2.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 16: {
                    operand3.PutDouble(operand.GetDouble() - operand2.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 17: {
                    operand3.PutInteger(operand.GetInteger() * operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 18: {
                    operand3.PutLong(operand.GetLong() * operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 19: {
                    operand3.PutFloat(operand.GetFloat() * operand2.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 20: {
                    operand3.PutDouble(operand.GetDouble() * operand2.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 21: {
                    operand3.PutInteger(operand.GetInteger() / operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 22: {
                    operand3.PutLong(operand.GetLong() / operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 23: {
                    operand3.PutFloat(operand.GetFloat() / operand2.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 24: {
                    operand3.PutDouble(operand.GetDouble() / operand2.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 25: {
                    operand3.PutInteger(operand.GetInteger() % operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 26: {
                    operand3.PutLong(operand.GetLong() % operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 27: {
                    operand2.PutLong(operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 28: {
                    operand2.PutFloat(operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 29: {
                    operand2.PutDouble(operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 30: {
                    operand2.PutString(Integer.toString(operand.GetInteger()));
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 31: {
                    operand2.PutInteger((int)operand.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 32: {
                    operand2.PutFloat(operand.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 33: {
                    operand2.PutDouble(operand.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 34: {
                    operand2.PutString(Long.toString(operand.GetLong()));
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 35: {
                    operand2.PutInteger((int)operand.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 36: {
                    operand2.PutLong((long)operand.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 37: {
                    operand2.PutDouble(operand.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 38: {
                    operand2.PutString(Float.toString(operand.GetFloat()));
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 39: {
                    operand2.PutInteger((int)operand.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 40: {
                    operand2.PutLong((long)operand.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 41: {
                    operand2.PutFloat((float)operand.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 42: {
                    operand2.PutString(Double.toString(operand.GetDouble()));
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 43: {
                    operand2.PutInteger(~operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 44: {
                    operand2.PutLong(operand.GetLong() ^ 0xFFFFFFFFFFFFFFFFL);
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 45: {
                    operand3.PutInteger(operand.GetInteger() & operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 46: {
                    operand3.PutLong(operand.GetLong() & operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 47: {
                    operand3.PutInteger(operand.GetInteger() | operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 48: {
                    operand3.PutLong(operand.GetLong() | operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 49: {
                    operand3.PutInteger(operand.GetInteger() ^ operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 50: {
                    operand3.PutLong(operand.GetLong() ^ operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 51: {
                    operand3.PutInteger(operand.GetInteger() << operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 52: {
                    operand3.PutLong(operand.GetLong() << (int)operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 53: {
                    operand3.PutInteger(operand.GetInteger() >> operand2.GetInteger() & Integer.MAX_VALUE);
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 54: {
                    operand3.PutLong(operand.GetLong() >> (int)operand2.GetLong() & Long.MAX_VALUE);
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 55: {
                    operand3.PutInteger(operand.GetInteger() >> operand2.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 56: {
                    operand3.PutLong(operand.GetLong() >> (int)operand2.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 63: {
                    if (operand.GetInteger() == 0) {
                        operand2.PutInteger(1);
                    } else {
                        operand2.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 64: {
                    if (operand.GetLong() == 0L) {
                        operand2.PutLong(1L);
                    } else {
                        operand2.PutLong(0L);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 65: {
                    if (operand.GetInteger() != 0 && operand2.GetInteger() != 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 66: {
                    if (operand.GetLong() != 0L && operand2.GetLong() != 0L) {
                        operand3.PutLong(1L);
                    } else {
                        operand3.PutLong(0L);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 67: {
                    if (operand.GetInteger() != 0 || operand2.GetInteger() != 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 68: {
                    if (operand.GetLong() != 0L || operand2.GetLong() != 0L) {
                        operand3.PutLong(1L);
                    } else {
                        operand3.PutLong(0L);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 69: {
                    operand2.PutInteger(-operand.GetInteger());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 70: {
                    operand2.PutLong(-operand.GetLong());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 71: {
                    operand2.PutFloat(-operand.GetFloat());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 72: {
                    operand2.PutDouble(-operand.GetDouble());
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 57: {
                    if (this.Compare(operand, operand2) == 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 58: {
                    if (this.Compare(operand, operand2) != 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 59: {
                    if (this.Compare(operand, operand2) < 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 60: {
                    if (this.Compare(operand, operand2) <= 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 61: {
                    if (this.Compare(operand, operand2) > 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 62: {
                    if (this.Compare(operand, operand2) >= 0) {
                        operand3.PutInteger(1);
                    } else {
                        operand3.PutInteger(0);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 73: {
                    blitzInstruction = (BlitzInstruction)operand.GetSymbol().valObject;
                    break;
                }
                case 74: {
                    if (operand.GetInteger() != 0) {
                        blitzInstruction = (BlitzInstruction)operand2.GetSymbol().valObject;
                        break;
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 75: {
                    if (operand.GetInteger() == 0) {
                        blitzInstruction = (BlitzInstruction)operand2.GetSymbol().valObject;
                        break;
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 76: {
                    Object[] objectArray;
                    int n2;
                    ArgList argList2 = operand2.GetArgList();
                    if (argList2 != null) {
                        n2 = argList2.argList.size();
                        if (argList != null) {
                            if (argList.argList.size() != n2) throw new QuickFireRuntimeError("Incorrect number of arguments", operand.sourceOffset);
                            int n3 = 0;
                            while (n3 < n2) {
                                objectArray = (Object[])argList.argList.elementAt(n3);
                                Operand operand4 = (Operand)argList2.argList.elementAt(n3);
                                if (objectArray instanceof SymbolOperand && operand4 instanceof SymbolOperand) {
                                    SymbolOperand symbolOperand = (SymbolOperand)objectArray;
                                    SymbolOperand symbolOperand2 = (SymbolOperand)operand4;
                                    if (symbolOperand.symbol.isArray() && !symbolOperand.isArrayAccess() || symbolOperand2.symbol.isArray() && !symbolOperand2.isArrayAccess()) {
                                        if (symbolOperand.symbol.isArray() && !symbolOperand.isArrayAccess() && symbolOperand2.symbol.isArray() && !symbolOperand2.isArrayAccess()) {
                                            symbolOperand2.PutObjectArray(symbolOperand.GetObjectArray());
                                        } else {
                                            System.out.println("Formal and Actual Arguments must both be Arrays");
                                        }
                                    } else {
                                        operand4.PutObject(objectArray.GetObject());
                                    }
                                } else {
                                    System.out.println("Invalid Arguments");
                                }
                                ++n3;
                            }
                        } else if (n2 > 0) {
                            throw new QuickFireRuntimeError("Arguments missing", operand.sourceOffset);
                        }
                    } else if (argList != null) {
                        throw new QuickFireRuntimeError("Arguments not expected", operand.sourceOffset);
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 77: {
                    argList = operand2.GetArgList();
                    stack.push(blitzInstruction);
                    blitzInstruction = (BlitzInstruction)operand.GetSymbol().valObject;
                    break;
                }
                case 78: {
                    Object[] objectArray;
                    if (stack.empty()) {
                        blitzInstruction = null;
                        break;
                    }
                    blitzInstruction = (BlitzInstruction)stack.pop();
                    if (operand2 != null) {
                        if (operand2 instanceof SymbolOperand && blitzInstruction.operand3 instanceof SymbolOperand) {
                            SymbolOperand symbolOperand = (SymbolOperand)operand2;
                            SymbolOperand symbolOperand3 = (SymbolOperand)blitzInstruction.operand3;
                            if (symbolOperand.GetSymbol().isArray() && !symbolOperand.isArrayAccess()) {
                                if (!symbolOperand3.GetSymbol().isArray() || symbolOperand3.isArrayAccess()) throw new QuickFireRuntimeError("Returning array to non-array", symbolOperand3.sourceOffset);
                                objectArray = symbolOperand.GetObjectArray();
                                symbolOperand3.PutObjectArray(symbolOperand.GetObjectArray());
                            } else {
                                blitzInstruction.operand3.PutObject(operand2.GetObject());
                            }
                        } else {
                            System.out.println("Both operands need to be SymbolOperand type");
                        }
                    }
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                case 79: {
                    this.InvokeSystemCall(operand, operand2, operand3);
                    blitzInstruction = blitzInstruction.next;
                    break;
                }
                default: {
                    int n2 = 0;
                    if (operand == null) throw new QuickFireRuntimeError("Unsupported Runtime Instruction: " + blitzInstruction.opcode, 0);
                    n2 = operand.sourceOffset;
                    throw new QuickFireRuntimeError("Unsupported Runtime Instruction: " + blitzInstruction.opcode, 0);
                }
            }
            if (n++ <= 7690) continue;
            n = 0;
            Thread.yield();
        }
    }

    private int Compare(Operand operand, Operand operand2) {
        int n;
        block14: {
            block13: {
                int n2;
                Symbol symbol;
                Symbol symbol2 = operand != null ? operand.GetSymbol() : null;
                Symbol symbol3 = symbol = operand2 != null ? operand2.GetSymbol() : null;
                if (operand == null || operand2 == null) {
                    if (operand != null) {
                        throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - operand2 is null", operand.sourceOffset);
                    }
                    if (operand2 != null) {
                        throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - operand1 is null", operand2.sourceOffset);
                    }
                    throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - both operands are null", -1);
                }
                if (symbol2 == null || symbol == null) {
                    if (symbol2 != null) {
                        throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - symbol2 is null", operand.sourceOffset);
                    }
                    if (symbol != null) {
                        throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - symbol1 is null", operand2.sourceOffset);
                    }
                    throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - both symbols are null", -1);
                }
                int n3 = operand.GetType();
                if (n3 != (n2 = operand2.GetType())) break block13;
                switch (n3) {
                    case 3: {
                        int n4 = operand.GetInteger();
                        int n5 = operand2.GetInteger();
                        n = n4 < n5 ? -1 : (n4 > n5 ? 1 : 0);
                        break block14;
                    }
                    case 4: {
                        long l = operand.GetLong();
                        long l2 = operand2.GetLong();
                        n = l < l2 ? -1 : (l > l2 ? 1 : 0);
                        break block14;
                    }
                    case 5: {
                        float f = operand.GetFloat();
                        float f2 = operand2.GetFloat();
                        n = f < f2 ? -1 : (f > f2 ? 1 : 0);
                        break block14;
                    }
                    case 6: {
                        double d = operand.GetDouble();
                        double d2 = operand2.GetDouble();
                        n = d < d2 ? -1 : (d > d2 ? 1 : 0);
                        break block14;
                    }
                    case 7: {
                        String string = operand.GetString();
                        String string2 = operand2.GetString();
                        n = string.compareTo(string2);
                        break block14;
                    }
                    default: {
                        int n6 = operand != null ? operand.sourceOffset : -1;
                        throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - Invalid Type", n6);
                    }
                }
            }
            int n7 = operand != null ? operand.sourceOffset : -1;
            throw new QuickFireRuntimeError("Interpreter.Compare(): Internal Error - type1 <> type2", n7);
        }
        return n;
    }

    private void InvokeSystemCall(Operand operand, Operand operand2, Operand operand3) {
        try {
            Object object;
            Object object2;
            String string = operand.GetSymbolName();
            ArgList argList = operand2.GetArgList();
            int n = argList.argList.size();
            Class[] classArray = new Class[n];
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                object2 = (Operand)argList.argList.elementAt(n2);
                object = ((Operand)object2).GetSymbol();
                switch (((Operand)object2).GetType()) {
                    case 3: {
                        classArray[n2] = Integer.TYPE;
                        objectArray[n2] = new Integer(((Operand)object2).GetInteger());
                        break;
                    }
                    case 4: {
                        classArray[n2] = Long.TYPE;
                        objectArray[n2] = new Long(((Operand)object2).GetLong());
                        break;
                    }
                    case 5: {
                        classArray[n2] = Float.TYPE;
                        objectArray[n2] = new Float(((Operand)object2).GetFloat());
                        break;
                    }
                    case 6: {
                        classArray[n2] = Double.TYPE;
                        objectArray[n2] = new Double(((Operand)object2).GetDouble());
                        break;
                    }
                    case 7: {
                        classArray[n2] = Class.forName("java.lang.String");
                        objectArray[n2] = ((Operand)object2).GetString();
                        break;
                    }
                }
                ++n2;
            }
            object2 = this.runtimeClass.getMethod(string, classArray);
            if (object2 != null) {
                object = ((Method)object2).invoke((Object)this.runtime, objectArray);
                if (object != null) {
                    operand3.PutObject(object);
                }
            } else {
                System.out.println("InvokeSystemCall() - " + string + " not found");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            throw new ThreadDeath();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("NoSuchMethodException: " + noSuchMethodException.getMessage());
            throw new ThreadDeath();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException: " + illegalAccessException.getMessage());
            throw new ThreadDeath();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("java.lang.reflect.InvocationTargetException: " + invocationTargetException.getMessage());
            throw new ThreadDeath();
        }
    }
}

