package com.softviewtech.jbillboard;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import com.borland.jbcl.layout.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.applet.*;
import javax.swing.border.*;

/**
 * Title:        JBillboard
 * Description:  The builder for billboard applets.
 * Copyright:    Copyright (c) 2002
 * Company:      SoftView Technology
 * @author J.Y. Weng
 * @version 1.0
 */

public class Frame1 extends JFrame {
    JPanel contentPane;

    Dimension screenSize=Toolkit.getDefaultToolkit().getScreenSize();
    private Point originLocation=null;
    private boolean expanded=false;

    // Wizard: 1 - 2 - 3
    JPanel pnlStep1 = new JPanel();
    JPanel pnlStep2 = new JPanel();
    jbapplet bbApplet=new jbapplet();
    JPanel pnlStep3 = new JPanel();

    JLabel lblStep1 = new JLabel();
    JLabel lblStep2 = new JLabel();
    JLabel lblStep3 = new JLabel();
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout2 = new XYLayout();
    XYLayout xYLayout3 = new XYLayout();

    // components for panal step1
    // buttons
    JButton btnNext1 = new JButton("Next >>");
    JButton btnExit = new JButton("Exit");
    JButton btnHelp1 = new JButton("Help");
    JButton bntInputImg = new JButton("Add image file(s)");
    JButton btnProperties = new JButton("Set properties");
    JButton btnUp = new JButton();
    JButton btnDown = new JButton();
    JButton btnDel = new JButton();

    // components for panal step2
    // buttons
    JButton btnPrev2 = new JButton("<< Previous");
    JButton btnNext2 = new JButton("Next >>");
    JButton btnCancel2 = new JButton("Cancel");
    JButton btnHelp2 = new JButton("Help");


    // components for panal step3
    // buttons
    JButton btnPrev3 = new JButton("<< Previous");
    JButton btnNext3 = new JButton("Close");
    JButton btnCancel3 = new JButton("Cancel");
    JButton btnHelp3 = new JButton("Help");

    JRadioButton radStep3Choice1 = new JRadioButton();
    JRadioButton radStep3Choice2 = new JRadioButton();
    ButtonGroup bgrRadioBtn = new ButtonGroup();
    JButton btnSaveAs3Ch2 = new JButton("Save as");
    JButton btnShowinBrowser32 = new JButton("Show in browser");
    JButton btnOpen3Ch1 = new JButton("Open");
    JButton btnSave3Ch1 = new JButton("Save");
    JButton btnSaveAs3Ch1 = new JButton("Save as");
    JButton btnShowinBrowser31 = new JButton("Show in browser");
    JButton btnCopy3 = new JButton("Copy");
    JButton btnPaste3 = new JButton("Paste");

    JFileChooser folderChooser = new JFileChooser();

    JTextArea txtFileList = new JTextArea();


    JTextArea txtStep2 = new JTextArea();
    JScrollPane srlAppletWin = new JScrollPane();
    JPanel pnlAppletWin = new JPanel();
    JTextArea txtStep1 = new JTextArea();
    JFileChooser fileChooser = new JFileChooser(".");
    JTextArea txtPasteCode = new JTextArea();
    JLabel lblStep31 = new JLabel();
    JScrollPane srlPasteCodePane = new JScrollPane();
    JFileChooser fileChooserSave = new JFileChooser();


    // image filters
    imageFileFilter allFmtFilter, jpgFilter, gifFilter, bmpFilter, tifFilter,
                      pngFilter, pixFilter, pnmFilter;


    Toolkit toolkit=Toolkit.getDefaultToolkit();
    private int nImage=0;
    JScrollPane srlImagePane = new JScrollPane();

    // Table of images
    Object imageData[][]=new Object[0][10]; // the last 3 column are unvisible
    String imageColName[]={"Image file", "Pause (s)", "Transition", "Param",
                            "Direction", "URL", "Sound file", "","",""};

    private String HTMLPage1=null;  // used as URL of HTML page file to shown
    private String HTMLPage2=null;  // in a browser

    myTableModel tblImageModel=new myTableModel(imageData, imageColName);
    ImageJTable tblImage = new ImageJTable(tblImageModel);

    String strSampleWebpage=null;
    String strUserWebpage=null;

    int widthApplet, heightApplet;

    private DlgInputSN dlgInputSN;
    private boolean lairt=true;

    /**Construct the frame*/
    public Frame1() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);

        setIconImage(Toolkit.getDefaultToolkit().getImage(
                                                "icons/iconsoftview32.gif"));
        contentPane = (JPanel) this.getContentPane();
        setSize(new Dimension(630, 495)); //(int)screenSize.getHeight())); //));
        setTitle("JBillboard (Wizard)");


        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    /**Component initialization*/
    public void jbInit() throws Exception  {;
        lblStep1.setFont(new java.awt.Font("Dialog", 1, 14));
        lblStep1.setText("Step 1");
        lblStep2.setFont(new java.awt.Font("Dialog", 1, 14));
        lblStep2.setText("Step 2");
        lblStep3.setFont(new java.awt.Font("Dialog", 1, 14));
        lblStep3.setText("Step 3");
        pnlStep1.setLayout(xYLayout1);
        pnlStep2.setLayout(xYLayout2);
        pnlStep3.setLayout(xYLayout3);

        // Panel of the Step2 of the Wizard
        btnPrev2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnPrev2_actionPerformed(e);
            }
        });

        btnNext1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnNext1_actionPerformed(e);
            }
        });

        btnExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnExit_actionPerformed(e);
            }
        });

        btnNext2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnNext2_actionPerformed(e);
            }
        });

        btnPrev3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnPrev3_actionPerformed(e);
            }
        });
        txtStep2.setText("Preview the effects in the following window.");
        txtStep2.setBackground(UIManager.getColor("OptionPane.background"));
        txtStep2.setFont(new java.awt.Font("Dialog", 0, 13));
        srlAppletWin.getViewport().setBackground(Color.white);
        srlAppletWin.setPreferredSize(new Dimension(600, 140));
        pnlAppletWin.setLayout(new BorderLayout());

        bntInputImg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bntInputImg_actionPerformed(e);
            }
        });
        txtStep1.setText("Add image files into the list and set the properties for them.");
        txtStep1.setBackground(UIManager.getColor("OptionPane.background"));
        txtStep1.setFont(new java.awt.Font("Dialog", 0, 13));
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle("Open Files");
        fileChooser.setAutoscrolls(true);

        jpgFilter = new imageFileFilter(new String[]
                {"jpg", "jpeg"}, "JPEG Compressed Image");
        gifFilter = new imageFileFilter("gif", "GIF Image");
        bmpFilter = new imageFileFilter("bmp", "BMP Image");
        tifFilter = new imageFileFilter("tif", "TIF Image");
        pngFilter = new imageFileFilter("png", "PNG Image");
        pixFilter = new imageFileFilter("pix", "FlashPIX Image");
        pnmFilter = new imageFileFilter("pnm", "PNM Image Files");
        allFmtFilter = new imageFileFilter(new String[]
                {"jpg", "jpeg", "gif", "png"}, //, "bmp", "tif", "png", "pix", "pnm"},
                "All Formats");

        // formats of JAI filestore
        jpgFilter.setFormat("JPEG");
        bmpFilter.setFormat("BMP");
        tifFilter.setFormat("TIFF");
        pngFilter.setFormat("PNG");
        pnmFilter.setFormat("PNM");

        fileChooser.addChoosableFileFilter(jpgFilter);
        fileChooser.addChoosableFileFilter(gifFilter);
//        fileChooser.addChoosableFileFilter(bmpFilter);
//        fileChooser.addChoosableFileFilter(tifFilter);
        fileChooser.addChoosableFileFilter(pngFilter);
//        fileChooser.addChoosableFileFilter(pixFilter);
        fileChooser.addChoosableFileFilter(allFmtFilter);

        //previewer=new FilePreviewer(fileChooser);
        fileChooser.setAccessory(new FilePreviewer(fileChooser));
        fileChooser.setPreferredSize(new Dimension(440, 250));

        tblImage.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                tblImage_mouseClicked(e);
            }
            public void mouseReleased(MouseEvent e) {
                tblImage_mouseReleased(e);
            }
        });

        btnCopy3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCopy3_actionPerformed(e);
            }
        });
        lblStep31.setFont(new java.awt.Font("Dialog", 0, 13));
        lblStep31.setText("There are two operations:");

        fileChooserSave.setDialogType(JFileChooser.SAVE_DIALOG);
        fileChooserSave.setDialogTitle("Save as HTML File");
        fileChooserSave.setFileFilter(new HTMLFilter());

        folderChooser.setDialogTitle("Choose a folder");
//        folderChooser.setDialogType(JFileChooser.OPEN_DIALOG);
        folderChooser.setApproveButtonText("Choose");
        folderChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

        btnCancel2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCancel2_actionPerformed(e);
            }
        });
        btnCancel3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnCancel3_actionPerformed(e);
            }
        });

        btnUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnUp_actionPerformed(e);
            }
        });
        btnDel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnDel_actionPerformed(e);
            }
        });
        btnDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnDown_actionPerformed(e);
            }
        });
        srlImagePane.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                srlImagePane_mouseClicked(e);
            }
        });

        btnProperties.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnProperties_actionPerformed(e);
            }
        });
        btnHelp1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnHelp1_actionPerformed(e);
            }
        });
        btnHelp3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnHelp3_actionPerformed(e);
            }
        });
        btnHelp2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnHelp2_actionPerformed(e);
            }
        });
        btnNext3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnNext3_actionPerformed(e);
            }
        });
        radStep3Choice1.setText("Insert the HTML code below into an existing web page");
        radStep3Choice1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                radStep3Choice1_actionPerformed(e);
            }
        });
        radStep3Choice2.setText("Produce a new web page with the created banner in it");
        radStep3Choice2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                radStep3Choice2_actionPerformed(e);
            }
        });
        btnSaveAs3Ch2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnSaveAs3Ch2_actionPerformed(e);
            }
        });
        btnShowinBrowser32.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnShowinBrowser32_actionPerformed(e);
            }
        });
        btnOpen3Ch1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnOpen3Ch1_actionPerformed(e);
            }
        });
        btnSave3Ch1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnSave3Ch1_actionPerformed(e);
            }
        });
        pnlTitlePasteCode.setBackground(Color.lightGray);
        pnlTitlePasteCode.setLayout(new BorderLayout());
        lblTitlePasteCode.setBorder(BorderFactory.createEtchedBorder());
        lblTitlePasteCode.setText("The HTML code to be copied and pasted into your web page");
        pnlTitleWebpage.setBackground(Color.lightGray);
        pnlTitleWebpage.setBorder(BorderFactory.createEtchedBorder());
        pnlTitleWebpage.setLayout(new BorderLayout());
        btnSaveAs3Ch1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnSaveAs3Ch1_actionPerformed(e);
            }
        });

        btnPaste3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnPaste3_actionPerformed(e);
            }
        });
        btnShowinBrowser31.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnShowinBrowser31_actionPerformed(e);
            }
        });
        bgrRadioBtn.add(radStep3Choice1);
        bgrRadioBtn.add(radStep3Choice2);

        pnlStep1.add(lblStep1, new XYConstraints(20, 15, -1, -1));
        pnlStep1.add(txtStep1, new XYConstraints(20, 41, 502, 26));
        pnlStep1.add(srlImagePane, new XYConstraints(20, 165, 549, 238));
        pnlStep1.add(bntInputImg, new XYConstraints(20, 84, 142, 25));
        try {
            btnUp.setIcon(new ImageIcon(
                    new URL("jar:file:jbillboard.jar!/icons/iconup.gif")));
            btnDown.setIcon(new ImageIcon(
                    new URL("jar:file:jbillboard.jar!/icons/icondown.gif")));
            btnDel.setIcon(new ImageIcon(
                    new URL("jar:file:jbillboard.jar!/icons/icondel.gif")));
        } catch(Exception ex) {
            ex.printStackTrace();
        }

        // Panel of the Step1 of the Wizard
        btnUp.setEnabled(false);
        btnDown.setEnabled(false);
        btnDel.setEnabled(false);
        pnlStep1.add(btnUp, new XYConstraints(578, 207, 24, 22));
        pnlStep1.add(btnDel, new XYConstraints(578, 288, 24, 22));
        pnlStep1.add(btnDown, new XYConstraints(578, 233, 24, 22));
        pnlStep1.add(btnHelp1, new XYConstraints(543, 424, 62, 25));
        pnlStep1.add(btnNext1, new XYConstraints(340, 424, 80, 25));
        pnlStep1.add(btnExit, new XYConstraints(438, 424, 80, 25));
        btnProperties.setEnabled(false);
        pnlStep1.add(btnProperties, new XYConstraints(20, 123, 142, 25));
        srlImagePane.getViewport().add(tblImage, null);

        // Panel of the step2 of the Wizard
        pnlStep2.add(btnHelp2, new XYConstraints(543, 424, 62, 25));
        pnlStep2.add(btnNext2, new XYConstraints(340, 424, 80, 25));
        pnlStep2.add(btnCancel2, new XYConstraints(438, 424, 80, 25));
        pnlStep2.add(lblStep2, new XYConstraints(20, 15, -1, -1));
        pnlStep2.add(txtStep2, new XYConstraints(20, 41, 462, 27));
        pnlStep2.add(srlAppletWin, new XYConstraints(20, 78, 585, 326));
        pnlStep2.add(btnPrev2, new XYConstraints(228, 424, 102, 25));
        srlAppletWin.getViewport().add(pnlAppletWin, null);

        // Panel of the Step3 of the Wizard
        pnlStep3.add(btnHelp3, new XYConstraints(543, 424, 62, 25));
        pnlStep3.add(btnNext3, new XYConstraints(340, 424, 80, 25));
        pnlStep3.add(btnCancel3, new XYConstraints(438, 424, 80, 25));
        pnlStep3.add(btnPrev3, new XYConstraints(228, 424, 102, 25));

        pnlStep3.add(lblStep3, new XYConstraints(21, 13, -1, -1));
        pnlStep3.add(srlPasteCodePane, new XYConstraints(20, 140, 586, 152));
        pnlStep3.add(pnlTitlePasteCode, new XYConstraints(20, 120, 586, 20));
        pnlTitlePasteCode.add(lblTitlePasteCode, BorderLayout.WEST);
        srlPasteCodePane.getViewport().add(txtPasteCode, null);
        pnlStep3.add(lblStep31, new XYConstraints(20, 44, -1, -1));

        btnSaveAs3Ch2.setVisible(false);
        pnlStep3.add(btnSaveAs3Ch2, new XYConstraints(20, 120, 100, 25));
        btnShowinBrowser32.setVisible(false);
        btnShowinBrowser32.setEnabled(false);
        pnlStep3.add(btnShowinBrowser32, new XYConstraints(130, 120, 130, 25));

        btnSave3Ch1.setVisible(false);
        btnSave3Ch1.setEnabled(false);
        pnlStep3.add(btnOpen3Ch1, new XYConstraints(20, 320, 90, 25));
        btnOpen3Ch1.setVisible(false);
        pnlStep3.add(btnSave3Ch1, new XYConstraints(120, 320, 90, 25));
        btnSaveAs3Ch1.setVisible(false);
        btnSaveAs3Ch1.setEnabled(false);
        pnlStep3.add(btnSaveAs3Ch1, new XYConstraints(220, 320, 90, 25));
        btnShowinBrowser31.setVisible(false);
        btnShowinBrowser31.setEnabled(false);
        pnlStep3.add(btnShowinBrowser31, new XYConstraints(320, 320, 130, 25));

        pnlStep3.add(btnCopy3, new XYConstraints(526, 90, 80, 25));
        pnlStep3.add(btnPaste3, new XYConstraints(526, 325, 80, 25));
        pnlStep3.add(radStep3Choice1, new XYConstraints(20, 66, -1, -1));
        pnlStep3.add(radStep3Choice2, new XYConstraints(20, 87, -1, -1));

        pnlTitleWebpage.setVisible(false);
        pnlTitlePasteCode.setVisible(false);
        srlPasteCodePane.setVisible(false);
        srlWebpagePane.setVisible(false);
        btnCopy3.setVisible(false);
        btnPaste3.setVisible(false);

        srlWebpagePane.getViewport().add(txtWebpage, null);

        // for debug
        contentPane.add(pnlStep1, BorderLayout.CENTER);
    }
    /**Overridden so we can exit when window is closed*/
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            System.exit(0);
        }
    }

    void btnNext1_actionPerformed(ActionEvent e) {
        if(tblImage.getRowCount()<2) {
            JOptionPane.showMessageDialog(this,
                                            "At least two images are needed.");
            return;
        }

        contentPane.add(pnlStep2, BorderLayout.CENTER);
        pnlStep1.setVisible(false);
        pnlStep2.setVisible(true);

        // calculate the width and height of the Applet
        widthApplet=heightApplet=0;
        for(int i=0; i<tblImage.getRowCount(); i++) {
            Image img=tblImage.getImage(i);
            if(widthApplet<img.getWidth(this))
                widthApplet=img.getWidth(this);
            if(heightApplet<img.getHeight(this))
                heightApplet=img.getHeight(this);
        }
        initApplet();

        bbApplet.nImage=tblImage.getRowCount();

        for(int i=0; i<tblImage.getRowCount(); i++) {
            Object[] data=tblImage.getImageData(i);

            bbApplet.image[i]=(Image)data[7];

            // if pause or transition has not been assigned a value,
            // the default value is given
            if(data[1]==null)
                bbApplet.pause[i]="2";
            else
                bbApplet.pause[i]=(String)data[1];
            if(data[2]==null)
                bbApplet.transition[i]="Cut in";
            else
                bbApplet.transition[i]=(String)data[2];
            bbApplet.paramTrans[i]=(String)data[3];
            bbApplet.direction[i]=(String)data[4];
            bbApplet.url[i]=(String)data[5];

            if(data[6]!=null) {
                File f=new File((String)data[6]);
                try {
                    bbApplet.audio[i]=Applet.newAudioClip(f.toURL());
                }
                catch(MalformedURLException ex) {
                    ex.printStackTrace();
                    bbApplet.audio[i]=null;
                }
            }
            else
                bbApplet.audio[i]=null;

        }
        bbApplet.start();
    }

    void btnPrev2_actionPerformed(ActionEvent e) {
        // activize Panel of Step1
        contentPane.add(pnlStep1, BorderLayout.CENTER);
        pnlStep2.setVisible(false);
        pnlStep1.setVisible(true);

        bbApplet.stop();
    }

    void btnNext2_actionPerformed(ActionEvent e) {
        // activize Panel of Step3
        contentPane.add(pnlStep3, BorderLayout.CENTER);
        pnlStep2.setVisible(false);
        pnlStep3.setVisible(true);
        bbApplet.stop();

        StringBuffer sb=new StringBuffer("<!--    Begin: JBillboard    -->\n" +
"<APPLET CODE=\"jbapplet.class\" WIDTH=\"" + widthApplet +
    "\" HEIGHT=\""+heightApplet+"\">\n" +
"<PARAM NAME=COPYRIGHT VALUE=\"JBillboard Applet, Copyright (c) " +
    "2002, 2003 SoftView Technology, all rights reserved.\">\n" +
"<PARAM NAME=DOCUMENTATION VALUE=\"Documentation found at: " +
    "http://www.softviewtech.com/software/billboard/\">\n") ;

        for(int i=0; i<tblImage.getRowCount(); i++) {
            Object[] data=tblImage.getImageData(i);

sb.append("<PARAM NAME=image" + (i+1) + " VALUE=\"" + (String)data[0] + "\">\n");
//String paramPause=(
if(data[1]!=null)
sb.append("<PARAM NAME=pause" + (i+1) + " VALUE=\"" + (String)data[1] + "\">\n");
sb.append("<PARAM NAME=transition" + (i+1) + " VALUE=\"" + (String)data[2] + "\">\n");
if(data[2]!=null)
sb.append("<PARAM NAME=paraOfTransition" + (i+1) + " VALUE=\"" + (String)data[3] + "\">\n");
if(data[4]!=null)
sb.append("<PARAM NAME=direction" + (i+1) + " VALUE=\"" + (String)data[4] + "\">\n");
if(data[5]!=null)
sb.append("<PARAM NAME=URL" + (i+1) + " VALUE=\"" + (String)data[5] + "\">\n");
if(data[6]!=null)
sb.append("<PARAM NAME=audio" + (i+1) + " VALUE=\"" + (String)data[6] + "\">\n");
        } // for
        sb.append("</APPLET>\n<!--    End: JBillboard    -->");
        txtPasteCode.setText(sb.toString());
        sb=null;

strSampleWebpage=
"<HTML>\n<HEAD>\n" +
"<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=windows-1252\">" +
"<TITLE>\nJBillboard Test Page\n</TITLE>\n</HEAD>\n<BODY>\n" +
"This is a test page of the JBillboard<BR>\n" +
txtPasteCode.getText() +
"\n</BODY>\n</HTML>";



/*

"<!--    Begin: JBillboard    -->\n" +

        sb.append("</APPLET>\n<!--    End: JBillboard    -->"

*/




        if(radStep3Choice1.isSelected()) {
            String strUserPage=txtWebpage.getText();
            StringBuffer sb1=new StringBuffer(strUserPage);
            int begin=strUserPage.indexOf("<!--    Begin: JBillboard    -->");
            int end=strUserPage.indexOf("<!--    End: JBillboard    -->") +
                        (new String("<!--    End: JBillboard    -->")).length();

            if(begin!=-1) {
                sb1.replace(begin, end, txtPasteCode.getText());

                txtWebpage.setText(sb1.toString());
                btnShowinBrowser31.setEnabled(false);
            }
        }
        else if(radStep3Choice2.isSelected()) {
            txtWebpage.setText(strSampleWebpage);
            btnShowinBrowser32.setEnabled(false);
        }

        pnlStep3Expand(expanded);
    }

    void btnPrev3_actionPerformed(ActionEvent e) {
        // activize Panel of Step3
        contentPane.add(pnlStep2, BorderLayout.CENTER);
        pnlStep3.setVisible(false);
        pnlStep2.setVisible(true);
        if(expanded) {
            setLocation((int)getLocation().getX(), (int)originLocation.getY());
            setSize(630, 495);
        }
    }

    private void initApplet() {
            // add in Applet
        pnlAppletWin.add(bbApplet, BorderLayout.CENTER);

        bbApplet.setSize(widthApplet, heightApplet);
        bbApplet.init();

        pnlAppletWin.setPreferredSize(new Dimension(widthApplet, heightApplet));
    }

    void bntInputImg_actionPerformed(ActionEvent e) {
        if(tblImage.getRowCount()>=12) {
            JOptionPane.showMessageDialog(this,
                                        "At most twelve images can be added.");
            return;
        }
        int option=fileChooser.showOpenDialog(this);
        if(option==fileChooser.CANCEL_OPTION)
            return;
        if(option==fileChooser.APPROVE_OPTION) {
    //    srcImage1=JAI.create("fileload", fileChooser.getSelectedFile().getPath());
            File[] f=fileChooser.getSelectedFiles();
            Image image=null;
            for(int i=0; i<f.length; i++) {
                //srcImage1=JAI.create("fileload", f[i].getPath());
                image=toolkit.getImage(f[i].getPath());
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }

                tblImage.addImageData(image, f[i]);
            }
        }
    }

    void tblImage_mouseClicked(MouseEvent e) {
        if(tblImage.getSelectedRow()==-1) {
            btnProperties.setEnabled(false);
            btnUp.setEnabled(false);
            btnDown.setEnabled(false);
            btnDel.setEnabled(false);
        }
        else {
            btnProperties.setEnabled(true);
            btnUp.setEnabled(true);
            btnDown.setEnabled(true);
            btnDel.setEnabled(true);
        }
    }

    void showDlgInputSN() {
        if(svt()) {
            lairt=false;
            return;
        }

        dlgInputSN=new DlgInputSN(this, "Enter the Serial Number", true);

        // locates the dialog panel
        Dimension dlgSize = dlgInputSN.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlgInputSN.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x,
                                 (frmSize.height - dlgSize.height) / 2 + loc.y);

        dlgInputSN.show();
        lairt=dlgInputSN.getLairt();
    }

    // invoked by enents of doubleclick and bntSetProperties
    private void setImageProperties() {
        int row=tblImage.getSelectedRow();

        DlgImageProp dlgImageProp=
                        new DlgImageProp(this, "Set Image Properties", true);

        // locates the dialog panel
        Dimension dlgSize = dlgImageProp.getPreferredSize();
        Dimension frmSize = getSize();
        Point loc = getLocation();
        dlgImageProp.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x,
                                 (frmSize.height - dlgSize.height) / 2 + loc.y);

        Object[] initValue=tblImage.getImageData(row);

        dlgImageProp.setInitValues(initValue);
        dlgImageProp.show();

        Object[] selectedValue=dlgImageProp.getSelectedValues();

        tblImage.setImageData(row, selectedValue);

        // special process for transition of flip
        if(selectedValue[2]!=null && selectedValue[2].equals("Flip")) {
            String strwStrap=(String)selectedValue[3];
            for(int r=0; r<tblImage.getRowCount(); r++)
                if((tblImage.getValueAt(r, 2))!=null &&
                   (tblImage.getValueAt(r, 2)).equals("Flip"))
                    tblImage.setValueAt(strwStrap, r, 3);
        }

        initValue=null;
    }

    // The number of milliseconds that should bound a double click.
    static private long mouseDoubleClickThreshold	= 300L;
    // The previous mouseUp event's time.
    private long mouseUpClickTime = 0;
    JScrollPane srlWebpagePane = new JScrollPane();
    JTextArea txtWebpage = new JTextArea();
    JPanel pnlTitlePasteCode = new JPanel();
    JLabel lblTitlePasteCode = new JLabel();
    JPanel pnlTitleWebpage = new JPanel();
    JLabel lblTitleWebpage = new JLabel();

    void tblImage_mouseReleased(MouseEvent e) {
	long eventTime = e.getWhen();
	long timeDiff;

	timeDiff = eventTime - mouseUpClickTime;
	if (timeDiff < 0)
	    timeDiff = -timeDiff;

	if (mouseDoubleClickThreshold > timeDiff)
	    {
	    // Yep, double click!.
            // put event process here
            setImageProperties();
            // End of double click event process
	    mouseUpClickTime = 0;
        }
	else {
	    // Update the event time holder.
	    mouseUpClickTime = eventTime;
        }
    }

    void btnProperties_actionPerformed(ActionEvent e) {
        setImageProperties();
    }

    void btnExit_actionPerformed(ActionEvent e) {
        this.dispose();
        System.exit(0);
    }

    void btnCopy3_actionPerformed(ActionEvent e) {
        txtPasteCode.selectAll();
        txtPasteCode.copy();
    }

    private void Cancel() {
        tblImage.removeAll();
        contentPane.add(pnlStep1, BorderLayout.CENTER);
        pnlStep1.setVisible(true);
    }

    void btnCancel2_actionPerformed(ActionEvent e) {
        bbApplet.stop();
        pnlStep2.setVisible(false);
        Cancel();
    }

    void btnCancel3_actionPerformed(ActionEvent e) {
        pnlStep3.setVisible(false);
        if(expanded) {
            setLocation((int)getLocation().getX(), (int)originLocation.getY());
            setSize(630, 495);
        }
        Cancel();
    }

    void btnUp_actionPerformed(ActionEvent e) {
        tblImage.moveSelectedRowsUp();
    }

    void btnDown_actionPerformed(ActionEvent e) {
        tblImage.moveSelectedRowsDown();
    }

    void btnDel_actionPerformed(ActionEvent e) {
        tblImage.removeSelectedRows();
        if(tblImage.getSelectedRow()==-1) {
            btnProperties.setEnabled(false);
            btnUp.setEnabled(false);
            btnDown.setEnabled(false);
            btnDel.setEnabled(false);
        }
    }

    void srlImagePane_mouseClicked(MouseEvent e) {
        // deselect rows in the table of tblImage
    }

    void btnHelp1_actionPerformed(ActionEvent e) {
        HelpBrowser helpBrowser=new HelpBrowser(
//            "file:docs/helpstep1.html");
            "jar:file:jbillboard.jar!/docs/helpstep1.html");
    }

    void btnHelp2_actionPerformed(ActionEvent e) {
        HelpBrowser helpBrowser=new HelpBrowser(
            "jar:file:jbillboard.jar!/docs/helpstep2.html");
    }

    void btnHelp3_actionPerformed(ActionEvent e) {
        HelpBrowser helpBrowser=new HelpBrowser(
            "jar:file:jbillboard.jar!/docs/helpstep3.html");
    }

    void btnNext3_actionPerformed(ActionEvent e) {
        dispose();
        System.exit(0);
    }



    void copyApplet2Dir(String sdir) {
        File dir=new File(sdir);
//        if(!dir.isDirectory())
//            dir.mkdir();
        try {
            URL urlSrc=null;
            if(!lairt)
                urlSrc=new URL("jar:file:jbillboard.jar!/docs/a.bin");
            else
                urlSrc=new URL("jar:file:jbillboard.jar!/docs/b.bin");

            InputStream src=urlSrc.openStream();
            FileOutputStream applet=new FileOutputStream(
                                            dir.getPath()+"/jbapplet.class");
            int i;
            while((i=src.read())!=-1) {
                applet.write(i^0x63);
//                applet.write(i);
            }
            applet.flush();
            applet.close();

            // copy jbapplet$1.class
            urlSrc=new URL("jar:file:jbillboard.jar!/docs/c.bin");
            src=urlSrc.openStream();
            applet=new FileOutputStream(dir.getPath()+"/jbapplet$1.class");
            while((i=src.read())!=-1) {
//                applet.write(i^0x63);
                applet.write(i);
            }
            applet.flush();
            applet.close();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean svt() {
        int in;
        long s=0;
        Random rdm=new Random(19900719);
        File f=new File("sn.txt");
        if(!f.isFile())
            return false;
        try {
            FileReader r=new FileReader(f);

            for(int i=0; i<10; i++) {
                in=r.read();
                if(in==-1)
                    return false;
                s=s*10+in-'0';
            }
            // range !!!
            for(int i=0; i<100; i++) {
                if((rdm.nextLong()&9999999999L)==s)
                    return true;
            }
            return false;
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    void btnChooseFolder_actionPerformed(ActionEvent e) {

        int option=folderChooser.showDialog(this, "Choose Folder");
        if(option==folderChooser.CANCEL_OPTION)
            return;
        if(option==folderChooser.APPROVE_OPTION) {
            File dir=folderChooser.getSelectedFile();
            try {
                // copy image files
     //           filecopy(String

                // copy audio files

                // copy the Applet

 //               f.createNewFile();
                FileWriter fw=new FileWriter("sss");
     //           fw.write(htmlcode);
       //         fw.flush();
         //       fw.close();
            }
            catch(Exception ex) {
                ex.printStackTrace();
            }

            JOptionPane.showMessageDialog(this,
                "The HTML page has been saved as\n"); //+f.getPath());
        }


    }

    // choice 2: save sample web page
    void radStep3Choice2_actionPerformed(ActionEvent e) {
        if(radStep3Choice2.isSelected()) {
            btnSaveAs3Ch2.setVisible(true);

            btnOpen3Ch1.setVisible(false);
            btnSave3Ch1.setVisible(false);
            btnSaveAs3Ch1.setVisible(false);
            btnShowinBrowser31.setVisible(false);
            btnShowinBrowser32.setVisible(true);

            btnCopy3.setVisible(false);
            btnPaste3.setVisible(false);


            pnlTitlePasteCode.setVisible(false);
            srlPasteCodePane.setVisible(false);

            pnlTitleWebpage.setVisible(true);
            srlWebpagePane.setVisible(true);

            if(lblTitleWebpage==null)
                lblTitleWebpage.setText("Example web page");

            txtWebpage.setText(strSampleWebpage);

            pnlStep3Expand(false);
        }
    }
    // choice 1: edit existing web page
    void radStep3Choice1_actionPerformed(ActionEvent e) {
        if(radStep3Choice1.isSelected()) {
            btnOpen3Ch1.setVisible(true);
            btnSave3Ch1.setVisible(true);
            btnSaveAs3Ch1.setVisible(true);
            btnShowinBrowser31.setVisible(true);

            btnCopy3.setVisible(true);
            btnPaste3.setVisible(true);

            txtWebpage.setText("");

            btnSaveAs3Ch2.setVisible(false);
            btnShowinBrowser32.setVisible(false);

            pnlTitlePasteCode.setVisible(true);
            srlPasteCodePane.setVisible(true);

            pnlTitleWebpage.setVisible(true);
            srlWebpagePane.setVisible(true);


            // The frame need to expand in y direction
            pnlStep3Expand(true);

        }
    }

    private String produceNewWebPage() {
        return(
"<HTML>\n<HEAD>\n" +
"<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=windows-1252\">" +
"<TITLE>\nJBillboard Test Page\n</TITLE>\n</HEAD>\n<BODY>\n" +
"This is a test page of the JBillboard<BR>\n" +
txtPasteCode.getText() +
"\n</BODY>\n</HTML>");
    }

    /**
     * return the file name
     */
    private String filecopy(String source, String destFolder) {
        File fsource=new File(source);
        File fdest=new File(destFolder+fsource.getName());

        try {
            FileInputStream in=new FileInputStream(fsource);
            FileOutputStream out=new FileOutputStream(fdest);

            int i;
            while((i=in.read())!=-1) {
                out.write(i);
            }
            out.flush();
            out.close();
            in.close();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }

        return fsource.getName();
    }

    private void saveNcopyAll(JTextArea ta, File f) {
        BufferedWriter bw=null;

        try {
            bw=new BufferedWriter(new FileWriter(f));
            txtWebpage.write(bw);
        }
        catch(IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                bw.close();
            }
            catch(Throwable t) {}
        }

        int i=f.getPath().indexOf(f.getName());
        String folder=f.getPath().substring(0, i);
        StringBuffer fileList=new StringBuffer("jbapplet.class");

        copyApplet2Dir(folder);

        try {
            // copy image and audio files
            for(int row=0; row<tblImage.getRowCount(); row++) {
                // copy image files
                fileList.append(",\n"+
                    filecopy((String)tblImage.getValueAt(row, 8), folder));

                // copy audio files
                if(tblImage.getValueAt(row, 9)!=null &&
                            !tblImage.getValueAt(row, 9).equals("")) {
                    fileList.append(",\n"+
                        filecopy((String)tblImage.getValueAt(row, 9),
                                                                folder));
                }
            }
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }

        JOptionPane.showMessageDialog(this,
            "The web page has been saved as "+f.getName() + ".\n" +
            "Teh following files also have been saved into the same folder:\n" +
            fileList.toString() + ".");;
    }

    void btnSaveAs3Ch2_actionPerformed(ActionEvent e) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setDialogType(JFileChooser.SAVE_DIALOG);
        fChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fChooser.setDialogTitle("Save as HTML File");
        fChooser.setFileFilter(new HTMLFilter());

        int option=fChooser.showSaveDialog(this);
        if(option==fChooser.CANCEL_OPTION)
            return;
        if(option==fChooser.APPROVE_OPTION) {
            File f=fChooser.getSelectedFile();
            String fn=f.getName().toLowerCase();
            if(!(fn.endsWith(".html") || fn.endsWith(".htm"))) {
                f=new File(f.getPath()+".html");
            }
            saveNcopyAll(txtWebpage, f);
            lblTitleWebpage.setText(f.getPath());
            btnShowinBrowser32.setEnabled(true);
        }
    }

    void btnShowinBrowser32_actionPerformed(ActionEvent e) {
        BrowserControl.displayURL(
            "file:///" + lblTitleWebpage.getText());
    }
    void btnShowinBrowser31_actionPerformed(ActionEvent e) {
        BrowserControl.displayURL(
            "file:///" + lblTitleWebpage.getText());
    }

    void btnOpen3Ch1_actionPerformed(ActionEvent e) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setDialogType(JFileChooser.OPEN_DIALOG);
        fChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fChooser.setDialogTitle("Open HTML File");
        fChooser.setFileFilter(new HTMLFilter());

        int option=fChooser.showOpenDialog(this);
        if(option==fChooser.CANCEL_OPTION)
            return;
        if(option==fChooser.APPROVE_OPTION) {
            File f=fChooser.getSelectedFile();
            BufferedReader br = null;
            lblTitleWebpage.setText(f.getPath());   // used for Save operation

            try {
                br=new BufferedReader(new FileReader(f));

                txtWebpage.read(br, null);
            } catch (IOException ex) {
                ex.printStackTrace();
            } finally {
                try {
                    br.close();
                } catch (Throwable t) {}
            }

            btnShowinBrowser31.setEnabled(true);
            btnSaveAs3Ch1.setEnabled(true);
            lblTitleWebpage.setText(f.getPath());
            txtWebpage.getDocument().addDocumentListener(
                                                    new myDocumentListener());
        }

    }

    void btnSave3Ch1_actionPerformed(ActionEvent e) {
        saveNcopyAll(txtWebpage, new File(lblTitleWebpage.getText()));
        btnShowinBrowser31.setEnabled(true);
    }
    void btnSaveAs3Ch1_actionPerformed(ActionEvent e) {
        JFileChooser fChooser = new JFileChooser();
        fChooser.setDialogType(JFileChooser.SAVE_DIALOG);
        fChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fChooser.setDialogTitle("Save as HTML File");
        fChooser.setFileFilter(new HTMLFilter());

        int option=fChooser.showSaveDialog(this);
        if(option==fChooser.CANCEL_OPTION)
            return;
        if(option==fChooser.APPROVE_OPTION) {
            File f=fChooser.getSelectedFile();
            String fn=f.getName().toLowerCase();
            if(!(fn.endsWith(".html") || fn.endsWith(".htm"))) {
                f=new File(f.getPath()+".html");
            }
            saveNcopyAll(txtWebpage, f);
            lblTitleWebpage.setText(f.getPath());
            btnShowinBrowser31.setEnabled(true);
        }
    }

    void pnlStep3Expand(boolean expand) {
        // locate the wizard buttons
        int locy=expand? (int)screenSize.getHeight()-70: 424;
        pnlStep3.add(btnHelp3, new XYConstraints(543, locy, 62, 25));
        pnlStep3.add(btnNext3, new XYConstraints(340, locy, 80, 25));
        pnlStep3.add(btnCancel3, new XYConstraints(438, locy, 80, 25));
        pnlStep3.add(btnPrev3, new XYConstraints(228, locy, 102, 25));

        if(expand) {
            int h=(int)screenSize.getHeight()-355-105;
            pnlStep3.add(pnlTitleWebpage, new XYConstraints(20, 355, 586, 20));
            pnlStep3.add(srlWebpagePane, new XYConstraints(20, 375, 586, h));
            pnlTitleWebpage.add(lblTitleWebpage, BorderLayout.WEST);

            originLocation=getLocation();
            setLocation(originLocation.x, 0);
            setSize(630, (int)screenSize.getHeight()-1);
            expanded=true;
        }
        else {
            pnlStep3.add(pnlTitleWebpage, new XYConstraints(20, 155, 586, 20));
            pnlStep3.add(srlWebpagePane, new XYConstraints(20, 175, 586, 230));
            pnlTitleWebpage.add(lblTitleWebpage, BorderLayout.WEST);

            if(originLocation!=null)
                setLocation((int)getLocation().getX(),
                                        (int)originLocation.getY());
            setSize(630, 495);
            expanded=false;
        }
        paintAll(getGraphics());
    }

    void btnPaste3_actionPerformed(ActionEvent e) {
        txtWebpage.paste();
    }

    class myDocumentListener implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            btnSave3Ch1.setEnabled(true);
            setDirty();
        }
        public void removeUpdate(DocumentEvent e) {
            btnSave3Ch1.setEnabled(true);
            setDirty();
        }
        public void changedUpdate(DocumentEvent e) {
        //Plain text components don't fire these events
        }
        void setDirty() {
            if(radStep3Choice1.isSelected()) {
                btnShowinBrowser31.setEnabled(false);
            }
            else if(radStep3Choice2.isSelected()) {
                btnShowinBrowser32.setEnabled(false);
            }
        }
    }

}