/*
 * Decompiled with CFR 0.152.
 */
package jfr.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class FixedSizePanel
extends Panel {
    int width;
    int height;
    boolean fixed_preferred_size;
    int inset_h;
    int inset_v;
    int border_width;

    public FixedSizePanel(int in_width, int in_height) {
        this.width = in_width;
        this.height = in_height;
        this.fixed_preferred_size = false;
        this.inset_h = 4;
        this.inset_v = 2;
        this.border_width = 1;
    }

    public FixedSizePanel(int in_width, int in_height, boolean in_fixed_preferred_size, int in_inset_h, int in_inset_v, int in_border_width) {
        this.width = in_width;
        this.height = in_height;
        this.fixed_preferred_size = in_fixed_preferred_size;
        this.inset_h = in_inset_h;
        this.inset_v = in_inset_v;
        this.border_width = in_border_width;
    }

    public Dimension getMinimumSize() {
        int result_width = this.width;
        int result_height = this.height;
        if (this.width == -1 || this.height == -1) {
            Dimension normal = super.getMinimumSize();
            result_width = this.width == -1 ? normal.width : this.width;
            result_height = this.height == -1 ? normal.height : this.height;
        }
        return new Dimension(result_width, result_height);
    }

    public Dimension getPreferredSize() {
        if (!this.fixed_preferred_size) {
            return super.getPreferredSize();
        }
        int result_width = this.width;
        int result_height = this.height;
        if (this.width == -1 || this.height == -1) {
            Dimension normal = super.getPreferredSize();
            result_width = this.width == -1 ? normal.width : this.width;
            result_height = this.height == -1 ? normal.height : this.height;
        }
        return new Dimension(result_width, result_height);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.border_width > 0) {
            int x = 0;
            int y = 0;
            int w = this.getSize().width - 1;
            int h = this.getSize().height - 1;
            int i = 0;
            while (i < this.border_width) {
                g.drawRect(x++, y++, w--, h--);
                ++i;
            }
        }
    }

    public Insets getInsets() {
        Insets result = (Insets)super.getInsets().clone();
        result.top += this.inset_v;
        result.bottom += this.inset_v;
        result.left += this.inset_h;
        result.right += this.inset_h;
        return result;
    }
}

