#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
# QWN
#
# Checksess.pm - module to check the current session.

use session;
use config;

use CGI qw(:standard);
package checksess;

$version=0.8;
$timeout=300;

sub loadedproj{
        if ($session::projloaded==0){
                print CGI::redirect('index.cgi?action=error&string=That+action+cannot+be+completed+as+there+is+no+project+currently+loaded.');
                die;
        }
}

sub validsess{
        $invalid=0;
                if ($session::projloaded){
                if (($session::remoteaddr ne $ENV{REMOTE_ADDR})&&($session::remoteaddr ne "")) { $invalid=1;}
                if (($session::remotehost ne $ENV{REMOTE_HOST})&&($session::remotehost ne "")) {$invalid=1;}
                if (($session::httpuseragent ne $ENV{HTTP_USER_AGENT})&&($session::httpuseragent ne "")) {$invalid=1;}
                $t=time;
                if ($session::expires < $t) {$invalid=1; }
                $session::expires = $t +$timeout;
                &config::savesession;
                if ($invalid==1){
                        &config::saveconf;
                        # Redirect to new page.
                        print CGI::redirect('invsess.cgi');
                        die;
                }
        }
        $valid; # Returns a value
}

1;