/* LIST.C - This file is part of
Resolver for Windows, copyright (C) Fabrizio Gennari, 2000

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "resource.h"
#include "resolv.h"

extern unsigned char* query_rep;
extern int already_read;
extern BOOL idle;
HWND hwnd;
OPENFILENAME box;
char ext[]="txt";

void ListDomains(){
	int num,i,length,result,soa=0,timeout=20,err,errors;
	char dns[256],dns_name[256],host[256],message[256],*query,name[256],answer[256],fanswer[256],ftype[256],*cpu,*os;
	unsigned char cpulen,oslen;
	LV_ITEM linea;
	SOCKADDR_IN dns_addr;
	SOCKET sock;
	unsigned short int qdcount,ancount,nscount,arcount,anstype;
	num=ListView_GetItemCount(GetDlgItem(GetParent(hwnd),IDC_NS));
	for(i=0;i<num;i++)
		if (ListView_GetItemState(GetDlgItem(GetParent(hwnd),IDC_NS),i,LVIS_SELECTED)==LVIS_SELECTED)
			break;
	linea.iItem=i;
	linea.iSubItem=2;
	linea.mask=LVIF_TEXT;
	linea.pszText=dns;
	linea.cchTextMax=256;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	dns_addr.sin_port=htons(53);
	dns_addr.sin_family=AF_INET;
	dns_addr.sin_addr.S_un.S_addr=inet_addr(dns);
	memset(dns_addr.sin_zero,0,8);
	linea.pszText=dns_name;
	linea.iSubItem=1;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	linea.pszText=host;
	linea.iSubItem=0;
	ListView_GetItem(GetDlgItem(GetParent(hwnd),IDC_NS),&linea);
	length=0;
	while(1){
		length++;
		query=(char*)malloc(length);
		result=res_mkquery(0,host,1,252,0,0,0,query,length);
		if (result!=-1) break;
		free(query);
	}
	sprintf(message,"Domain list for %s",host);
	SetWindowText(hwnd,message);
	sock=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	setsockopt(sock,SOL_SOCKET, SO_SNDTIMEO, (char *)&timeout, sizeof(timeout));
	sprintf(message,"Connecting to %u.%u.%u.%u"
		,dns_addr.sin_addr.S_un.S_un_b.s_b1
		,dns_addr.sin_addr.S_un.S_un_b.s_b2
		,dns_addr.sin_addr.S_un.S_un_b.s_b3
		,dns_addr.sin_addr.S_un.S_un_b.s_b4);
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
	err=connect(sock,(SOCKADDR*)&dns_addr,16);
	if (err){
		sprintf(message,"Socket error, connection failed");
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
		return;
	}
	sprintf(message,"Connected, getting info");
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
	send(sock,((char*)(&result))+1,1,0);
	send(sock,((char*)(&result))+0,1,0);
	send(sock,query,result,0);
	do{
	already_read=-2;
	length=GetShortInt(sock);
	query_rep=(char*)malloc(length);
	GetShortInt(sock);//id
	GetByte(sock);//type
	errors=GetByte(sock);
	if (errors&15){
		switch(errors&15){
		case 1:
			strcpy(message,"Format error");
			break;
		case 2:
			strcpy(message,"Server failure");
			break;
		case 3:
			sprintf(message,"The host or domain %s does not exist",host);
			break;
		case 4:
			strcpy(message,"Not implemented");
			break;
		case 5:
			sprintf(message,"Server %s (%s) refused to answer",dns_name,dns);
			break;
		default:
			strcpy(message,"Unknown error");
		}
		SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
		return;
	}
	qdcount=GetShortInt(sock);
	ancount=GetShortInt(sock);
	nscount=GetShortInt(sock);
	arcount=GetShortInt(sock);
	if (ancount==0){
		closesocket(sock);
		break;
	}
	for(i=0;i<qdcount;i++){
		GetLabel(sock,name,already_read);
		GetTypeAndClass(sock);
	}
	for(i=0;i<ancount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
		switch(anstype){
		case 1:
			strcpy(ftype,"A");
			strcpy(fanswer,answer);
			break;
		case 2:
			strcpy(ftype,"NS");
			strcpy(fanswer,answer);
			break;
		case 5:
			strcpy(ftype,"CNAME");
			strcpy(fanswer,answer);
			break;
		case 6:
			soa++;
			strcpy(ftype,"SOA");
			strcpy(fanswer,answer);
			break;
		case 12:
			strcpy(ftype,"PTR");
			strcpy(fanswer,answer);
			break;
		case 13:
			strcpy(ftype,"HINFO");
			cpulen=answer[0];
			oslen=answer[answer[0]+1];
			cpu=(char*)malloc(cpulen+1);
			strncpy(cpu,answer+1,cpulen);
			cpu[cpulen]=0;
			os=(char*)malloc(oslen+1);
			strncpy(os,answer+2+cpulen,oslen);
			os[oslen]=0;
			sprintf(fanswer,"CPU %s, OS %s",cpu,os);
			free(cpu);
			free(os);
			break;
		case 15:
			strcpy(ftype,"MX");
			sprintf(fanswer,"%s (pref. %u)",answer+2,answer[0]*256+answer[1]);
			break;
		default:
			sprintf(ftype,"%u",anstype);
			sprintf(fanswer,"Unknown type %u",anstype);
		}
		linea.mask=LVIF_TEXT;
		linea.iItem=i;
		linea.iSubItem=0;
		linea.pszText=name;
		ListView_InsertItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		linea.iSubItem=1;
		linea.pszText=ftype;
		SendDlgItemMessage(hwnd,IDC_DOMAIN,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
		linea.iSubItem=2;
		linea.pszText=fanswer;
		SendDlgItemMessage(hwnd,IDC_DOMAIN,LVM_SETITEM,(WPARAM) 0,(LPARAM) &linea);
	}
	for(i=0;i<nscount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,name);
	}
	for(i=0;i<arcount;i++){
		GetLabel(sock,name,already_read);
		anstype=GetTypeAndClass(sock);
		GetAnswer(sock,anstype,answer);
	}
	UpdateWindow(hwnd);
	free(query_rep);
	}while (soa<2);
	closesocket(sock);
	sprintf(message,"Name server %s (%s) was queried",dns_name,dns);
	SetWindowText(GetDlgItem(hwnd,IDC_DOMSTATUS),message);
}

UINT APIENTRY hook(HWND hdlg, // handle to child dialog window
UINT uiMsg, // message identifier
WPARAM wParam, // message parameter
LPARAM lParam // message parameter
){
	switch(uiMsg){
	case WM_NOTIFY:
		if ((((LPOFNOTIFY)lParam)->hdr.code)==CDN_TYPECHANGE){
			if ((((LPOFNOTIFY)lParam)->lpOFN->nFilterIndex)==1)
				box.lpstrDefExt=ext;
			else box.lpstrDefExt=NULL;
		}
	default:
		;
	}
	return 0;
}

void save_list(HWND hwnd){
	int num_lines,i;
	const char* filter="text files\0*.txt\0All files\0*.*\0\0";
	char filename[256]="", item[256];
	FILE* result;
	LV_ITEM linea;
	box.lStructSize=sizeof(OPENFILENAME);
	box.hwndOwner=hwnd;
	box.lpstrFilter=filter;
	box.lpstrCustomFilter=NULL;
	box.lpstrFile=filename;
	box.nMaxFile=256;
	box.lpstrFileTitle=NULL;
	box.lpstrInitialDir=NULL;
	box.lpstrTitle=NULL;
	box.Flags=OFN_EXPLORER|OFN_HIDEREADONLY|OFN_ENABLEHOOK;
	box.lpfnHook=hook;
	box.lpstrDefExt=ext;
	if (GetSaveFileName(&box)==0) return;
	if ( (result=fopen(box.lpstrFile,"wb")) ==NULL){
		MessageBox(hwnd,box.lpstrFile,"Error in creating this file",MB_OK|MB_ICONERROR);
		return;
	}
	linea.mask=LVIF_TEXT;
	linea.pszText=item;
	linea.cchTextMax=256;
	num_lines=ListView_GetItemCount(GetDlgItem(hwnd,IDC_DOMAIN));
	for(i=0;i<num_lines;i++){
		linea.iItem=i;
		linea.iSubItem=0;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\t",item);
		linea.iSubItem=1;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\t",item);
		linea.iSubItem=2;
		ListView_GetItem(GetDlgItem(hwnd,IDC_DOMAIN),&linea);
		fprintf(result,"%s\n",item);
	}
	fclose(result);
}

LRESULT CALLBACK list_callback(HWND wind, // handle of window
UINT uMsg, // message identifier
WPARAM wParam, // first message parameter
LPARAM lParam // second message parameter
){
	switch (uMsg)
	{
	case WM_INITDIALOG:
		{
			LV_COLUMN colonna;
			char testo[6];
			colonna.mask=LVCF_TEXT|LVCF_WIDTH;
			colonna.pszText=testo;
			colonna.cx=100;
			strcpy(testo,"Entry");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),0,&colonna);
			strcpy(testo,"Value");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),2,&colonna);
			colonna.cx=50;
			strcpy(testo,"Type");
			ListView_InsertColumn(GetDlgItem(wind,IDC_DOMAIN),1,&colonna);
			hwnd=wind;
			return TRUE;
			break;
		}
	case WM_COMMAND:
			if(LOWORD(wParam)==IDOK)
			{
				EndDialog(hwnd,0);
				idle=0;
				return TRUE;
			}
			if(LOWORD(wParam)==IDC_SAVE)
			{
				save_list(hwnd);
			}
			break;
	default:
			return 0;
	}
}
