// file tcptun.h
//(C) 1996 Alessandro Mordacci   mordacci@xtreme.it
//(C) 1996 SMC Sistemi di Misura e Controllo
//    Via Caduti del Lavoro, 26 - Pisa (Italy)
//    Tel. +39 50 525484
#include <signal.h>
#include <process.h>
#include "lnk_util.h"
#include "dbg_util.h"

SOCKET skListen;
static SOCKADDR_IN sin;
int bExitNow = 0;
// Functions in this file:
//main(int argc, char *argv[])
void SetConnectAddress(void);
void DoAcceptLoop(void *lpArg);
void DoAccept(void);
void DoConnect(void *lpArg);
void ThreadDoLink(void *lpArg);
void DoLink( sock_pair *skp);
void setSignals(void);
void signalCatcher(void);
BOOL CtrlHandlerRoutine( DWORD  dwCtrlType);
int GetUserInput(void);

char *SERVER_ADDRESS;
u_short SERVER_PORT;

main(int argc, char *argv[])
{
 int ierr;
 char szErrBuff[256];
 cout<<"tcplink 0.1"<<endl;
 if (argc !=3) {
	 cerr<<"Usage: "<<argv[0]<<" server_addr server_port"<<endl;
	 mySleep(5);
	 exit(99);
 }
 SERVER_ADDRESS = argv[1];
 SERVER_PORT    = (u_short) atol(argv[2]);
 initWinsockLib();
 DebugMessage("Winsock initialized");

 SetConnectAddress();

 skListen = socket(PF_INET,SOCK_STREAM,0);
 if (skListen == INVALID_SOCKET)
	 socketErrorExit("Cannot Create socket for listening");
 ierr = bindMySocket(skListen);
 if (ierr == SOCKET_ERROR)
	 socketErrorExit("Cannot bind socket");

 ierr = listen(skListen,5);
 if (ierr == SOCKET_ERROR)
	 socketErrorExit("Cannot listen on socket");

 unsigned long ulThreadID;
 if ((ulThreadID = _beginthread(DoAcceptLoop,4096,NULL)) == (unsigned long)-1) {
	 cerr<<"Cannot create main service thread - error = "
		  <<GetSocketErrorText(szErrBuff,256)<<endl;
	 mySleep(5);
	 exit(1);
 } else {
	 DbgCoutMsg("MAin service thread (ID=") DbgMsg(ulThreadID)
	 DbgMsgLn(") started");
 }

 return GetUserInput();
}

void DoAcceptLoop(void *lpArg)
{
 for(;;)
	 DoAccept();
}

void SetConnectAddress(void)
{
 sin.sin_family = AF_INET;
 sin.sin_port = htons(SERVER_PORT);
 sin.sin_addr.s_addr =  inet_addr ( SERVER_ADDRESS );

 DbgCoutMsg("After accepting a connection I Will Connect to ")
		DbgMsg(SERVER_ADDRESS) DbgMsg(" port ") DbgMsg(SERVER_PORT);
 if (sin.sin_addr.s_addr == INADDR_NONE) {
	  //struct hostent FAR *phe;
	  PHOSTENT phe;
	  phe = gethostbyname ( SERVER_ADDRESS );
	  if (phe == NULL)
		  socketErrorExit("Cannot find Server Address");
          memcpy((char FAR *)&(sin.sin_addr), phe->h_addr, phe->h_length);
	  if (sin.sin_addr.s_addr == INADDR_NONE)
		  socketErrorExit("Cannot connect to Server: invalid address");
 }
 DbgCoutLn();
}

void DoAccept(void)
{
 if (bExitNow==1)
	 SuspendThread(GetCurrentThread());
 SOCKET skInside;
 char szErrBuff[256]; 
 skInside = accept ( skListen, 0, 0 );
 if (skInside == INVALID_SOCKET) {
		 cerr<<"Error from accept, error code = "<<GetSocketErrorText(szErrBuff,256)<<endl;
	 return;
 }

 unsigned long ulThreadID;
	 if ((ulThreadID = _beginthread(DoConnect,4096,(void *)skInside)) == (unsigned long)-1) {
	 cerr<<"Warning: cannot create connect thread - error = "
		  <<GetSocketErrorText(szErrBuff,256)<<endl;
	 closesocket(skInside);
 } else {
	 DbgCoutMsg("New thread (ID = ") DbgMsg(ulThreadID) DbgMsgLn(") started");
 }
}

void DoConnect(void *lpArg)
{
 int ierr;
 SOCKET skInside, skOutside;
 char szErrBuff[256];
 skInside = (SOCKET) lpArg;

 /* we have a connection from inside, now we connect to the outside ... */
  skOutside = socket(PF_INET,SOCK_STREAM,0);
 if (skOutside != INVALID_SOCKET)
	 ierr = connect ( skOutside, (LPSOCKADDR) &sin, sizeof (sin) );
 else
	 cout<<"Cannot create outside socket"<<endl;
 if (ierr == SOCKET_ERROR || skOutside == INVALID_SOCKET) {
	 cout <<"Cannot connect to server. Closing inside connection ...";
	 closesocket(skInside);
	 _endthread();
	 return ;
 }

 sock_pair skp_toOutside, skp_toInside;
 skp_toOutside.from = skInside;  skp_toOutside.to = skOutside;
 skp_toInside.from  = skOutside; skp_toInside.to  = skInside;

 unsigned long ulThreadID;
	 if ((ulThreadID = _beginthread(ThreadDoLink,4096,(void *) &skp_toOutside)) == (unsigned long)-1) {
	 cerr<<"Error: cannot create connect thread - error = "
	     <<GetSocketErrorText(szErrBuff,256)<<endl;
	 closesocket(skInside);
	 closesocket(skOutside);
	 _endthread();
	 return ;
 }
 DoLink(&skp_toInside);
 waitThread(ulThreadID, 300000);
 _endthread();
}

void ThreadDoLink(void *lpArg)
{
 DoLink( (sock_pair*) lpArg);
 _endthread();
}

void DoLink( sock_pair *skp)
{
 char szBuffer[BUFFER_SIZE+1];
 char szErrBuff[256]; szErrBuff,256;
 int iread, isend;
 for(;;) {
	 iread = recv ( skp->from, szBuffer, BUFFER_SIZE, 0 );

	 if (iread == 0) {
		 DebugMessage("Input socket closed");
		 shutdown(skp->to,1);
		 return;
	 } else if (iread == SOCKET_ERROR) {
		 int errnum = GetSocketError();
		 if ( (errnum!=0) && (errnum != ECONNRESET) ) 
			 cout<<"Warning: inside connection closed with error = "
				  <<GetSocketErrorText(errnum,szErrBuff,256)<<endl;
		 else
			 DebugMessage("Input socket closed");
		 shutdown(skp->to,1);
		 return;
	 } else {
		 isend = sendAllBytes( skp->to, szBuffer, iread, 0 );
		 if (isend == SOCKET_ERROR){
			 cout<<"Warning: Output connection closed in writing - error = "
				  <<GetSocketErrorText(szErrBuff,256)<<endl;
			 shutdown(skp->to,1);
			 shutdown(skp->from,0);
			 mySleep(10);
			 return;
		 }
	 }
 }
}

typedef void (*fptr)(int);

void setSignals(void)
{
 for (int i = 0; i<NSIG; i++) {
	 if ( signal(i, (fptr)signalCatcher) == SIG_IGN ) {
		 signal(i,SIG_IGN);
	 }
 }
 SetConsoleCtrlHandler((PHANDLER_ROUTINE)CtrlHandlerRoutine, TRUE );
}

void signalCatcher(void)
{
 DebugMessage("interrupt!");
 WSACleanup();
 DebugPause(5);
 exit(0);
}

BOOL CtrlHandlerRoutine( DWORD  dwCtrlType)
{
 DbgCoutMsg("Console ctrl event: ") DbgMsgLn(dwCtrlType);
 DebugPause(5);
 WSACleanup();
 exit(0);
 return TRUE;
}


int GetUserInput(void)
{
 setSignals();
 DebugMessage(" signals initialized");
 cout<<"Press 'q' + <return> to exit"<<endl;
 for(char c=' ';c!='q' && c!='Q'; cin.read(&c,1))
	 cout<<c;
 SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_HIGHEST);
 bExitNow = 1;
 DebugMessage("Releasing Winsock...");
 WSACleanup();
 DebugMessage("Winsock library released");
#ifdef DEBUG_OPTIONS
 cout<<"Press return to exit"<<endl;
 cin.read(&c,1);
#endif
 return 0;
}



