#
# webcalng - a web based calendar program.
# Copyright 2003 - webcalng software solutions
#

#
# This module provide subroutines to handle authentication.
#
# Any subroutines that require i/o to a file or db should be placed in 
# webcalng_auth_io.pm.
#

#
# This file contains perl subroutines used for htaccess style authentication.
#

package webcalng_auth;
use strict;
use webcalng_auth_io;

#
# Find out who they are logged in as.
#
sub get_username {
	my ($username);

	$username = "";
	$username = $ENV{'REMOTE_USER'} if ($ENV{'REMOTE_USER'});
	
	return $username;
}

#
# Encrypt a given password.
#
sub crypt_password {
	my ($username,$password) = (@_);
	my (@salts,$salt);
	$salt = webcalng_auth_io::get_salt($username);
	if (! $salt) {
		@salts    = ( 'A' .. 'Z', 'a' .. 'z', 0 .. 9, '.', '/' );
		$salt     = $salts[rand @salts] . $salts[rand @salts];
	}
	$password = crypt($password,$salt) or webcalng_subs::hard_error("Could not encrypt password: $!");
	return $password;
}

#
# The following subroutines for the most part just call a webcalng_auth_io
# subroutine to do their work.  We run everything through the webcalng_auth
# module from the main webcalng code, rather than calling the webcalng_auth_io
# directly.  This will make it easier for a developer to integrate webcalng
# into a custom authentication scheme for their site, as they will most likely
# only need to make changes to the webcalng_auth module to call their own code
# for authentication.
#

sub lookup_user {
	return webcalng_auth_io::lookup_user_io(@_);	
}

#
# One extra step in this subroutine - just need to encrypt the password
# before validating it with the io module.
#
sub validate_login {
	my ($user,$pass) = (@_);
	my ($valid,$crypted_pass);

	$crypted_pass = crypt_password($user,$pass);
	$valid        = webcalng_auth_io::validate_login_io($user,$crypted_pass);	

	return $valid;
}

#
# One extra step in this subroutine - just need to encrypt the password
# before validating it with the io module.
#
sub create_user {
	my ($user,$pass) = (@_);
	my ($crypted_pass);

	$crypted_pass = crypt_password($user,$pass);
	webcalng_auth_io::create_user_io($user,$crypted_pass);

	return 1;
}

sub get_user_list {
	return webcalng_auth_io::get_user_list_io(@_);	
}

sub remove_user {
	return webcalng_auth_io::remove_user_io(@_);	
}

1;
