/*
 * Decompiled with CFR 0.152.
 */
package com.synex.xml.sax;

import com.synex.xml.db.DBManagerImpl;
import com.synex.xml.sax.XMLHandler;
import com.synex.xml.sax.XMLHandlerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements LexicalHandler {
    private static Writer out;
    private XMLHandler handler;
    private String indentString = "    ";
    private int indentLevel = 0;
    private Stack context;
    private StringBuffer buffer = new StringBuffer();
    private boolean echo = false;
    private boolean validating = true;
    private boolean namespace = false;
    static /* synthetic */ Class class$com$synex$xml$sax$XMLParser;

    public XMLParser() {
        this(new XMLHandlerImpl());
    }

    public XMLParser(XMLHandler handler) {
        this.handler = handler;
        this.context = new Stack();
    }

    public void setEcho(boolean pEcho) {
        this.echo = pEcho;
    }

    public void setValidating(boolean pValidating) {
        this.validating = pValidating;
    }

    public void setNamespaceAware(boolean pNamespace) {
        this.namespace = pNamespace;
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.echo("LOCATOR\n SYS ID: " + locator.getSystemId());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        this.nl();
        this.nl();
        this.echo("START DOCUMENT");
        this.nl();
        this.echo("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.echo("END DOCUMENT");
        try {
            this.nl();
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qName, new AttributesImpl(attrs)});
        this.handler.startElement(qName, attrs);
        ++this.indentLevel;
        this.nl();
        this.echo("ELEMENT: ");
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.echo("<" + eName);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                this.nl();
                this.echo("   ATTR: " + aName + "\t\"" + attrs.getValue(i) + "\"");
                ++i;
            }
        }
        if (attrs.getLength() > 0) {
            this.nl();
        }
        this.echo(">");
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        this.handler.endElement(qName);
        this.nl();
        this.echo("END_ELM: ");
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.echo("</" + eName + ">");
        --this.indentLevel;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.buffer.append(buf, offset, len);
        this.nl();
        this.echo("CHARS:   ");
        String s = new String(buf, offset, len);
        if (!s.trim().equals("")) {
            this.echo(s);
        }
    }

    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.nl();
        this.echo("PROCESS: <?" + target + " " + data + "?>");
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        this.handler.handleElement(here, this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        this.buffer.delete(0, this.buffer.length());
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.nl();
        this.echo("END CDATA SECTION");
    }

    public void endEntity(String name) throws SAXException {
        this.nl();
        this.echo("END ENTITY: " + name);
    }

    public void startEntity(String name) throws SAXException {
        this.nl();
        this.echo("START ENTITY: " + name);
    }

    public void endDTD() throws SAXException {
        this.nl();
        this.echo("END DTD");
    }

    public void startCDATA() throws SAXException {
        this.nl();
        this.echo("START CDATA SECTION");
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.nl();
        this.echo("START DTD: " + name + "\n           publicId=" + publicId + "\n           systemId=" + systemId);
    }

    private void echo(String s) throws SAXException {
        if (!this.echo) {
            return;
        }
        try {
            out.write(s);
            out.flush();
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    private void nl() throws SAXException {
        if (!this.echo) {
            return;
        }
        String lineEnd = System.getProperty("line.separator");
        try {
            out.write(lineEnd);
            int i = 0;
            while (i < this.indentLevel) {
                out.write(this.indentString);
                ++i;
            }
        }
        catch (IOException e) {
            throw new SAXException("I/O error", e);
        }
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        this.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        this.parse(new InputSource(url.toExternalForm()), this);
    }

    public void parse(InputSource input, XMLHandler handler) throws SAXException, ParserConfigurationException, IOException {
        this.parse(input, new XMLParser(handler));
    }

    public void parse(URL url, XMLHandler handler) throws SAXException, ParserConfigurationException, IOException {
        this.parse(new InputSource(url.toExternalForm()), handler);
    }

    private void parse(InputSource input, XMLParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        out = new OutputStreamWriter((OutputStream)System.out, "UTF8");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(this.validating);
        factory.setNamespaceAware(this.namespace);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", recognizer);
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        parser.parse(input);
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                if (XMLParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }

    public static void usage() {
        System.err.println("Usage: java " + (class$com$synex$xml$sax$XMLParser == null ? (class$com$synex$xml$sax$XMLParser = XMLParser.class$("com.synex.xml.sax.XMLParser")) : class$com$synex$xml$sax$XMLParser).getName() + " <options> filename");
        System.err.println();
        System.err.println("Possible options are:");
        System.err.println("  -sqlm=<file>      Set SQL map file name");
        System.err.println("  -nodtd            Don't validate documents");
        System.err.println("  -echo             Echo an XML file being parsed to System.out");
        System.exit(1);
    }

    public static void main(String[] argv) {
        String filename = null;
        String sqlmap = null;
        boolean echo = false;
        boolean val = true;
        int i = 0;
        while (i < argv.length) {
            String arg = argv[i];
            if (arg.startsWith("-")) {
                arg = arg.substring(1);
                int offset = arg.indexOf(61);
                String opt = null;
                if (offset > -1) {
                    opt = arg.substring(offset + 1);
                    arg = arg.substring(0, offset);
                }
                if ("echo".equalsIgnoreCase(arg)) {
                    echo = true;
                } else if ("sqlm".equalsIgnoreCase(arg)) {
                    sqlmap = opt;
                } else if ("nodtd".equalsIgnoreCase(arg)) {
                    val = false;
                } else {
                    System.err.println("Invalid option: " + arg);
                    XMLParser.usage();
                }
            } else {
                filename = arg;
                break;
            }
            ++i;
        }
        if (filename == null) {
            XMLParser.usage();
        }
        XMLParser parser = new XMLParser(new XMLHandlerImpl(new DBManagerImpl(), sqlmap));
        try {
            parser.setEcho(echo);
            parser.setValidating(val);
            parser.parse(new InputSource(filename));
        }
        catch (SAXParseException spe) {
            System.out.println("\n** Parsing error, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

