/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Hashtable;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;

public class ENTITYDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private DatatypeValidator fBaseValidator = null;
    private DTDGrammar fGrammar = null;
    private XMLEntityDecl fEntityDecl = new XMLEntityDecl();

    public ENTITYDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ENTITYDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.setBasetype(base);
    }

    public void validate(String content, Object state) throws InvalidDatatypeValueException {
        int entityDeclIndex = -1;
        if (this.fGrammar == null) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException();
            error.setKeyIntoReporter("ENTITYFailedInitializeGrammar");
            throw error;
        }
        this.fEntityDecl.clear();
        entityDeclIndex = this.fGrammar.getEntityDeclIndex(content);
        if (entityDeclIndex > -1) {
            this.fGrammar.getEntityDecl(entityDeclIndex, this.fEntityDecl);
            if (this.fEntityDecl.notation == null) {
                InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
                error.setKeyIntoReporter("ENTITYNotUnparsed");
                throw error;
            }
        } else {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
            error.setKeyIntoReporter("ENTITYNotValid");
            throw error;
        }
    }

    public void validate() {
    }

    public void initialize(Object grammar) {
        this.fGrammar = (DTDGrammar)grammar;
    }

    public int compare(String content1, String content2) {
        return -1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public Object getInternalStateInformation() {
        return null;
    }

    private void setBasetype(DatatypeValidator base) {
        this.fBaseValidator = base;
    }
}

