/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    private boolean fEntityReferenceExpansion = false;
    int fWhatToShow = -1;
    NodeFilter fNodeFilter;
    Node fCurrentNode;
    Node fRoot;

    public TreeWalkerImpl(Node root, int whatToShow, NodeFilter nodeFilter, boolean entityReferenceExpansion) {
        this.fCurrentNode = root;
        this.fRoot = root;
        this.fWhatToShow = whatToShow;
        this.fNodeFilter = nodeFilter;
        this.fEntityReferenceExpansion = entityReferenceExpansion;
    }

    public Node getRoot() {
        return this.fRoot;
    }

    public int getWhatToShow() {
        return this.fWhatToShow;
    }

    public void setWhatShow(int whatToShow) {
        this.fWhatToShow = whatToShow;
    }

    public NodeFilter getFilter() {
        return this.fNodeFilter;
    }

    public boolean getExpandEntityReferences() {
        return this.fEntityReferenceExpansion;
    }

    public Node getCurrentNode() {
        return this.fCurrentNode;
    }

    public void setCurrentNode(Node node) {
        this.fCurrentNode = node;
    }

    public Node parentNode() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getParentNode(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node firstChild() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getFirstChild(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node lastChild() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getLastChild(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node previousSibling() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getPreviousSibling(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node nextSibling() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node node = this.getNextSibling(this.fCurrentNode);
        if (node != null) {
            this.fCurrentNode = node;
        }
        return node;
    }

    public Node previousNode() {
        Node lastChild;
        if (this.fCurrentNode == null) {
            return null;
        }
        Node result = this.getPreviousSibling(this.fCurrentNode);
        if (result == null) {
            result = this.getParentNode(this.fCurrentNode);
            if (result != null) {
                this.fCurrentNode = result;
                return this.fCurrentNode;
            }
            return null;
        }
        Node prev = lastChild = this.getLastChild(result);
        while (lastChild != null) {
            prev = lastChild;
            lastChild = this.getLastChild(prev);
        }
        lastChild = prev;
        if (lastChild != null) {
            this.fCurrentNode = lastChild;
            return this.fCurrentNode;
        }
        if (result != null) {
            this.fCurrentNode = result;
            return this.fCurrentNode;
        }
        return null;
    }

    public Node nextNode() {
        if (this.fCurrentNode == null) {
            return null;
        }
        Node result = this.getFirstChild(this.fCurrentNode);
        if (result != null) {
            this.fCurrentNode = result;
            return result;
        }
        result = this.getNextSibling(this.fCurrentNode);
        if (result != null) {
            this.fCurrentNode = result;
            return result;
        }
        Node parent = this.getParentNode(this.fCurrentNode);
        while (parent != null) {
            result = this.getNextSibling(parent);
            if (result != null) {
                this.fCurrentNode = result;
                return result;
            }
            parent = this.getParentNode(parent);
        }
        return null;
    }

    Node getParentNode(Node node) {
        if (node == null || node == this.fRoot) {
            return null;
        }
        Node newNode = node.getParentNode();
        if (newNode == null) {
            return null;
        }
        short accept = this.acceptNode(newNode);
        if (accept == 1) {
            return newNode;
        }
        return this.getParentNode(newNode);
    }

    Node getNextSibling(Node node) {
        return this.getNextSibling(node, this.fRoot);
    }

    Node getNextSibling(Node node, Node root) {
        if (node == null || node == root) {
            return null;
        }
        Node newNode = node.getNextSibling();
        if (newNode == null) {
            newNode = node.getParentNode();
            if (newNode == null || newNode == root) {
                return null;
            }
            short parentAccept = this.acceptNode(newNode);
            if (parentAccept == 3) {
                return this.getNextSibling(newNode, root);
            }
            return null;
        }
        short accept = this.acceptNode(newNode);
        if (accept == 1) {
            return newNode;
        }
        if (accept == 3) {
            Node fChild = this.getFirstChild(newNode);
            if (fChild == null) {
                return this.getNextSibling(newNode, root);
            }
            return fChild;
        }
        return this.getNextSibling(newNode, root);
    }

    Node getPreviousSibling(Node node) {
        return this.getPreviousSibling(node, this.fRoot);
    }

    Node getPreviousSibling(Node node, Node root) {
        if (node == null || node == root) {
            return null;
        }
        Node newNode = node.getPreviousSibling();
        if (newNode == null) {
            newNode = node.getParentNode();
            if (newNode == null || newNode == root) {
                return null;
            }
            short parentAccept = this.acceptNode(newNode);
            if (parentAccept == 3) {
                return this.getPreviousSibling(newNode, root);
            }
            return null;
        }
        short accept = this.acceptNode(newNode);
        if (accept == 1) {
            return newNode;
        }
        if (accept == 3) {
            Node fChild = this.getLastChild(newNode);
            if (fChild == null) {
                return this.getPreviousSibling(newNode, root);
            }
            return fChild;
        }
        return this.getPreviousSibling(newNode, root);
    }

    Node getFirstChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node newNode = node.getFirstChild();
        if (newNode == null) {
            return null;
        }
        short accept = this.acceptNode(newNode);
        if (accept == 1) {
            return newNode;
        }
        if (accept == 3 && newNode.hasChildNodes()) {
            Node fChild = this.getFirstChild(newNode);
            if (fChild == null) {
                return this.getNextSibling(newNode, node);
            }
            return fChild;
        }
        return this.getNextSibling(newNode, node);
    }

    Node getLastChild(Node node) {
        if (node == null) {
            return null;
        }
        if (!this.fEntityReferenceExpansion && node.getNodeType() == 5) {
            return null;
        }
        Node newNode = node.getLastChild();
        if (newNode == null) {
            return null;
        }
        short accept = this.acceptNode(newNode);
        if (accept == 1) {
            return newNode;
        }
        if (accept == 3 && newNode.hasChildNodes()) {
            Node lChild = this.getLastChild(newNode);
            if (lChild == null) {
                return this.getPreviousSibling(newNode, node);
            }
            return lChild;
        }
        return this.getPreviousSibling(newNode, node);
    }

    short acceptNode(Node node) {
        if (this.fNodeFilter == null) {
            if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
                return 1;
            }
            return 3;
        }
        if ((this.fWhatToShow & 1 << node.getNodeType() - 1) != 0) {
            return this.fNodeFilter.acceptNode(node);
        }
        return 3;
    }
}

