/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    private static final boolean DEBUG = false;
    protected static final int CY = 0;
    protected static final int M = 1;
    protected static final int D = 2;
    protected static final int h = 3;
    protected static final int m = 4;
    protected static final int s = 5;
    protected static final int ms = 6;
    protected static final int utc = 7;
    protected static final int hh = 0;
    protected static final int mm = 1;
    protected static final int TOTAL_SIZE = 8;
    protected static final int MONTH_SIZE = 6;
    private static final int YEARMONTH_SIZE = 7;
    protected static final int YEAR = 2001;
    protected static final int MONTH = 1;
    protected static final int DAY = 15;
    protected int[] timeZone;
    protected int fEnumSize;
    protected int fEnd;
    protected int fStart;
    protected StringBuffer fBuffer;
    protected int[] fDateValue;
    private int[] fTempDate;
    protected StringBuffer message;

    public AbstractDateTimeDV() {
        this.initializeValues();
    }

    protected void initializeValues() {
        this.fDateValue = new int[8];
        this.fTempDate = new int[8];
        this.fEnd = 30;
        this.fStart = 0;
        this.message = new StringBuffer(8);
        this.fBuffer = new StringBuffer(this.fEnd);
        this.timeZone = new int[2];
    }

    public short getAllowedFacets() {
        return 1016;
    }

    public boolean isEqual(Object value1, Object value2) {
        if (!(value1 instanceof int[]) || !(value2 instanceof int[])) {
            return false;
        }
        return this.compareDates((int[])value1, (int[])value2, true) == 0;
    }

    public int compare(Object value1, Object value2) {
        return this.compareDates((int[])value1, (int[])value2, true);
    }

    protected abstract int[] parse(String var1, int[] var2) throws SchemaDateTimeException;

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        if (date1[7] == date2[7]) {
            return this.compareOrder(date1, date2);
        }
        if (date1[7] == 90) {
            this.cloneDate(date2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short c1 = this.compareOrder(date1, this.fTempDate);
            this.cloneDate(date2);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short c2 = this.compareOrder(date1, this.fTempDate);
            if (c1 < 0 && c2 > 0 || c1 == 0 && c2 == 0) {
                return 2;
            }
            return c1 != 2 ? c1 : c2;
        }
        if (date2[7] == 90) {
            this.cloneDate(date1);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 45;
            this.normalize(this.fTempDate);
            short c1 = this.compareOrder(this.fTempDate, date2);
            this.cloneDate(date1);
            this.timeZone[0] = 14;
            this.timeZone[1] = 0;
            this.fTempDate[7] = 43;
            this.normalize(this.fTempDate);
            short c2 = this.compareOrder(this.fTempDate, date2);
            if (c1 < 0 && c2 > 0 || c1 == 0 && c2 == 0) {
                return 2;
            }
            return c1 != 2 ? c1 : c2;
        }
        return 2;
    }

    protected short compareOrder(int[] date1, int[] date2) {
        int i = 0;
        while (i < 8) {
            if (date1[i] < date2[i]) {
                return -1;
            }
            if (date1[i] > date2[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    protected void getTime(int start, int end, int[] data) throws RuntimeException {
        int stop = start + 2;
        data[3] = this.parseInt(start, stop);
        if (this.fBuffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[4] = this.parseInt(start, stop += 2);
        if (this.fBuffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data[5] = this.parseInt(start, stop += 2);
        int milisec = this.indexOf(start, end, '.');
        int sign = this.findUTCSign(milisec != -1 ? milisec : start, end);
        if (milisec != -1) {
            data[6] = sign < 0 ? this.parseInt(milisec + 1, this.fEnd) : this.parseInt(milisec + 1, sign);
        }
        if (sign > 0) {
            this.getTimeZone(data, sign);
        }
    }

    protected void getDate(int start, int end, int[] date) throws RuntimeException {
        this.getYearMonth(start, end, date);
        if (this.fBuffer.charAt(this.fStart++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int stop = this.fStart + 2;
        date[2] = this.parseInt(this.fStart, stop);
        this.fStart = stop;
    }

    protected void getYearMonth(int start, int end, int[] date) throws RuntimeException {
        int i;
        if (this.fBuffer.charAt(0) == '-') {
            ++start;
        }
        if ((i = this.indexOf(start, end, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int length = i - start;
        if (length < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && this.fBuffer.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        date[0] = this.parseIntYear(i);
        if (this.fBuffer.charAt(i) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        start = ++i;
        i = start + 2;
        date[1] = this.parseInt(start, i);
        this.fStart = i;
    }

    protected void parseTimeZone(int end, int[] date) throws RuntimeException {
        if (this.fStart < this.fEnd) {
            int sign = this.findUTCSign(this.fStart, this.fEnd);
            if (sign < 0) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(date, sign);
        }
    }

    protected void getTimeZone(int[] data, int sign) throws RuntimeException {
        data[7] = this.fBuffer.charAt(sign);
        if (this.fBuffer.charAt(sign) == 'Z') {
            if (this.fEnd > ++sign) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (sign <= this.fEnd - 6) {
            int stop = ++sign + 2;
            this.timeZone[0] = this.parseInt(sign, stop);
            if (this.fBuffer.charAt(stop++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            this.timeZone[1] = this.parseInt(stop, stop + 2);
            if (stop + 2 != this.fEnd) {
                throw new RuntimeException("Error in parsing time zone");
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(int start, int end, char ch) {
        int i = start;
        while (i < end) {
            if (this.fBuffer.charAt(i) == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void validateDateTime(int[] data) {
        if (data[0] == 0) {
            throw new RuntimeException("The year \"0000\" is an illegal year value");
        }
        if (data[1] < 1 || data[1] > 12) {
            throw new RuntimeException("The month must have values 1 to 12");
        }
        if (data[2] > this.maxDayInMonthFor(data[0], data[1]) || data[2] < 1) {
            throw new RuntimeException("The day must have values 1 to 31");
        }
        if (data[3] > 23 || data[3] < 0) {
            throw new RuntimeException("Hour must have values 0-23");
        }
        if (data[4] > 59 || data[4] < 0) {
            throw new RuntimeException("Minute must have values 0-59");
        }
        if (data[5] > 60 || data[5] < 0) {
            throw new RuntimeException("Second must have values 0-60");
        }
        if (this.timeZone[0] > 14 || this.timeZone[0] < -14) {
            throw new RuntimeException("Time zone should have range -14..+14");
        }
        if (this.timeZone[1] > 59 || this.timeZone[1] < -59) {
            throw new RuntimeException("Minute must have values 0-59");
        }
    }

    protected int findUTCSign(int start, int end) {
        int i = start;
        while (i < end) {
            char c = this.fBuffer.charAt(i);
            if (c == 'Z' || c == '+' || c == '-') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int parseInt(int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        int digit = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        int i = start;
        do {
            if ((digit = Character.digit(this.fBuffer.charAt(i), radix)) < 0) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            result -= digit;
        } while (++i < end);
        return -result;
    }

    protected int parseIntYear(int end) {
        int limit;
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int digit = 0;
        if (this.fBuffer.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        while (i < end) {
            if ((digit = Character.digit(this.fBuffer.charAt(i++), radix)) < 0) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("'" + this.fBuffer.toString() + "' has wrong format");
        }
        return -result;
    }

    protected void normalize(int[] date) {
        int negate = 1;
        if (date[7] == 43) {
            negate = -1;
        }
        int temp = date[4] + negate * this.timeZone[1];
        int carry = this.fQuotient(temp, 60);
        date[4] = this.mod(temp, 60, carry);
        temp = date[3] + negate * this.timeZone[0] + carry;
        carry = this.fQuotient(temp, 24);
        date[3] = this.mod(temp, 24, carry);
        date[2] = date[2] + carry;
        while (true) {
            temp = this.maxDayInMonthFor(date[0], date[1]);
            if (date[2] < 1) {
                date[2] = date[2] + this.maxDayInMonthFor(date[0], date[1] - 1);
                carry = -1;
            } else {
                if (date[2] <= temp) break;
                date[2] = date[2] - temp;
                carry = 1;
            }
            temp = date[1] + carry;
            date[1] = this.modulo(temp, 1, 13);
            date[0] = date[0] + this.fQuotient(temp, 1, 13);
        }
        date[7] = 90;
    }

    protected void resetBuffer(String str) {
        this.fBuffer.setLength(0);
        this.fEnd = 0;
        this.fStart = 0;
        this.timeZone[1] = 0;
        this.timeZone[0] = 0;
        this.fBuffer.append(str);
        this.fEnd = this.fBuffer.length();
    }

    protected void resetDateObj(int[] data) {
        int i = 0;
        while (i < 8) {
            data[i] = 0;
            ++i;
        }
    }

    protected int maxDayInMonthFor(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (this.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected int mod(int a, int b, int quotient) {
        return a - quotient * b;
    }

    protected int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    protected int modulo(int temp, int low, int high) {
        int a = temp - low;
        int b = high - low;
        return this.mod(a, b, this.fQuotient(a, b)) + low;
    }

    protected int fQuotient(int temp, int low, int high) {
        return this.fQuotient(temp - low, high - low);
    }

    protected String dateToString(int[] date) {
        this.message.setLength(0);
        this.message.append(date[0]);
        this.message.append('-');
        this.message.append(date[1]);
        this.message.append('-');
        this.message.append(date[2]);
        this.message.append('T');
        this.message.append(date[3]);
        this.message.append(':');
        this.message.append(date[4]);
        this.message.append(':');
        this.message.append(date[5]);
        this.message.append('.');
        this.message.append(date[6]);
        this.message.append((char)date[7]);
        return this.message.toString();
    }

    protected void reportError(String msg, String value) {
        System.err.println("[Error]: " + msg + ": Value  '" + value + "' is not legal for current datatype");
    }

    private void cloneDate(int[] finalValue) {
        this.resetDateObj(this.fTempDate);
        int i = 0;
        while (i < 8) {
            this.fTempDate[i] = finalValue[i];
            ++i;
        }
    }
}

