/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ASCIIReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    protected InputStream fInputStream;
    protected byte[] fBuffer;

    public ASCIIReader(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public ASCIIReader(InputStream inputStream, int size) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[size];
    }

    public int read() throws IOException {
        int b0 = this.fInputStream.read();
        if (b0 > 128) {
            throw new IOException("character not 7-bit ASCII");
        }
        return b0;
    }

    public int read(char[] ch, int offset, int length) throws IOException {
        if (length > this.fBuffer.length) {
            length = this.fBuffer.length;
        }
        int count = this.fInputStream.read(this.fBuffer, 0, length);
        int i = 0;
        while (i < count) {
            byte b0 = this.fBuffer[i];
            if (b0 > 128) {
                throw new IOException("character not 7-bit ASCII");
            }
            ch[offset + i] = (char)b0;
            ++i;
        }
        return count;
    }

    public long skip(long n) throws IOException {
        return this.fInputStream.skip(n);
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.fInputStream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }
}

