{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, SHDocVw, StdCtrls, ExtCtrls, ActiveX,  php4delphi;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    WebBrowser1: TWebBrowser;
    psvPHP: TpsvPHP;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    Panel3: TPanel;
    Memo1: TMemo;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure psvPHPLogMessage(Sender: TObject; AText: String);
  private
    { Private declarations }
  public
    { Public declarations }
     procedure DisplayResultInBrowser(AStr : string);
     procedure DisplayVariables;
  end;

var
  Form1: TForm1;

implementation



{$R *.DFM}

function StringToOleStream(const AString: string): IStream;
var
  MemHandle: THandle;
begin
  MemHandle := GlobalAlloc(GPTR, Length(AString) + 1);
  if MemHandle <> 0 then begin
    Move(AString[1], PChar(MemHandle)^, Length(AString) + 1);
    CreateStreamOnHGlobal(MemHandle, True, Result);
  end else
    Result := nil;
end;

procedure TForm1.FormCreate(Sender: TObject);
var Url : OleVariant;
begin
  Url := 'about:blank';
  Webbrowser1.Navigate2(Url);
end;



procedure TForm1.Button2Click(Sender: TObject);
var
 doc : string;
begin
  if OpenDialog1.Execute then
   begin
     doc := '';
     doc := psvPHP.Execute(OpenDialog1.FileName);
     DisplayResultInBrowser(doc);
     DisplayVariables;
   end;
end;

procedure TForm1.DisplayResultInBrowser(AStr: string);
var
 Stream: IStream;
 StreamInit: IPersistStreamInit;
begin
  Stream := StringToOleStream(AStr);
  StreamInit := Webbrowser1.Document as IPersistStreamInit;
  StreamInit.InitNew;
  StreamInit.Load(Stream);
end;

procedure TForm1.DisplayVariables;
var
 i : integer;
begin
  ListBox1.Items.Clear;
  for i := 0 to psvPHP.Variables.Count - 1 do
   begin
     ListBox1.Items.Add(psvphp.Variables[i].Name + '=' + psvPHP.Variables[i].Value);
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
 doc : string;
begin
  doc := '';
  doc := psvPHP.RunCode(memo1.Text);
  DisplayResultInBrowser(doc);
  DisplayVariables;
end;

procedure TForm1.psvPHPLogMessage(Sender: TObject; AText: String);
begin
  ShowMessage('Trapped ' + AText);
end;

end.
