{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}

unit phpAPI;

interface

uses
 Windows, SysUtils, zendAPI,
 {$IFDEF VERSION6}Variants, {$ENDIF}WinSock;

type
  TRequestType = (rtGet, rtPut, rtPost, rtHead);

const
  TRequestName : array [0..3] of string =
  ('GET',
   'PUT',
   'POST',
   'HEAD');

const
// connection status states
PHP_CONNECTION_NORMAL   = 0;
PHP_CONNECTION_ABORTED  = 1;
PHP_CONNECTION_TIMEOUT  = 2;

PARSE_POST = 0;
PARSE_GET  = 1;
PARSE_COOKIE  = 2;
PARSE_STRING  = 3;

const
  SAPI_HEADER_ADD = (1 shl 0);
  SAPI_HEADER_DELETE_ALL = (1 shl 1);
  SAPI_HEADER_SEND_NOW = (1 shl 2);
  SAPI_HEADER_SENT_SUCCESSFULLY = 1;
  SAPI_HEADER_DO_SEND = 2;
  SAPI_HEADER_SEND_FAILED = 3;
  SAPI_DEFAULT_MIMETYPE = 'text/html';
  SAPI_DEFAULT_CHARSET = '';
  SAPI_PHP_VERSION_HEADER = 'X-Powered-By: PHP';

type
  Psapi_header_struct = ^Tsapi_header_struct;
  sapi_header_struct =
    record
      header : PChar;
      header_len : uint;
      replace : bool;
    end;
  Tsapi_header_struct = sapi_header_struct;
  
  Psapi_headers_struct = ^Tsapi_headers_struct;
  sapi_headers_struct = 
    record
      headers : Integer;
      http_response_code : Integer;
      send_default_content_type : Byte;
      mimetype : PChar;
      http_status_line : PChar;
    end;
   Tsapi_headers_struct = sapi_headers_struct;
  
  Psapi_request_info = ^Tsapi_request_info;
  sapi_request_info =
    record
      request_method : PChar;
      query_string : PChar;
      raw_post_data : pointer;
      cookie_data : PChar;
      content_length : Longint;
      post_data_length : uint;
      raw_post_data_length : uint;
      path_translated : PChar;
      request_uri : PChar;
      content_type : PChar;
      headers_only : bool;
      no_headers : bool;
      post_entry : Integer;
      content_type_dup : PChar;
      auth_user : PChar;
      auth_password : PChar;
      argv0 : PChar;
      current_user : PChar;
      current_user_length : Integer;
      argc : Integer;
      argv : ^PChar;
    end;
   Tsapi_request_info = sapi_request_info;

  Psapi_header_line = ^Tsapi_header_line;
  sapi_header_line = 
    record
      line : PChar;
      line_len : uint;
      response_code : Longint;
    end;
   Tsapi_header_line = sapi_header_line;

  Psapi_globals_struct = ^Tsapi_globals_struct;
  _sapi_globals_struct =
    record
      server_context : Pointer;
      request_info : sapi_request_info;
      sapi_headers : sapi_headers_struct;
      read_post_bytes : Integer;
      headers_sent : Byte;
      global_stat : stat;
      default_mimetype : PChar;
      default_charset : PChar;
      rfc1867_uploaded_files : pointer;
      post_max_size : Longint;
      options : Integer;
    end;
  Tsapi_globals_struct = _sapi_globals_struct;

  Psapi_module_struct = ^Tsapi_module_struct;
  sapi_module_struct =
    record
      name : PChar;
      pretty_name : PChar;
      startup  : pointer;
      shutdown : pointer;
      activate : pointer;
      deactivate : pointer;
      ub_write : pointer;
      flush : pointer;
      stat : pointer;
      getenv : pointer;
      sapi_error : pointer;
      header_handler : pointer;
      send_headers : pointer;
      send_header : pointer;
      read_post : pointer;
      read_cookies : pointer;
      register_server_variables : pointer;
      log_message : pointer;
      php_ini_path_override : pointer;
      block_interruptions : pointer;
      unblock_interruptions : pointer;
      default_post_reader : pointer;
      treat_data : Integer;
      executable_location : pointer;
      php_ini_ignore : Integer;
      {******************************}
      {IMPORTANT:                    }
      {Please check your php version }
      {******************************}
      {$IFDEF PHP433}
      get_fd : pointer;
      force_http_10 : pointer;
      get_target_uid : pointer;
      get_target_gid : pointer;
      ini_defaults : pointer;
      phpinfo_as_text : integer;
      {$ENDIF}
    end;
   Tsapi_module_struct = sapi_module_struct;

  Psapi_post_entry =  ^Tsapi_post_entry;
  sapi_post_entry =
    record
      content_type : PChar;
      content_type_len : uint;
      post_reader : pointer;
      post_handler : pointer;
    end;
  Tsapi_post_entry = sapi_post_entry;

function php_request_startup (TSRMLS_D : pointer) : Integer; cdecl; external 'php4ts.dll';
procedure php_request_shutdown (dummy : Pointer); cdecl; external 'php4ts.dll';

function php_module_startup (sf : pointer;
   additional_modules : pointer; num_additional_modules : uint) : Integer; cdecl; external 'php4ts.dll';

procedure php_module_shutdown (TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
function php_module_shutdown_wrapper (globals : pointer) : Integer; cdecl; external 'php4ts.dll';

procedure sapi_startup(module : pointer); cdecl; external 'php4ts.dll';
procedure sapi_shutdown; external 'php4ts.dll';
procedure sapi_activate(p : pointer); cdecl; external 'php4ts.dll';
procedure sapi_deactivate(p : pointer); cdecl; external 'php4ts.dll';

function php_execute_script (primary_file: pointer; TSRMLS_D : pointer) : Integer; cdecl; external 'php4ts.dll';

procedure php_handle_aborted_connection; cdecl; external 'php4ts.dll';
procedure php_register_variable(_var : PChar; val: PChar; track_vars_array: pointer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';
// binary-safe version
procedure php_register_variable_safe(_var : PChar; val : PChar; val_len : integer; track_vars_array : pointer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';
procedure php_register_variable_ex(_var : PChar;   val : pzval;  track_vars_array : pointer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';

//php_output.h

procedure php_output_startup(); cdecl; external 'php4ts.dll';
procedure php_output_activate(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
procedure php_output_set_status(status: boolean; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';
procedure php_output_register_constants(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
function  php_start_ob_buffer(output_handler : pzval; chunk_size : uint; erase : boolean; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function  php_start_ob_buffer_named(const output_handler_name : PChar;  chunk_size : uint; erase : boolean; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
procedure php_end_ob_buffer(send_buffer : boolean; just_flush : boolean; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';
procedure php_end_ob_buffers(send_buffer : boolean; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';
function  php_ob_get_buffer(p : pzval; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function  php_ob_get_length(p : pzval; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
procedure php_start_implicit_flush(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
procedure php_end_implicit_flush(TSRMLS_D : pointer); cdecl; external 'php4ts.dll';
function  php_get_output_start_filename(TSRMLS_D : pointer) : pchar; cdecl; external 'php4ts.dll';
function  php_get_output_start_lineno(TSRMLS_D : pointer) : integer; cdecl; external 'php4ts.dll';
function  php_ob_handler_used(handler_name : pchar; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function  php_ob_init_conflict(handler_new : PChar; handler_set : pChar; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';

const
 short_track_vars_names : array [0..5] of string =
  ('_POST',
   '_GET',
   '_COOKIE',
   '_SERVER',
   '_ENV',
   '_FILES' );

function GetSymbolsTable(TSRMLS_DC : pointer) : PHashTable;

function GetTrackHash(Name : string; TSRMLS_DC : pointer) : PHashTable;

function GetSAPIGlobals(TSRMLS_DC : pointer) : Psapi_globals_struct;

//php_string.h

function php_strtoupper (s : PChar; len : size_t) : PChar; cdecl; external 'php4ts.dll';
function php_strtolower (s : PChar; len : size_t) : PChar; cdecl; external 'php4ts.dll';

function php_strtr (str : PChar; len : Integer; str_from : PChar; 
  str_to : PChar; trlen : Integer) : PChar; cdecl; external 'php4ts.dll';

procedure php_stripcslashes (str : PChar; len : PInteger); cdecl; external 'php4ts.dll';

function php_basename (str : PChar; len : size_t; suffix : PChar;  
  sufflen : size_t) : PChar; cdecl; external 'php4ts.dll';

procedure php_dirname (str : PChar; len : Integer); cdecl; external 'php4ts.dll';

function php_stristr (s : PByte; t : PByte; s_len : size_t; t_len : size_t) : PChar; cdecl; external 'php4ts.dll';

function php_str_to_str (haystack : PChar; length : Integer; needle : PChar; 
    needle_len : Integer; str : PChar; str_len : Integer; 
    _new_length : PInteger) : PChar; cdecl; external 'php4ts.dll';

procedure php_strip_tags (rbuf : PChar; len : Integer; state : PInteger; 
  allow : PChar; allow_len : Integer); cdecl; external 'php4ts.dll';

procedure php_implode (var delim : zval; var arr : zval;
  var return_value : zval); cdecl; external 'php4ts.dll';

procedure php_explode (var delim : zval; var str : zval;
  var return_value : zval; limit : Integer); cdecl; external 'php4ts.dll';

const
  PHP_ENTRY_NAME_COLOR = '#ccccff';
  PHP_CONTENTS_COLOR = '#cccccc';
  PHP_HEADER_COLOR = '#9999cc';
  PHP_INFO_GENERAL = (1 shl 0);
  PHP_INFO_CREDITS = (1 shl 1);
  PHP_INFO_CONFIGURATION = (1 shl 2);
  PHP_INFO_MODULES = (1 shl 3);
  PHP_INFO_ENVIRONMENT = (1 shl 4);
  PHP_INFO_VARIABLES = (1 shl 5);
  PHP_INFO_LICENSE = (1 shl 6);
  PHP_INFO_ALL = $FFFFFFFF;
  PHP_CREDITS_GROUP = (1 shl 0);
  PHP_CREDITS_GENERAL = (1 shl 1);
  PHP_CREDITS_SAPI = (1 shl 2);
  PHP_CREDITS_MODULES = (1 shl 3);
  PHP_CREDITS_DOCS = (1 shl 4);
  PHP_CREDITS_FULLPAGE = (1 shl 5);
  PHP_CREDITS_QA = (1 shl 6);
  PHP_CREDITS_WEB = (1 shl 7);
  PHP_CREDITS_ALL = $FFFFFFFF;
  PHP_LOGO_GUID = 'PHPE9568F34-D428-11d2-A769-00AA001ACF42';
  PHP_EGG_LOGO_GUID = 'PHPE9568F36-D428-11d2-A769-00AA001ACF42';
  ZEND_LOGO_GUID = 'PHPE9568F35-D428-11d2-A769-00AA001ACF42';
  PHP_CREDITS_GUID = 'PHPB8B5F2A0-3C92-11d3-A3A9-4C7B08C10000';

function php_info_html_esc (str : PChar; TSRMLS_DC : pointer) : PChar; cdecl; external 'php4ts.dll';

procedure php_print_info_htmlhead (TSRMLS_D : pointer); cdecl; external 'php4ts.dll';

procedure php_print_info (flag : Integer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';

procedure php_print_style; cdecl; external 'php4ts.dll';

procedure php_info_print_style; cdecl; external 'php4ts.dll';

procedure php_info_print_table_colspan_header (num_cols : Integer;
  header : PChar); cdecl; external 'php4ts.dll';

procedure php_info_print_box_start (bg : Integer); cdecl; external 'php4ts.dll';

procedure php_info_print_box_end; cdecl; external 'php4ts.dll';

procedure php_info_print_hr; cdecl; external 'php4ts.dll';

procedure php_info_print_table_start(); cdecl; external 'php4ts.dll';
procedure php_info_print_table_row(n1 : integer; c1: pchar); cdecl; external 'php4ts.dll'; overload;
procedure php_info_print_table_row(n2 : integer; c1, c2 : pchar); cdecl; external 'php4ts.dll'; overload;
procedure php_info_print_table_row(n3 : integer; c1, c2, c3 : pchar); cdecl; external 'php4ts.dll'; overload;
procedure php_info_print_table_row(n4 : integer; c1, c2, c3, c4 : pchar); cdecl; external 'php4ts.dll'; overload;
procedure php_info_print_table_end(); cdecl; external 'php4ts.dll';

function php_body_write(const str : PChar; str_length: uint; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function php_header_write(const str : PChar; str_length: uint; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';

procedure php_log_err(err_msg : PChar; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';

procedure php_html_puts(str : PChar; str_len : integer; TSRMLS_DC : pointer); cdecl; external 'php4ts.dll';

function _php_error_log(opt_err : integer; msg : PChar; opt: PChar;  headers: PChar; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';

procedure php_print_credits(flag : integer); cdecl; external 'php4ts.dll';

procedure php_info_print_css(); cdecl; external 'php4ts.dll';

function php_set_sock_blocking(socketd : integer; block : integer; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function php_copy_file(src : PChar; dest : PChar; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';
function php_flock(fd : integer; operation : integer) : integer; cdecl; external 'php4ts.dll';
function php_lookup_hostname(const addr : PChar; _in : pinaddr ) : integer; cdecl; external 'php4ts.dll';
function php_header() : integer; cdecl; external 'php4ts.dll';
function php_setcookie(name : PChar; name_len : integer; value : PChar; value_len: integer;
    expires : longint; path : PChar; path_len : integer; domain : PChar; domain_len : integer;
    secure : integer; TSRMLS_DC : pointer) : integer; cdecl; external 'php4ts.dll';

const
  ENT_HTML_QUOTE_NONE = 0;
  ENT_HTML_QUOTE_SINGLE = 1;
  ENT_HTML_QUOTE_DOUBLE = 2;
  ENT_COMPAT = ENT_HTML_QUOTE_DOUBLE;
  ENT_QUOTES = (ENT_HTML_QUOTE_DOUBLE or ENT_HTML_QUOTE_SINGLE);
  ENT_NOQUOTES = ENT_HTML_QUOTE_NONE;
    
function php_escape_html_entities(old : PByte; oldlen : integer; newlen : PINT; all : integer;
  quote_style : integer; hint_charset: PChar; TSRMLS_DC : pointer) : pChar; cdecl; external 'php4ts.dll';


const
  PHP_INI_USER = ZEND_INI_USER;
  PHP_INI_PERDIR = ZEND_INI_PERDIR;
  PHP_INI_SYSTEM = ZEND_INI_SYSTEM;
  PHP_INI_ALL = ZEND_INI_ALL;
  PHP_INI_DISPLAY_ORIG = ZEND_INI_DISPLAY_ORIG;
  PHP_INI_DISPLAY_ACTIVE = ZEND_INI_DISPLAY_ACTIVE;
  PHP_INI_STAGE_STARTUP = ZEND_INI_STAGE_STARTUP;
  PHP_INI_STAGE_SHUTDOWN = ZEND_INI_STAGE_SHUTDOWN;
  PHP_INI_STAGE_ACTIVATE = ZEND_INI_STAGE_ACTIVATE;
  PHP_INI_STAGE_DEACTIVATE = ZEND_INI_STAGE_DEACTIVATE;
  PHP_INI_STAGE_RUNTIME = ZEND_INI_STAGE_RUNTIME;

function php_ini_long (name : PChar; name_length : uint; orig : Integer) : Longint; cdecl; external 'php4ts.dll' name 'zend_ini_long';

function php_ini_double (name : PChar; name_length : uint; orig : Integer) : Double; cdecl; external 'php4ts.dll' name 'zend_ini_double';

function php_ini_string (name : PChar; name_length : uint; orig : Integer) : PChar; cdecl; external 'php4ts.dll' name 'zend_ini_string';

function  zval2variant(value : zval) : variant;
procedure variant2zval(value : variant; z : pzval);

type
  PPHP_URL = ^TPHP_URL;
  Tphp_url =
    record
      scheme : PChar;
      user : PChar;
      pass : PChar;
      host : PChar;
      port : Smallint;
      path : PChar;
      query : PChar;
      fragment : PChar;
    end;

procedure php_url_free (theurl : pphp_url); cdecl; external 'php4ts.dll';
function php_url_parse (str : PChar) : pphp_url; cdecl; external 'php4ts.dll';
function php_url_decode (str : PChar; len : Integer) : Integer; cdecl; external 'php4ts.dll';
                     { return value: length of decoded string }

function php_raw_url_decode (str : PChar; len : Integer) : Integer; cdecl; external 'php4ts.dll';
                          { return value: length of decoded string }

function php_url_encode (s : PChar; len : Integer; new_length : PInteger) : PChar; cdecl; external 'php4ts.dll';

function php_raw_url_encode (s : PChar; len : Integer; new_length : PInteger) : PChar; cdecl; external 'php4ts.dll';

function php_startup_extensions(ptr: pointer; count : integer) : integer; cdecl; external 'php4ts.dll';

procedure php_error_docref0(const docref : PChar; TSRMLS_DC : pointer; _type : integer; const Msg : PChar); cdecl; external 'php4ts.dll';
procedure php_error_docref(const docref : PChar; TSRMLS_DC : pointer; _type : integer; const Msg : PChar); cdecl; external 'php4ts.dll' name 'php_error_docref0'; 
procedure php_error_docref1(const docref : PChar; TSRMLS_DC : pointer; const param1 : PChar; _type: integer; Msg : PChar); cdecl; external 'php4ts.dll';
procedure php_error_docref2(const docref : PChar; TSRMLS_DC : pointer; const param1 : PChar; const param2 : PChar; _type : integer; Msg : PChar); cdecl; external 'php4ts.dll';

const
  TRACK_VARS_POST = 0;
  TRACK_VARS_GET = 1;
  TRACK_VARS_COOKIE = 2;
  TRACK_VARS_SERVER = 3;
  TRACK_VARS_ENV = 4;
  TRACK_VARS_FILES = 5;
  
type
  arg_separators = 
    record
      output : PChar;
      input : PChar;
    end;

type
    Pphp_Core_Globals = ^TPHP_core_globals;
    Tphp_core_globals =
    record
      magic_quotes_gpc : boolean;
      magic_quotes_runtime : boolean;
      magic_quotes_sybase : boolean;
      safe_mode : boolean;
      allow_call_time_pass_reference : boolean;
      implicit_flush : boolean;
      output_buffering : Integer;
      safe_mode_include_dir : PChar;
      safe_mode_gid : boolean;
      sql_safe_mode : boolean;
      enable_dl :boolean;
      output_handler : PChar;
      unserialize_callback_func : PChar;
      safe_mode_exec_dir : PChar;
      memory_limit : Longint;
      max_input_time : Longint;
      track_errors : boolean;
      display_errors : boolean;
      display_startup_errors : boolean;
      log_errors : boolean;
      log_errors_max_len : Longint;
      ignore_repeated_errors : boolean;
      ignore_repeated_source : boolean;
      report_memleaks : boolean;
      error_log : PChar;
      doc_root : PChar;
      user_dir : PChar;
      include_path : PChar;
      open_basedir : PChar;
      extension_dir : PChar;
      upload_tmp_dir : PChar;
      upload_max_filesize : Longint;
      error_append_string : PChar;
      error_prepend_string : PChar;
      auto_prepend_file : PChar;
      auto_append_file : PChar;
      arg_separator : arg_separators;
      gpc_order : PChar;
      variables_order : PChar;
      rfc1867_protected_variables : THashTable;
      connection_status : Smallint;
      ignore_user_abort : Smallint;
      header_is_being_sent : Byte;
      tick_functions : zend_llist;
      http_globals : array[0..5] of pzval;
      expose_php : boolean;
      register_globals : boolean;
      register_argc_argv : boolean;
      y2k_compliance : boolean;
      docref_root : PChar;
      docref_ext : PChar;
      html_errors : boolean;
      xmlrpc_errors : boolean;
      xmlrpc_error_number : Longint;
      modules_activated : boolean;
      file_uploads : boolean;
      during_request_startup : boolean;
      allow_url_fopen : boolean;
      always_populate_raw_post_data : boolean;
    end;

function GetPHPGlobals(TSRMLS_DC : pointer) : Pphp_Core_Globals;
function PG(TSRMLS_DC : pointer) : Pphp_Core_Globals;

function GetGlobalResource(resource_name: string; TSRMLS_DC : pointer) : pointer;

function GetCompilerGlobals(TSRMLS_DC : pointer) : pointer;
function GetExecutorGlobals(TSRMLS_DC : pointer) : pointer;
function GetAllocGlobals(TSRMLS_DC : pointer) : pointer;

procedure PHP_FUNCTION(var AFunction : zend_function_entry; AName : PChar; AHandler : pointer);

implementation

function GetSymbolsTable(TSRMLS_DC : pointer) : PHashTable;
var
 executor_globals : pointer;
 executor_globals_value : integer;
 executor_hash : PHashTable;
begin
  if not PHPLoaded then
   begin
     Result := nil;
     Exit;
   end;
  executor_globals := GetProcAddress(PHPLib, 'executor_globals_id');
  executor_globals_value := integer(executor_globals^);
  asm
    mov ecx, executor_globals_value
    mov edx, dword ptr tsrmls_dc
    mov eax, dword ptr [edx]
    mov ecx, dword ptr [eax+ecx*4-4]
    add ecx, 0DCh
    mov executor_hash, ecx
  end;
  Result := executor_hash;
end;

function GetTrackHash(Name : string; TSRMLS_DC : pointer) : PHashTable;
var
 data : ^ppzval;
 arr  : PHashTable;
 ret  : integer;
begin
 Result := nil;
 arr := GetSymbolsTable(TSRMLS_DC);
 if Assigned(Arr) then
  begin
    new(data);
    ret := zend_hash_find(arr, PChar(Name), Length(Name)+1, Data);
    if ret = SUCCESS then
     begin
       Result := data^^^.value.ht;
     end;
  end;
end;


function GetSAPIGlobals(TSRMLS_DC : pointer) : Psapi_globals_struct;
var
 sapi_global_id : pointer;
 sapi_globals_value : integer;
 sapi_globals : Psapi_globals_struct;

begin
  Result := nil;
  sapi_global_id := GetProcAddress(PHPLib, 'sapi_globals_id');
  if Assigned(sapi_global_id) then
   begin
     sapi_globals_value := integer(sapi_global_id^);
     asm
       mov ecx, sapi_globals_value
       mov edx, dword ptr tsrmls_dc
       mov eax, dword ptr [edx]
       mov ecx, dword ptr [eax+ecx*4-4]
       mov sapi_globals, ecx
     end;
     Result := sapi_globals;
   end;
end;


function zval2variant(value : zval) : variant;
begin
  case Value._type of
   IS_NULL    : Result := NULL;
   IS_LONG    : Result := Value.value.lval;
   IS_DOUBLE  : Result := Value.value.dval;
   IS_STRING  : Result := String(Value.Value.str.val);
   IS_BOOL    : Result := Boolean(Value.Value.lval);
    else
      Result := NULL;
  end;
end;


procedure variant2zval(value : variant; z : pzval);
begin
  if VarIsEmpty(value) then
   begin
     ZVAL_NULL(z);
     Exit;
   end;

   case TVarData(Value).VType of
     varString   : ZVAL_STRING(z, TVarData(Value).VString , true);
     varSmallInt : ZVAL_LONG(z, TVarData(Value).VSmallint);
     varInteger  : ZVAL_LONG(z, TVarData(Value).VInteger);
     varBoolean  : ZVAL_BOOL(z, TVarData(Value).VBoolean);
     varSingle   : ZVAL_DOUBLE(z, TVarData(Value).VSingle);
     varDouble   : ZVAL_DOUBLE(z, TVarData(Value).VDouble);
     varError    : ZVAL_LONG(z, TVarData(Value).VError);
     else
       ZVAL_NULL(Z);
   end;
end;


function GetPHPGlobals(TSRMLS_DC : pointer) : Pphp_Core_Globals;
var
 core_global_id : pointer;
 core_globals_value : integer;
 core_globals : Pphp_core_globals;
begin
  Result := nil;
  core_global_id := GetProcAddress(PHPLib, 'core_globals_id');
  if Assigned(core_global_id) then
   begin
     core_globals_value := integer(core_global_id^);
     asm
       mov ecx, core_globals_value
       mov edx, dword ptr tsrmls_dc
       mov eax, dword ptr [edx]
       mov ecx, dword ptr [eax+ecx*4-4]
       mov core_globals, ecx
     end;
     Result := core_globals;
   end;
end;


function GetGlobalResource(resource_name: string; TSRMLS_DC : pointer) : pointer;
var
 global_id : pointer;
 global_value : integer;
 global_ptr   : pointer;
begin
  Result := nil;
  global_id := GetProcAddress(PHPLib, PChar(resource_name));
  if Assigned(global_id) then
   begin
     global_value := integer(global_id^);
     asm
       mov ecx, global_value
       mov edx, dword ptr tsrmls_dc
       mov eax, dword ptr [edx]
       mov ecx, dword ptr [eax+ecx*4-4]
       mov global_ptr, ecx
     end;
     Result := global_ptr;
   end;
end;

function PG(TSRMLS_DC : pointer) : Pphp_Core_Globals;
begin
  result := GetPHPGlobals(TSRMLS_DC);
end;


function GetCompilerGlobals(TSRMLS_DC : pointer) : pointer;
begin
  result := GetGlobalResource('compiler_globals_id', TSRMLS_DC);
end;

function GetExecutorGlobals(TSRMLS_DC : pointer) : pointer;
begin
  result := GetGlobalResource('executor_globals_id', TSRMLS_DC);
end;

function GetAllocGlobals(TSRMLS_DC : pointer) : pointer;
begin
  result := GetGlobalResource('alloc_globals_id', TSRMLS_DC);
end;


procedure PHP_FUNCTION(var AFunction : zend_function_entry; AName : PChar; AHandler : pointer);
begin
  AFunction.fname := AName;
  AFunction.handler := AHandler;
  AFunction.func_arg_types := nil;
end;

end.