//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/ 
// RFSSRV.H 
// Copyright (c) 2003, DTK Software.
// All rights reserved.
// http://www.dtksoft.com
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/ 

#include <wtypes.h>

#ifdef RFSSRV_EXPORTS
#define RFSSRV_API __declspec(dllexport)
#else
#define RFSSRV_API __declspec(dllimport)
#endif

#define MSG_SERVER_STARTED			1
#define MSG_SERVER_STOPPED			2
#define MSG_CLIENT_AUTH_FAILED		3
#define MSG_CLIENT_CONNECTED		4
#define MSG_CLIENT_DISCONNECTED		5
#define MSG_CLIENT_FILEOPEN			6
#define MSG_CLIENT_FILECLOSE		7
#define MSG_CLIENT_FILEEXISTS		8
#define MSG_CLIENT_FILEREAD			9
#define MSG_CLIENT_FILEWRITE		10
#define MSG_CLIENT_FILECREATE		11
#define MSG_CLIENT_FILEDELETE		12
#define MSG_CLIENT_FILESETPOINTER	13
#define MSG_CLIENT_FILEFINDFIRST	14
#define MSG_CLIENT_FILEFINDNEXT		15
#define MSG_CLIENT_CREATEDIR		16
#define MSG_CLIENT_DELETEDIR		17
#define MSG_CLIENT_GETFILEINFO		18


RFSSRV_API int _stdcall RFS_StartServer(int nPort, HWND hWnd, DWORD nMessage);
RFSSRV_API int _stdcall RFS_StopServer();
RFSSRV_API int _stdcall RFS_IsRunning();
RFSSRV_API int _stdcall RFS_ActiveConnections();

RFSSRV_API int _stdcall RFS_DeviceAdd(LPTSTR sDeviceName,LPTSTR sDevicePath);
RFSSRV_API int _stdcall RFS_DeviceDelete(LPTSTR sDeviceName);

RFSSRV_API int _stdcall RFS_UserAdd(LPTSTR sUserName,LPTSTR sUserPassword);
RFSSRV_API int _stdcall RFS_UserSetPassword(LPTSTR sUserName,LPTSTR sUserPassword);
RFSSRV_API int _stdcall RFS_UserDelete(LPTSTR sUserName);

RFSSRV_API int _stdcall RFS_SetUserDeviceRights(LPTSTR sUserName,LPTSTR DeviceName, LPTSTR sRights);
RFSSRV_API int _stdcall RFS_GetUserDeviceRights(LPTSTR sUserName,LPTSTR DeviceName, LPTSTR sRights);
RFSSRV_API int _stdcall RFS_EnumUsersFirst(LPTSTR sUserName);
RFSSRV_API int _stdcall RFS_EnumUsersNext(LPTSTR sUserName);
RFSSRV_API int _stdcall RFS_EnumDevicesFirst(LPTSTR sDeviceName, LPTSTR sPath);
RFSSRV_API int _stdcall RFS_EnumDevicesNext(LPTSTR sDeviceName, LPTSTR sPath);
RFSSRV_API void _stdcall RFS_SetRegistrationCode(LPTSTR sRegCode);

RFSSRV_API void _stdcall RFS_GetErrorText(int dwErrorCode, LPTSTR sErrorText);
