<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:param name="sortby"/>
    <xsl:param name="sortorder"/>

    <xsl:output method="xml" omit-xml-declaration="yes" encoding="iso-8859-1"/>
    <xsl:template match="//MailList">

    <xsl:variable name="sb">
        <xsl:choose>
            <xsl:when test="not($sortby) or $sortby=''">@Id</xsl:when>
            <xsl:otherwise><xsl:value-of select="$sortby"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="so">
        <xsl:choose>
            <xsl:when test="$sortorder='a'">ascending</xsl:when>
            <xsl:otherwise>descending</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt">
        <xsl:choose>
            <xsl:when test="$sortby='Date'">text</xsl:when>
            <xsl:when test="$sortby='From'">text</xsl:when>
            <xsl:when test="$sortby='Subject'">text</xsl:when>
            <xsl:otherwise>number</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

        <TABLE border="0" width="100%" cellpadding="0" cellspacing="0" class="Mtable">
            <TR bgcolor="#93BEE2">
                <TD width="15" align="middle">
                    <IMG src="./images/spacer.gif" width="15" height="1"/>
                </TD>
                <TD width="9">
                    <IMG src="./images/spacer.gif" width="9" height="1"/>
                </TD>
                <TD width="10">
                    <INPUT type="CHECKBOX" name="DELALL" onClick="CA();"/>
                </TD>
                <TD width="30%">
                    <FONT class="s" color="#104A7B">
                        <B><A href="ListMails.asp?SortBy=From&amp;SortOrder={$sortorder}">From</A> </B>
                    </FONT>
                </TD>
                <TD width="50%">
                    <FONT class="s" color="#104A7B">
                        <B><A href="ListMails.asp?SortBy=Subject&amp;SortOrder={$sortorder}">Subject</A> </B>
                    </FONT>
                </TD>
                <TD width="70" align="right">
                    <FONT class="s" color="#104A7B">
                        <B><A href="ListMails.asp?SortBy=Date&amp;SortOrder={$sortorder}">Date</A> </B>
                    </FONT>
                </TD>
                <TD width="10">
                    <IMG src="./images/spacer.gif" width="10" height="14"/>
                </TD>                
                <TD width="40" align="right">
                    <FONT class="s" color="#104A7B">
                        <B><A href="ListMails.asp?SortBy=Size&amp;SortOrder={$sortorder}">Size</A> </B>
                    </FONT>
                </TD>
                <TD width="15">                    
                    <IMG src="./images/spacer.gif" width="15" height="14"/>
                </TD>                
            </TR>
            <xsl:for-each select="./*">
                <xsl:sort select="@*[name(.)=$sb]" order="{$so}" data-type="{$dt}"/>
                <TR bgcolor="#FFF7E5">
                    <xsl:attribute name="class">
                        <xsl:if test="@Del='1'">
                       	    strike
                        </xsl:if>
                    </xsl:attribute>
                    <TD align="middle">
                        <xsl:if test="@Del='1'">
                           <xsl:if test="@Status='R'">
                              <IMG src="./images/mailrd.GIF" width="15" height="14"/>
                           </xsl:if>
                           <xsl:if test="not(@Status) or string(@Status)=''">
                               <IMG src="./images/mailud.GIF" width="15" height="14"/>
                           </xsl:if>
                        </xsl:if>
                        <xsl:if test="not(@Del)">
                           <xsl:if test="@Status='R'">
                              <IMG src="./images/mailr.GIF" width="15" height="14"/>
                           </xsl:if>
                           <xsl:if test="not(@Status) or string(@Status)=''">
                               <IMG src="./images/mailu.GIF" width="15" height="14"/>
                           </xsl:if>
                        </xsl:if>
                    </TD>                    
                    <TD>
                        <xsl:if test="@Pri='h'">
                            <IMG src="./images/pri-h.GIF" width="9" height="14"/>
                        </xsl:if>
                        <xsl:if test="@Pri='l'">
                            <IMG src="./images/pri-l.GIF" width="9" height="14"/>
                        </xsl:if>
                        <xsl:if test="not(@Pri)">
                            <IMG src="./images/spacer.gif" width="9" height="14"/>
                        </xsl:if>
                    </TD>
                    <TD width="10">
                        <INPUT type="CHECKBOX" name="DEL">
                            <xsl:attribute name="value"><xsl:value-of select="@Id"/></xsl:attribute>
                        </INPUT>
                    </TD>
                    <TD>
                        <xsl:if test="string-length(@From) > 36">
                            <xsl:value-of select="substring(@From, 1, 36)"/>...                                                       
                        </xsl:if>                                
                        <xsl:if test="not(string-length(@From) > 36)">
                            <xsl:value-of select="@From"/> 
                        </xsl:if>                                
                    </TD>
                    <TD>
                        <A>
                           <xsl:attribute name="href">ReadMail.asp?id=<xsl:value-of select="@Id"/></xsl:attribute>
                           <xsl:if test="string-length(@Subject) > 64">
                               <xsl:value-of select="substring(@Subject, 1, 64)"/>...                                                       
                           </xsl:if>                                
                           <xsl:if test="not(string-length(@Subject) > 64)">
                              <xsl:value-of select="@Subject"/> 
                           </xsl:if>                                
                           <xsl:if test="string(@Subject)=''">No Subject</xsl:if>
                        </A>
                    </TD>
                    <TD width="70" align="right" nowrap="nowrap">
                        <xsl:value-of select="substring(@Date, 6, 11)"/>
                    </TD>
                    <TD width="10">
                        <IMG src="./images/spacer.gif" width="10" height="14"/>
                    </TD>
                    <TD width="40" align="right" nowrap="nowrap">
                        <xsl:value-of select="@Size"/>
                    </TD>
                    <TD width="15">                    
                        <IMG src="./images/spacer.gif" width="15" height="14"/>
                    </TD>
                </TR>
            </xsl:for-each>
        </TABLE>
    </xsl:template>
</xsl:stylesheet>
