    ' This file is provided as part of ASP Power Widgets Samples
    '
    ' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT
    ' WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
    ' INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
    ' OF MERCHANTABILITY AND/OR FITNESS FOR A  PARTICULAR
    ' PURPOSE.

    ' Copyright 1998-2002. All rights reserved.
    ' Dalun Software Inc. ASP Power Widgets
    ' http://dalun.com 
    ' mail: sales@dalun.com
    ' mail: techsupport@dalun.com
    ' if you have any suggestions or requirements, please write to us.
    ' Revisions:
    ' 2.0.0   Initial release

    Option explicit
    
    Dim strTicket
    Dim strXMLMailList
    Dim objIMAP4
    Dim objMailListXMLDOM
    
    Dim strServer
    Dim strUserId
    Dim strPassword
    Dim oNodes
    Dim item
    Dim objMailXMLDOM
    Dim objFolderListXMLDOM

    Set objIMAP4 = CreateObject("ASPPW.IMAP.1")

    If WScript.Arguments.Count <> 3 Then
        WScript.Echo "Usage: cscript IMAP4Demo.vbs <IMAP4 Server> <UserId> <Password>"
        WScript.Quit(0)
    End If

    strServer = WScript.Arguments(0)
    strUserId = WScript.Arguments(1)
    strPassword = WScript.Arguments(2)
    
    strTicket =  objIMAP4.logon(strServer, "143", strUserId, strPassword)

    objIMAP4.SelectFolder strTicket, "Inbox"

    Set objFolderListXMLDOM = objIMAP4.listfolders(strTicket)  
    WScript.Echo objFolderListXMLDOM.xml 

    'SegSize=100,000, SegNum=0, Assuming you won't have mails more than 100,000.
    Set objMailListXMLDOM = objIMAP4.getmaillist(strTicket, 100000, 0)  

    Set oNodes = objMailListXMLDOM.selectNodes("//MailList/*")

    WScript.Echo "You have " & oNodes.Length & " mail(s). in the ""Inbox"" folder." & vbCRLF
    WSCRIPT.ECHO strXMLMailList 

    'Refresh your session ticket, so the connection manager will keep your connection. 
    'It is important for Web application.
    strTicket = objIMAP4.refreshticket(strTicket)

    For Each item in oNodes
        Dim id, strRaw
        Set id = item.selectSingleNode("@Id")
        strRaw = objIMAP4.GetRawMailData(strTicket, CLng(id.text))
        WScript.Echo "Mail: " & id.text 
        WScript.Echo strRaw
    Next

    'Refresh your session ticket, so the connection manager will keep your connection. 
    'It is important for Web application.
    strTicket = objIMAP4.refreshticket(strTicket)

    'Read a mail wrapped in XML with id = 1, save attachments at c:\temp	
    If (oNodes.Length >0) Then
        Set objMailXMLDOM = objIMAP4.getmail(strTicket, 1, "c:\temp") 
        WSCRIPT.ECHO objMailXMLDOM.xml
 
        CALL objIMAP4.deletemail(strTicket, 1)
        WSCRIPT.ECHO "A mail was deleted."

       'To commit the above deletion, you need to uncomment below to call commitdelete.
       'CALL objIMAP4.commitdelete
       'WSCRIPT.ECHO "A mail was truly deleted."
     End if

