<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes"/>
    <xsl:template match="*">
        <TABLE bgcolor="#FFFFFF" width="100%" cellspacing="0">
            <TR>
                <TD>
                    <TABLE border="0" width="100%" bgcolor="#93BEE2">
                        <TR>
                            <TD align="right" width="20%">
                                <FONT class="s" color="#104A7B">
                                    <b>From: </b>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <xsl:value-of select="/Mail/From"/>
                                    <xsl:if test="string(/Mail/From)=''"><IMG src=".images/spacer.gif" width="1" height="1"/></xsl:if>
                                </FONT>
                            </TD>
                            <TD width="10%"/>
                        </TR>
                        <TR>
                            <TD Align="right">
                                <FONT class="s" color="#104A7B">
                                    <b>To: </b>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <xsl:value-of select="/Mail/To"/>
                                    <xsl:if test="string(/Mail/To)=''"><IMG src=".images/spacer.gif" width="1" height="1"/></xsl:if> 
                                </FONT>
                            </TD>
                            <TD/>
                        </TR>
                        <xsl:if test="string(/Mail/Cc)!=''">
                        <TR>
                            <TD Align="right">
                                <FONT class="s" color="#104A7B">
                                    <b>Cc: </b>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <xsl:value-of select="/Mail/Cc"/>
                                </FONT>
                            </TD>
                            <TD/>
                        </TR>
                        </xsl:if>
                        <TR>
                            <TD Align="right">
                                <FONT class="s" color="#104A7B">
                                    <b>Date: </b>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <xsl:value-of select="/Mail/Date"/>
                                    <xsl:if test="string(/Mail/Date)=''"><IMG src=".images/spacer.gif" width="1" height="1"/></xsl:if>
                                </FONT>
                            </TD>
                            <TD/>
                        </TR>
                        <TR>
                            <TD Align="right">
                                <FONT class="s" color="#104A7B">
                                    <b>Subject: </b>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <xsl:value-of select="/Mail/Subject"/>
                                    <xsl:if test="string(/Mail/Subject)=''"><IMG src=".images/spacer.gif" width="1" height="1"/></xsl:if>
                                </FONT>
                            </TD>
                            <TD/>
                        </TR>
                        <TR>
                            <TD Align="right">
                                <FONT class="s" color="#104A7B">
                                    <b/>
                                </FONT>
                            </TD>
                            <TD style="border-bottom: solid #769DB5 1px;">
                                <FONT class="f" size="2">
                                    <A>
                                        <xsl:attribute name="href">ReadMail.asp?Id=<xsl:value-of select="/Mail/@Id"/>&amp;Type=Raw</xsl:attribute>View E-Mail Message Source</A>
                                </FONT>
                            </TD>
                            <TD/>
                        </TR>
                    </TABLE>
                    <xsl:if test="string(/Mail/BodyAlt)!=''">
                        <TABLE class="Wf" border="0" align="center" width="100%" cellspacing="0" cellpadding="0">
                            <TR>
                                <TD>
                                    <xsl:value-of disable-output-escaping="yes" select="/Mail/BodyAlt"/>
                                </TD>
                            </TR>
                        </TABLE>
                    </xsl:if>
                    <xsl:if test="string(/Mail/BodyAlt)=''">
                        <TABLE class="Wf" border="0" align="center" width="100%" cellspacing="0" cellpadding="0">
                            <TR>
                                <TD>
                                    <DIV>
                                    <PRE>
                                        <xsl:value-of disable-output-escaping="yes" select="/Mail/Body"/>
                                    </PRE>
                                    </DIV>
                                </TD>
                            </TR>
                        </TABLE>
                    </xsl:if>
                    <xsl:if test="/Mail/Attachments/*">
                        <TABLE>
                            <TR>
                                <TD Align="right">
                                    <FONT class="s" color="#104A7B">
                                        <b>Attachments: </b>
                                    </FONT>
                                </TD>
                                <TD/>
                            </TR>
                            <xsl:for-each select="/Mail/Attachments/*">
                                <TR>
                                    <TD Align="right"/>
                                    <TD>
                                        <A>
                                            <xsl:attribute name="href"><xsl:value-of select="/Mail/attBaseURL"/><xsl:value-of select="."/></xsl:attribute>
                                        </A>
                                        <FONT class="f" size="2">
                                            <xsl:value-of select="@description"/>
                                        </FONT>
                                        <xsl:if test="contains(.,'.jpg') or contains(.,'.JPG') or contains(.,'.gif') or contains(.,'.GIF')">
                                            <img border="0">
                                                <xsl:attribute name="src"><xsl:value-of select="/Mail/attBaseURL"/><xsl:value-of select="."/></xsl:attribute>
                                            </img>
                                        </xsl:if>
                                    </TD>
                                </TR>
                            </xsl:for-each>
                        </TABLE>
                    </xsl:if>
                </TD>
            </TR>
        </TABLE>
    </xsl:template>
</xsl:stylesheet>
