
<%
Sub displayAppointment(inMessage)

  On Error Resume Next

  writeTitle DATETEXT & "/" & TIMETEXT & COLONSPACETEXT
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongDate)
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongTime)
  writeTitle DURATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8213")) & " " & MINTEXT
  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle LOCATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8208"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub displayContact(inMessage)

  On Error Resume Next

  writeTitle NAMETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle TITLETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A17001F))
  writeTitle COMPANYTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A16001F))
  writeTitle DEPARTMENTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A18001F))
  writeTitle EMAILTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8084", "0420060000000000C000000000000046"))
  writeTitle BUSINESSPHONETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A08001F))
  writeTitle MOBILETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A1C001F))
  writeTitle BUSINESSFAXTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A24001F))
  writeTitle BUSINESSADDRESSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8045", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8046", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8047", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8048", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8049", "0420060000000000C000000000000046"))

End Sub

Sub displayMessage(inMessage)

  Set objMessages = objSession.GetFolder(inMessage.FolderID).Messages

  objMessages.Sort 2

  For n = 1 To objMessages.Count
    If objMessages.Item(n).ID = inMessage.ID Then
      o = n
      Exit For
    End If
  Next

  noLineBreaks = True
  t = False

  If o < objMessages.Count Then
    oldmi = mi
    mi = objMessages.Item(o + 1).ID
    writeLink "MSR.asp", PREVIOUSMESSAGETEXT, OPWFN + OPWMN + OPWMI
    mi = oldmi
    t = True
  End If

  If o > 1 Then
    oldmi = mi
    mi = objMessages.Item(o - 1).ID
    writeLink "MSR.asp", NEXTMESSAGETEXT, OPWFN + OPWMN + OPWMI
    mi = oldmi
    t = True
  End If

  If t Then rwbc ""

  mt = OPWCMR + OPWFRMR
  writeLink "MSE.asp", REPLYTEXT, OPWFN + OPWMN + OPWMI + OPWMT

  mt = OPWCMA + OPWFRMR
  writeLink "MSE.asp", REPLYTOALLTEXT, OPWFN + OPWMN + OPWMI + OPWMT

  mt = OPWCMF + OPWFRMR
  writeLink "MSE.asp", FORWARDTEXT, OPWFN + OPWMN + OPWMI + OPWMT
  rwbc ""

  noLineBreaks = False

  oldmp = mp
  If mp = "" Then
    mp = 1
    If (HTMLBODYCONTROL And 1) = 0 Then
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLink "MSR.asp", "HTML", OPWFN + OPWMN + OPWMI + OPWMP
      blnShowHTML = False
    Else
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLink "MSR.asp", "TXT", OPWFN + OPWMN + OPWMI + OPWMP
      blnShowHTML = True
    End If
  Else
    mp = ""
    If (HTMLBODYCONTROL And 1) = 0 Then
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLink "MSR.asp", "TXT", OPWFN + OPWMN + OPWMI + OPWMP
      blnShowHTML = True
    Else
      If (HTMLBODYCONTROL And 2) <> 0 Then writeLink "MSR.asp", "HTML", OPWFN + OPWMN + OPWMI + OPWMP
      blnShowHTML = False
    End If
  End If
  mp = oldmp

  ' Are we in Sent Items?
  If checkTopFolder(objSession.GetFolder(inMessage.FolderID), 3) Then
    writeTitle TO1TEXT & COLONSPACETEXT
    display = getMessageRecipient(inMessage)
  Else
    writeTitle FROMTEXT & COLONSPACETEXT
    display = getMessageSender(inMessage)
  End If

  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  writeLink "MSRM.asp", MORETEXT, OPWFN + OPWMN + OPWMI
  writeUnderline

  If Not blnShowHTML Then
    strMessageText = getMessageText(inMessage)
    msgStart = ((pg - 1) * MAXPAGESIZE) + 1
    display = Mid(strMessageText, msgStart, MAXPAGESIZE)
    display = displayEncode(display)
  Else
    display = getMessageHTMLBody(inMessage)
  End If

  rwbc display

  If OPENATTACHMENTS Then

    For n = 1 To inMessage.Attachments.Count

      writeTitle ATTACHMENTTEXT & COLONSPACETEXT
      Set objAttachment = inMessage.Attachments(n)
      If objAttachment.Type = 1 Then
        display = objAttachment.Name
      Else
        display = objAttachment.Source
      End If
      mp = objAttachment.Index
      noLineBreaks = True

      If Not USERENDERER Then

        strUser = Request.ServerVariables("REMOTE_USER")
        intP = Instr(strUser, "\")
        If intP <> 0 Then strUser = Right(strUser, Len(strUser) - intP)

        strMsgURL = inMessage.Fields(&H6707001E)

        For o = 1 To Len(strMsgURL)
          p = Mid(strMsgURL, o, 1)
          If Asc(p) = 63 Then
            strMsgURL = Left(strMsgURL, o - 1) & "_xF8FF_" & Right(strMsgURL, (Len(strMsgURL) - o))
            noMultipart = True
          End If
        Next

        If Not noMultiPart Then
          strURL = "/Exchange" & _
           "/" & strUser & _
           strMsgURL & _
           "/1_multipart" & _
           "/" & n + 1 & "_" & display
        Else
          strURL = "/Exchange" & _
           "/" & strUser & _
           strMsgURL & _
           "/" & n & "_" & display
        End If

        writeLink strURL, display, 0

      Else

        writeLink "AT1.asp", display, OPWFN + OPWMN + OPWMI + OPWMP

      End If

      rwbc " (" & Int(objAttachment.Fields(&H0E200003) / 1024) & KILOBYTESTEXT & ")"
      noLineBreaks = False

    Next

  End If

  If Not blnShowHTML Then
    If (msgStart + MAXPAGESIZE) <= Len(strMessageText) Then
      pg = pg + 1
      writeLink "MSR.asp", NEXTTEXT, OPWFN + OPWMN + OPWMI + OPWPG
    End If
  End If

End Sub

Sub displayNote(inMessage)

  writeTitle NOTETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H1000001F))

End Sub

Sub displayPost(inMessage)

  writeTitle FROMTEXT & COLONSPACETEXT
  display = getMessageSender(inMessage)
  rwbc displayEncode(display)

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  display = inMessage.Subject
  rwbc displayEncode(display)

  writeUnderline

  msgStart = ((pg - 1) * MAXPAGESIZE) + 1

  strMessageText = getMessageText(inMessage)
  display = Mid(strMessageText, msgStart, MAXPAGESIZE)
  rwbc displayEncode(display)

  If OPENATTACHMENTS Then
    For n = 1 To inMessage.Attachments.Count
      writeTitle ATTACHMENTTEXT & COLONSPACETEXT
      Set objAttachment = inMessage.Attachments(n)
      If objAttachment.Type = 1 Then
        display = inMessage.Name
      Else
        display = inMessage.Source
      End If
      mp = inMessage.Attachments(n).Index
      writeLink "AT1.asp", display, OPWFN + OPWMN + OPWMI + OPWMP
    Next
  End If

  If (msgStart + MAXPAGESIZE) <= Len(strMessageText) Then
    pg = pg + 1
    writeLink "PSR.asp", NEXTTEXT, OPWFN + OPWMN + OPWMI + OPWPG
  End If

End Sub

Sub displayTask(inMessage)

  On Error Resume Next

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle IMPORTANCETEXT & COLONSPACETEXT
  lImportance = inMessage.Fields(&H00170003)
  Select Case lImportance
    Case 0
      rwbc displayEncode(LOWTEXT)
    Case 1
      rwbc displayEncode(NORMALTEXT)
    Case 2
      rwbc displayEncode(HIGHTEXT)
  End Select

  writeTitle STATUSTEXT & COLONSPACETEXT
  lStatus = inMessage.Fields("0x8101", "0320060000000000C000000000000046")
  Select Case lStatus
    Case 0
      rwbc displayEncode(OPENTEXT)
    Case 1
      rwbc displayEncode(INPROGRESSTEXT)
    Case 2
      rwbc displayEncode(COMPLETEDTEXT)
    Case 3
      rwbc displayEncode(WAITINGONSOMEONEELSETEXT)
    Case 4
      rwbc displayEncode(DEFERREDTEXT)
  End Select

  writeTitle PERCENTCOMPLETETEXT & COLONSPACETEXT
  lPercentComplete = inMessage.Fields("0x8102", "0320060000000000C000000000000046")
  rwbc 100 * lPercentComplete & "%"
  writeTitle STARTDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8104", "0320060000000000C000000000000046"))
  writeTitle DUEDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8105", "0320060000000000C000000000000046"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub
%>
