/*
 * Decompiled with CFR 0.152.
 */
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

class ServiceClient {
    private boolean RUNNING = false;
    public boolean SETUP = true;
    private boolean LOGGING;
    private Socket client;
    private loadbalanced m;
    private long id;
    private VirtualClass myVC;
    private ServiceClass sc;
    private String servicename;
    private ServerThread st;
    private ClientThread ct;
    private Socket server;

    public ServiceClient(loadbalanced loadbalanced2, VirtualClass virtualClass, Socket socket, long l) {
        this.client = socket;
        this.m = loadbalanced2;
        this.id = l;
        this.LOGGING = loadbalanced.THREAD_LOGGING;
        this.myVC = virtualClass;
        this.server = null;
        this.st = null;
        this.ct = null;
        this.RUNNING = true;
        if (this.LOGGING) {
            loadbalanced2.logEvent("ServiceClient " + l + " Created");
        }
        try {
            this.sc = this.myVC.getSticky() == 0 ? this.myVC.getNextService() : this.myVC.getStickyService(socket.getInetAddress().getHostAddress());
            this.servicename = this.sc.getName();
            this.server = new Socket(this.sc.getAddress(), this.sc.getPort());
            this.st = new ServerThread(this.server, socket);
            this.ct = new ClientThread(socket, this.server);
            this.sc.hitCounter();
            if (this.LOGGING) {
                loadbalanced2.logEvent("ServiceClient " + l + " Connection loadbalanced to " + this.sc.getName());
            }
        }
        catch (ConnectException connectException) {
            block26: {
                if (this.LOGGING) {
                    loadbalanced2.logEvent("ServiceClient " + l + " ConnectException -- Remote Service May Be Down");
                }
                try {
                    if (socket != null) {
                        socket.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed client");
                        }
                    }
                    if (this.server != null) {
                        this.server.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed service");
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.LOGGING) break block26;
                    loadbalanced2.logEvent("SubException ServiceClient " + l + ": " + exception);
                }
            }
            this.SETUP = false;
        }
        catch (NullPointerException nullPointerException) {
            block27: {
                if (this.LOGGING) {
                    loadbalanced2.logEvent("ServiceClient " + l + " NullPointer Exception -- No Active Service Available");
                }
                try {
                    if (socket != null) {
                        socket.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed client");
                        }
                    }
                    if (this.server != null) {
                        this.server.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed service");
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.LOGGING) break block27;
                    loadbalanced2.logEvent("SubException ServiceClient " + l + ": " + exception);
                }
            }
            this.SETUP = false;
        }
        catch (Exception exception) {
            block28: {
                loadbalanced2.logEvent("Exception ServiceClient " + l + ": " + exception);
                try {
                    if (socket != null) {
                        socket.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed client");
                        }
                    }
                    if (this.server != null) {
                        this.server.close();
                        if (this.LOGGING) {
                            loadbalanced2.logEvent("ServiceClient " + l + " closed service");
                        }
                    }
                }
                catch (Exception exception2) {
                    if (!this.LOGGING) break block28;
                    loadbalanced2.logEvent("SubException ServiceClient " + l + ": " + exception2);
                }
            }
            this.SETUP = false;
        }
        this.SETUP = false;
    }

    public boolean getStatus() {
        return this.RUNNING;
    }

    public void checkStatus() {
        try {
            if (!this.st.getStatus() || !this.ct.getStatus()) {
                this.RUNNING = false;
                this.halt();
            }
        }
        catch (Exception exception) {
            this.RUNNING = false;
            this.halt();
        }
    }

    public String getLoadbalancedConnection() {
        return this.servicename;
    }

    public String getClient() {
        InetAddress inetAddress = this.client.getLocalAddress();
        InetAddress inetAddress2 = this.client.getInetAddress();
        int n = this.client.getLocalPort();
        int n2 = this.client.getPort();
        String string = new String("{\r\n Remote: " + inetAddress2.toString() + ":" + n2 + " \r\n Local: " + inetAddress.toString() + ":" + n + " ( " + this.myVC.getName() + " )");
        return string;
    }

    public void halt() {
        if (this.LOGGING) {
            this.m.logEvent("ServiceClient " + this.id + " halting service threads");
        }
        if (this.st != null) {
            this.st.halt();
        }
        if (this.ct != null) {
            this.ct.halt();
        }
        this.RUNNING = false;
        if (this.LOGGING) {
            this.m.logEvent("ServiceClient " + this.id + " destroyed");
        }
    }
}

