/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class loadbalanced
implements Runnable {
    public static boolean LOGGING;
    public static boolean THREAD_LOGGING;
    public static boolean VERBOSE;
    public ReadConfig rc = null;
    private static String VERSION;
    private static long STARTEXEC;
    private long STOPEXEC;
    private int COMMAND_TIMEOUT;
    private int COMMAND_PORT;
    private long CONNECTIONS;
    private boolean RUNNING;
    private String PASSWORD = new String("");
    private String PROMPT = new String("loadbalanced:");
    private String configFile;
    private Vector virtuals;
    private Vector services;
    private ServerSocket serversock;
    private String logfile = "loadbalanced.log";
    private RandomAccessFile log = null;
    private String conffile = null;

    public static void main(String[] stringArray) {
        STARTEXEC = System.currentTimeMillis();
        VERBOSE = false;
        LOGGING = true;
        THREAD_LOGGING = true;
        if (stringArray.length == 0) {
            new loadbalanced();
        }
        if (stringArray.length == 1) {
            new loadbalanced(stringArray[0]);
        }
        System.exit(0);
    }

    public loadbalanced() {
        if (LOGGING) {
            this.logEvent("Starting loadbalanced " + VERSION);
        }
        if (LOGGING) {
            this.logEvent("Entered constructor");
        }
        this.COMMAND_PORT = 1024;
        this.COMMAND_TIMEOUT = 60000;
        this.conffile = "loadbalanced.conf";
        try {
            this.rc = new ReadConfig(this, this.conffile);
        }
        catch (Exception exception) {
            if (VERBOSE) {
                System.out.println(exception);
            }
            if (LOGGING) {
                this.logEvent("loadbalanced cannot launch");
            }
            return;
        }
        this.mainloop();
        if (LOGGING) {
            this.logEvent("Exiting constructor");
        }
        if (LOGGING) {
            this.logEvent("loadbalanced halted -- Runtime: " + this.getUptimeString());
        }
    }

    public loadbalanced(String string) {
        if (VERBOSE) {
            System.out.println("Entered Constructor");
        }
        if (LOGGING) {
            this.logEvent("Starting loadbalanced " + VERSION);
        }
        if (LOGGING) {
            this.logEvent("Entered constructor");
        }
        this.COMMAND_PORT = 1024;
        this.COMMAND_TIMEOUT = 60000;
        this.conffile = string;
        try {
            this.rc = new ReadConfig(this, string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.logEvent("loadbalanced cannot launch");
            return;
        }
        this.mainloop();
        if (LOGGING) {
            this.logEvent("Exiting constructor -- Runtime: " + this.getUptimeString());
        }
        if (LOGGING) {
            this.logEvent("loadbalanced halted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void mainloop() {
        if (loadbalanced.VERBOSE) {
            System.out.println("Entering mainloop()");
        }
        if (loadbalanced.LOGGING) {
            this.logEvent("Entering mainloop()");
        }
        var1_1 = new Thread(this);
        var1_1.start();
        this.RUNNING = true;
        try {
            var2_2 = 0;
            while (var2_2 < this.rc.virtuals.size()) {
                var3_5 = (VirtualClass)this.rc.virtuals.elementAt(var2_2);
                if (var3_5.getStatus().equals("active")) {
                    var3_5.start();
                }
                ++var2_2;
            }
            var3_6 = 0;
            while (var3_6 < this.rc.services.size()) {
                var4_9 = (ServiceClass)this.rc.services.elementAt(var3_6);
                if (var4_9.getStatus().equals("active")) {
                    var4_9.activate();
                }
                ++var3_6;
            }
            if (true) ** GOTO lbl69
        }
        catch (Exception var2_3) {
            if (loadbalanced.VERBOSE) {
                System.out.println("mainloop(): " + var2_3);
            }
            if (loadbalanced.LOGGING) {
                this.logEvent("mainloop(): " + var2_3);
            }
            return;
        }
        do {
            var2_2 = 0;
            while (var2_2 < this.rc.virtuals.size()) {
                var3_7 = (VirtualClass)this.rc.virtuals.elementAt(var2_2);
                var4_9 = var3_7.connections;
                synchronized (var4_9) {
                    var5_11 = 0;
                    while (var5_11 < var3_7.connections.size()) {
                        var6_13 = (ServiceClient)var3_7.connections.elementAt(var5_11);
                        var6_13.checkStatus();
                        if (!var6_13.getStatus() && !var6_13.SETUP) {
                            var3_7.connections.removeElementAt(var5_11);
                        }
                        ++var5_11;
                    }
                }
                var5_10 = var3_7.stickyconnections;
                synchronized (var5_10) {
                    var6_12 = 0;
                    while (var6_12 < var3_7.stickyconnections.size()) {
                        var7_14 = (Sticky)var3_7.stickyconnections.elementAt(var6_12);
                        if (var7_14.checkExpire()) {
                            var3_7.stickyconnections.removeElementAt(var6_12);
                            this.logEvent("Removed Expired Sticky Connection for client at " + var7_14.getAddress());
                        }
                        ++var6_12;
                    }
                }
                ++var2_2;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception var3_8) {
                // empty catch block
            }
lbl69:
            // 3 sources

        } while (this.RUNNING);
        if (loadbalanced.LOGGING) {
            this.logEvent("Exited mainloop()");
        }
        this.shutDown();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception var2_4) {
            // empty catch block
        }
    }

    public void run() {
        block81: {
            String string = new String("%unrecognized command\r\n");
            String string2 = new String("--------------------------------------------------------------------------------\r\n");
            BufferedReader bufferedReader = null;
            OutputStream outputStream = null;
            String string3 = new String();
            try {
                ServerSocket serverSocket = new ServerSocket(this.COMMAND_PORT, 1, InetAddress.getLocalHost());
                Socket socket = null;
                while (this.RUNNING) {
                    try {
                        String string4 = new String();
                        if (LOGGING) {
                            this.logEvent("Command Processor: Thread Listening At: " + serverSocket.getInetAddress().getHostAddress() + ":" + serverSocket.getLocalPort());
                        }
                        socket = serverSocket.accept();
                        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        outputStream = socket.getOutputStream();
                        socket.setSoTimeout(this.COMMAND_TIMEOUT);
                        if (LOGGING) {
                            this.logEvent("Command Processer: Connection Attempt From: " + socket.getInetAddress().getHostAddress());
                        }
                        outputStream.write(new String("Password: ").getBytes());
                        string4 = bufferedReader.readLine();
                        string4 = string4.trim();
                        if (!string4.equals(this.PASSWORD)) {
                            if (LOGGING) {
                                this.logEvent("Command Processor: WARNING Authentication Failure From: " + socket.getInetAddress().getHostAddress());
                            }
                            outputStream.write(new String("%incorrect password\r\n").getBytes());
                            socket.close();
                            continue;
                        }
                        outputStream.write(this.PROMPT.getBytes());
                        if (LOGGING) {
                            this.logEvent("Command Processor: Authentication Successful From: " + socket.getInetAddress().getHostAddress());
                        }
                        while ((string4 = bufferedReader.readLine()) != null) {
                            String string5;
                            String string6;
                            Object object;
                            Object object2;
                            int n;
                            StringBuffer stringBuffer;
                            string3 = "";
                            string4 = string4.trim();
                            string3 = string3 + string4;
                            if (LOGGING && string3.length() > 0) {
                                this.logEvent("Command Processor: Remote Input " + socket.getInetAddress().getHostAddress() + ": >" + string3 + "<");
                            }
                            if (string3.equals("halt")) {
                                outputStream.write(new String("%shutting down loadbalanced\r\n").getBytes());
                                throw new IllegalThreadStateException("Command Processor Shutdown");
                            }
                            if (string3.equals("exit") || string3.equals("logout")) {
                                string3 = "";
                                outputStream.write(new String("%connection closed\r\n").getBytes());
                                break;
                            }
                            if (string3.equals("show virtual")) {
                                stringBuffer = new StringBuffer();
                                n = 0;
                                while (n < this.rc.virtuals.size()) {
                                    object2 = (VirtualClass)this.rc.virtuals.elementAt(n);
                                    stringBuffer.append("virtual " + ((VirtualClass)object2).getVirtualName() + " {\r\n");
                                    stringBuffer.append(" address " + ((VirtualClass)object2).getAddress() + "\r\n");
                                    stringBuffer.append(" port " + ((VirtualClass)object2).getPort() + "\r\n");
                                    stringBuffer.append(((VirtualClass)object2).getConfigServices());
                                    stringBuffer.append(" " + ((VirtualClass)object2).getStatus() + "\r\n");
                                    stringBuffer.append("}\r\n");
                                    ++n;
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.equals("show sticky")) {
                                stringBuffer = new StringBuffer();
                                n = 0;
                                while (n < this.rc.virtuals.size()) {
                                    object2 = (VirtualClass)this.rc.virtuals.elementAt(n);
                                    int n2 = 0;
                                    while (n2 < ((VirtualClass)object2).stickyconnections.size()) {
                                        object = (Sticky)((VirtualClass)object2).stickyconnections.elementAt(n2);
                                        stringBuffer.append("%" + ((Sticky)object).toString() + "\r\n");
                                        ++n2;
                                    }
                                    ++n;
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.equals("show services")) {
                                stringBuffer = new StringBuffer();
                                n = 0;
                                while (n < this.rc.services.size()) {
                                    object2 = (ServiceClass)this.rc.services.elementAt(n);
                                    stringBuffer.append("service " + ((ServiceClass)object2).getName() + " {\r\n");
                                    stringBuffer.append(" address " + ((ServiceClass)object2).getAddress() + "\r\n");
                                    stringBuffer.append(" port " + ((ServiceClass)object2).getPort() + "\r\n");
                                    stringBuffer.append(" keepalives " + ((ServiceClass)object2).getKeepAliveFrequency() + "," + ((ServiceClass)object2).getKeepAliveTimeOut() + ", " + ((ServiceClass)object2).getKeepAliveMaxFailure() + "\r\n");
                                    stringBuffer.append(" " + ((ServiceClass)object2).getStatus() + "\r\n");
                                    stringBuffer.append("}\r\n");
                                    ++n;
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.equals("show service summary")) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("Name\t\t\tAddressing\t\tState\t\tHits\r\n");
                                stringBuffer.append(string2);
                                n = 0;
                                while (n < this.rc.services.size()) {
                                    object2 = (ServiceClass)this.rc.services.elementAt(n);
                                    stringBuffer.append(((ServiceClass)object2).getName() + "\t\t" + ((ServiceClass)object2).getAddress() + ":" + ((ServiceClass)object2).getPort() + "\t\t" + ((ServiceClass)object2).getStatus() + "\t\t" + ((ServiceClass)object2).getHitCounter() + "\r\n");
                                    ++n;
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.equals("show version")) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("loadbalanced v" + VERSION + "\r\n");
                                stringBuffer.append("(c) 2002 thor newman\r\n");
                                stringBuffer.append("Hardware is " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " v" + System.getProperty("os.version") + "\r\n");
                                stringBuffer.append("  processed " + ((VirtualClass)this.rc.virtuals.firstElement()).getCount() + " connections\r\n");
                                stringBuffer.append("  server uptime: " + this.getUptimeString() + "\r\n");
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.equals("show connections")) {
                                stringBuffer = new StringBuffer();
                                n = 0;
                                while (n < this.rc.virtuals.size()) {
                                    object2 = (VirtualClass)this.rc.virtuals.elementAt(n);
                                    int n3 = 0;
                                    while (n3 < ((VirtualClass)object2).connections.size()) {
                                        object = (ServiceClient)((VirtualClass)object2).connections.elementAt(n3);
                                        stringBuffer.append("" + ((ServiceClient)object).getClient() + "\r\n Balanced to service " + ((ServiceClient)object).getLoadbalancedConnection() + "\r\n}\r\n");
                                        ++n3;
                                    }
                                    ++n;
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.startsWith("clear")) {
                                block78: {
                                    stringBuffer = new StringBuffer();
                                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                                    object2 = null;
                                    String string7 = null;
                                    object = null;
                                    string6 = null;
                                    try {
                                        string7 = stringTokenizer.nextToken().trim();
                                        object = stringTokenizer.nextToken().trim();
                                        string6 = stringTokenizer.nextToken().trim();
                                        if (((String)object).equals("sticky")) {
                                            object2 = this.getSticky(string6);
                                            ((Sticky)object2).expireSticky();
                                            stringBuffer.append("%sticky connection for client " + string6 + " administratively expired\r\n");
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        stringBuffer.append("%syntax: clear {sticky || connection} <remote address>\r\n");
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        if (((String)object).equals("sticky")) {
                                            stringBuffer.append("%sticky " + string6 + " not found\r\n");
                                        }
                                        if (!((String)object).equals("connection")) break block78;
                                        stringBuffer.append("%clear connection not implemented\r\n");
                                    }
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.startsWith("active")) {
                                block79: {
                                    stringBuffer = new StringBuffer();
                                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                                    object2 = null;
                                    ServiceClass serviceClass = null;
                                    object = null;
                                    string6 = null;
                                    string5 = null;
                                    try {
                                        object = stringTokenizer.nextToken().trim();
                                        string6 = stringTokenizer.nextToken().trim();
                                        string5 = stringTokenizer.nextToken().trim();
                                        if (((String)object).equals("active")) {
                                            if (string6.equals("service")) {
                                                serviceClass = this.getServiceClass(string5);
                                                if (serviceClass.getStatus().equals("shutdown")) {
                                                    serviceClass.activate();
                                                    stringBuffer.append("%service " + string5 + " changed state to active\r\n");
                                                } else {
                                                    stringBuffer.append("%service is not in shutdown state\r\n");
                                                }
                                            } else if (string6.equals("virtual")) {
                                                object2 = this.getVirtualClass(string5);
                                                if (((VirtualClass)object2).getStatus().equals("shutdown")) {
                                                    ((VirtualClass)object2).activate();
                                                    stringBuffer.append("%virtual server " + string5 + " changed state to active\r\n");
                                                } else {
                                                    stringBuffer.append("%virtual is not in shutdown state\r\n");
                                                }
                                            } else {
                                                stringBuffer.append("%syntax: active {service || virtual} <name>\r\n");
                                            }
                                        } else {
                                            stringBuffer.append(string);
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        stringBuffer.append("%syntax: active {service || virtual} <name>\r\n");
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        if (string6.equals("service")) {
                                            stringBuffer.append("%service " + string5 + " not found\r\n");
                                        }
                                        if (!string6.equals("virtual")) break block79;
                                        stringBuffer.append("%virtual " + string5 + " not found\r\n");
                                    }
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.startsWith("shutdown")) {
                                block80: {
                                    stringBuffer = new StringBuffer();
                                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                                    object2 = null;
                                    ServiceClass serviceClass = null;
                                    object = null;
                                    string6 = null;
                                    string5 = null;
                                    try {
                                        object = stringTokenizer.nextToken().trim();
                                        string6 = stringTokenizer.nextToken().trim();
                                        string5 = stringTokenizer.nextToken().trim();
                                        if (((String)object).equals("shutdown")) {
                                            if (string6.equals("service")) {
                                                serviceClass = this.getServiceClass(string5);
                                                if (!serviceClass.getStatus().equals("shutdown")) {
                                                    serviceClass.suspend();
                                                    stringBuffer.append("%service " + string5 + " changed state to administratively shutdown\r\n");
                                                } else {
                                                    stringBuffer.append("%service is already administratively shutdown\r\n");
                                                }
                                            } else if (string6.equals("virtual")) {
                                                object2 = this.getVirtualClass(string5);
                                                if (!((VirtualClass)object2).getStatus().equals("shutdown")) {
                                                    ((VirtualClass)object2).shutdown();
                                                    stringBuffer.append("%virtual server " + string5 + " changed state to administratively down\r\n");
                                                } else {
                                                    stringBuffer.append("%virtual is already administratively shutdown\r\n");
                                                }
                                            } else {
                                                stringBuffer.append("%syntax: shutdown {service || virtual} <name>\r\n");
                                            }
                                        } else {
                                            stringBuffer.append(string);
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        string3 = "";
                                        stringBuffer.append("%syntax: shutdown {service || virtual} <name>\r\n");
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        string3 = "";
                                        if (string6.equals("service")) {
                                            stringBuffer.append("%service " + string5 + " not found\r\n");
                                        }
                                        if (!string6.equals("virtual")) break block80;
                                        stringBuffer.append("%virtual " + string5 + " not found\r\n");
                                    }
                                }
                                outputStream.write(stringBuffer.toString().getBytes());
                            } else if (string3.length() > 0) {
                                outputStream.write(string.getBytes());
                            }
                            outputStream.write(this.PROMPT.getBytes());
                            string3 = "";
                        }
                        if (LOGGING) {
                            this.logEvent("command connection closed");
                        }
                        socket.close();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        outputStream.write(new String("\r\n%connection timeout\r\n").getBytes());
                        socket.close();
                        if (!LOGGING) continue;
                        this.logEvent("command connection timed out");
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        socket.close();
                        if (LOGGING) {
                            this.logEvent("shutting down command thread");
                        }
                        this.RUNNING = false;
                    }
                    catch (Exception exception) {
                        socket.close();
                        string3 = "";
                        if (!LOGGING) continue;
                        this.logEvent("" + exception);
                    }
                }
            }
            catch (Exception exception) {
                if (!LOGGING) break block81;
                this.logEvent("" + exception);
            }
        }
        if (LOGGING) {
            this.logEvent("exiting command processor thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VirtualClass getVirtualClass(String string) {
        Vector vector = this.rc.virtuals;
        synchronized (vector) {
            int n = 0;
            while (n < this.rc.virtuals.size()) {
                VirtualClass virtualClass = (VirtualClass)this.rc.virtuals.elementAt(n);
                if (virtualClass.getVirtualName().equals(string)) {
                    return virtualClass;
                }
                ++n;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceClass getServiceClass(String string) {
        Vector vector = this.rc.services;
        synchronized (vector) {
            int n = 0;
            while (n < this.rc.services.size()) {
                ServiceClass serviceClass = (ServiceClass)this.rc.services.elementAt(n);
                if (serviceClass.getName().equals(string)) {
                    return serviceClass;
                }
                ++n;
            }
            return null;
        }
    }

    public Sticky getSticky(String string) {
        try {
            ListIterator listIterator = this.rc.virtuals.listIterator();
            while (listIterator.hasNext()) {
                VirtualClass virtualClass = (VirtualClass)listIterator.next();
                ListIterator listIterator2 = virtualClass.stickyconnections.listIterator();
                while (listIterator2.hasNext()) {
                    Sticky sticky = (Sticky)listIterator2.next();
                    if (!sticky.getAddress().equals(string)) continue;
                    return sticky;
                }
            }
        }
        catch (Exception exception) {
            this.logEvent("getSticky: " + exception);
            return null;
        }
        return null;
    }

    public void setCommandPassword(String string) {
        this.PASSWORD = string;
    }

    public void setCommandPort(int n) {
        this.COMMAND_PORT = n;
    }

    public void setCommandPrompt(String string) {
        this.PROMPT = string;
    }

    public void setCommandTimeout(int n) {
        this.COMMAND_TIMEOUT = n;
    }

    public long getUptimeMillis() {
        long l = System.currentTimeMillis();
        return l - STARTEXEC;
    }

    public String getUptimeString() {
        long l = System.currentTimeMillis();
        long l2 = l - STARTEXEC;
        if (l2 < 1L) {
            l2 = 1L;
        }
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        if ((l2 /= 1000L) / 86400L > 0L) {
            l3 = l2 / 86400L;
            l2 -= 86400L * l3;
        }
        if (l2 / 3600L > 0L) {
            l4 = l2 / 3600L;
            l2 -= 3600L * l4;
        }
        if (l2 / 60L > 0L) {
            l5 = l2 / 60L;
            l2 -= 60L * l5;
        }
        return new String(l3 + " Days, " + l4 + ":" + l5 + ":" + l2 + "s");
    }

    public void incConnections() {
        ++this.CONNECTIONS;
    }

    public synchronized void logEvent(String string) {
        String string2 = new String(new Date().toString());
        String string3 = new String(string2 + " " + string + "\r\n");
        try {
            this.log = new RandomAccessFile(this.logfile, "rw");
            this.log.seek(this.log.length());
            this.log.writeBytes(string3);
            this.log.close();
        }
        catch (Exception exception) {
            System.out.println("Error opening logfile: " + this.logfile);
            System.out.println("logEvent: " + exception);
            return;
        }
    }

    public void shutDown() {
        if (LOGGING) {
            this.logEvent("Shutting down Virtual Servers");
        }
        int n = 0;
        while (n < this.rc.virtuals.size()) {
            VirtualClass virtualClass = (VirtualClass)this.rc.virtuals.elementAt(n);
            if (virtualClass.getStatus().equals("active")) {
                virtualClass.halt();
            }
            ++n;
        }
        if (LOGGING) {
            this.logEvent("Shutting down Services");
        }
        int n2 = 0;
        while (n2 < this.rc.services.size()) {
            ServiceClass serviceClass = (ServiceClass)this.rc.services.elementAt(n2);
            if (!serviceClass.getStatus().equals("shutdown")) {
                serviceClass.suspend();
            }
            ++n2;
        }
    }

    static {
        VERSION = new String("1.2");
    }
}

