/*
 * Decompiled with CFR 0.152.
 */
import com.standbysoft.datepicker.DefaultMonthModel;
import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.MonthModel;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;
import com.standbysoft.datepicker.event.DateSelectionListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class GeneralDemo
extends JPanel {
    private JMonthView monthView;
    private JDatePicker datePicker;
    private JLabel localeLabel;
    private JComboBox localeComboBox;
    private JCheckBox weekNumbersVisible;
    private JCheckBox enabledCheckBox;
    private JCheckBox todayCheckBox;
    private JLabel dowFirstLabel;
    private JComboBox dowFirstComboBox;
    private JCheckBox minDateCheckBox;
    private JDatePicker minDateDatePicker;
    private JCheckBox maxDateCheckBox;
    private JDatePicker maxDateDatePicker;
    private DefaultMonthModel monthModel = new DefaultMonthModel();

    public GeneralDemo() {
        this.monthView = new JMonthView();
        this.monthView.setMonthModel((MonthModel)this.monthModel);
        this.datePicker = new JDatePicker();
        this.localeLabel = new JLabel("Locale:");
        this.localeComboBox = new JComboBox<Locale>(Locale.getAvailableLocales());
        this.localeComboBox.setSelectedItem(this.monthView.getLocale());
        this.localeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Locale locale = (Locale)GeneralDemo.this.localeComboBox.getSelectedItem();
                    GeneralDemo.this.monthView.setLocale(locale);
                    GeneralDemo.this.datePicker.setLocale(locale);
                }
            }
        });
        this.localeComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Locale locale = (Locale)object;
                jLabel.setText(locale.getDisplayName());
                return jLabel;
            }
        });
        this.enabledCheckBox = new JCheckBox("Enable", this.monthView.isEnabled());
        this.enabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDemo.this.monthView.setEnabled(GeneralDemo.this.enabledCheckBox.isSelected());
                GeneralDemo.this.datePicker.setEnabled(GeneralDemo.this.enabledCheckBox.isSelected());
            }
        });
        this.weekNumbersVisible = new JCheckBox("Show week numbers (MonthView only)", this.monthView.isWeekNumbersVisible());
        this.weekNumbersVisible.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDemo.this.monthView.setWeekNumbersVisible(GeneralDemo.this.weekNumbersVisible.isSelected());
            }
        });
        this.todayCheckBox = new JCheckBox("Show Today (MonthView only)", this.monthView.isDisplayToday());
        this.todayCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GeneralDemo.this.monthView.setDisplayToday(GeneralDemo.this.todayCheckBox.isSelected());
            }
        });
        this.dowFirstLabel = new JLabel("First Day of Week:");
        this.dowFirstComboBox = new JComboBox();
        this.dowFirstComboBox.addItem(new Integer(1));
        this.dowFirstComboBox.addItem(new Integer(2));
        this.dowFirstComboBox.addItem(new Integer(3));
        this.dowFirstComboBox.addItem(new Integer(4));
        this.dowFirstComboBox.addItem(new Integer(5));
        this.dowFirstComboBox.addItem(new Integer(6));
        this.dowFirstComboBox.addItem(new Integer(7));
        this.dowFirstComboBox.setSelectedItem(new Integer(this.monthView.getMonthModel().getDowFirst()));
        this.dowFirstComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Integer n = (Integer)GeneralDemo.this.dowFirstComboBox.getSelectedItem();
                    GeneralDemo.this.monthView.setDowFirst(n.intValue());
                }
            }
        });
        this.dowFirstComboBox.setRenderer(new DefaultListCellRenderer(){
            private String[] DAY_NAMES = new DateFormatSymbols().getWeekdays();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Integer n2 = (Integer)object;
                jLabel.setText(this.DAY_NAMES[n2]);
                return jLabel;
            }
        });
        this.minDateCheckBox = new JCheckBox("MinDate");
        this.minDateDatePicker = new JDatePicker();
        this.minDateDatePicker.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                GeneralDemo.this.monthModel.setMinimumAllowed(GeneralDemo.this.minDateDatePicker.getSelectedDate());
            }
        });
        this.minDateCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GeneralDemo.this.monthModel.setMinimumAllowed(GeneralDemo.this.minDateDatePicker.getSelectedDate());
                } else {
                    GeneralDemo.this.monthModel.setMinimumAllowed(null);
                }
                GeneralDemo.this.minDateDatePicker.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.minDateCheckBox.setSelected(!this.minDateCheckBox.isSelected());
        this.minDateCheckBox.setSelected(!this.minDateCheckBox.isSelected());
        this.maxDateCheckBox = new JCheckBox("MaxDate");
        this.maxDateDatePicker = new JDatePicker();
        this.maxDateDatePicker.addDateSelectionListener((DateSelectionListener)new DateSelectionAdapter(){

            public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
                GeneralDemo.this.monthModel.setMaximumAllowed(GeneralDemo.this.maxDateDatePicker.getSelectedDate());
            }
        });
        this.maxDateCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GeneralDemo.this.monthModel.setMaximumAllowed(GeneralDemo.this.maxDateDatePicker.getSelectedDate());
                } else {
                    GeneralDemo.this.monthModel.setMaximumAllowed(null);
                }
                GeneralDemo.this.maxDateDatePicker.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.maxDateCheckBox.setSelected(!this.maxDateCheckBox.isSelected());
        this.maxDateCheckBox.setSelected(!this.maxDateCheckBox.isSelected());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.monthView, new GridBagConstraints(0, 0, 1, 8, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.datePicker, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.localeLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.localeComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 9, 1.0, 1.0, 11, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.enabledCheckBox, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.todayCheckBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.weekNumbersVisible, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.minDateCheckBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.minDateDatePicker, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.maxDateCheckBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.maxDateDatePicker, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.dowFirstLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.dowFirstComboBox, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("GeneralDemo");
        jFrame.setDefaultCloseOperation(3);
        GeneralDemo generalDemo = new GeneralDemo();
        generalDemo.setOpaque(true);
        jFrame.setContentPane(generalDemo);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GeneralDemo.createAndShowGUI();
            }
        });
    }
}

