/*
 * Created on Nov 6, 2003
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.standbysoft.datepicker.DefaultDateSelectionModel;
import com.standbysoft.datepicker.JDatePicker;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;

/**
 * Here you can see how to use the selection model to disable certain days,
 * that is to specify which days cannot be selected.
 */
public class DisableSelectionDemo extends JPanel {
	private JComboBox disableTypeComboBox;
	private JMonthView monthView;
	private JDatePicker datePicker;
	private JToggleButton toggleButton;
	private JLabel disableTypeLabel;
	private NoWeekendDateSelectionModel noWeekendSelectionModel;
	private ThisWeekOnlyDateSelectionModel thisWeekSelectionModel;
	private DefaultDateSelectionModel defaultSelectionModel;

	public DisableSelectionDemo() {
		defaultSelectionModel = new DefaultDateSelectionModel();
		noWeekendSelectionModel = new NoWeekendDateSelectionModel();
		thisWeekSelectionModel = new ThisWeekOnlyDateSelectionModel();
		
		monthView = new JMonthView();
		datePicker = new JDatePicker();
		toggleButton = new JToggleButton("Change disable state for dates");
		disableTypeLabel = new JLabel("Days to be disabled:");
		disableTypeComboBox = new JComboBox(new String[] { "Disable weekends", "Keep only this week", "Disable at your choice" });

		toggleButton.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent evt) {
				disableTypeComboBox.setEnabled(!toggleButton.isSelected());
			}
		});

		monthView.addDateSelectionListener(new DateSelectionAdapter() {
			public void dateSelectionChanged(DateSelectionEvent evt) {
				if (toggleButton.isSelected()) {
					Date[] dates = defaultSelectionModel.getSelectedDates();
					for (int i = 0; i < dates.length; i++) {
						defaultSelectionModel.addDisabled(dates[i]);
					}
				}
			}
		});

		disableTypeComboBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				int index = disableTypeComboBox.getSelectedIndex();

				if (evt.getStateChange() == ItemEvent.SELECTED) {
					if (index == 0) {
						monthView.setDateSelectionModel(noWeekendSelectionModel);
						datePicker.setDateSelectionModel(noWeekendSelectionModel);
						toggleButton.setVisible(false);
					} else if (index == 1) {
						monthView.setDateSelectionModel(thisWeekSelectionModel);
						datePicker.setDateSelectionModel(thisWeekSelectionModel);
						toggleButton.setVisible(false);
					} else if (index == 2) {
						monthView.setDateSelectionModel(defaultSelectionModel);
						datePicker.setDateSelectionModel(defaultSelectionModel);
						toggleButton.setVisible(true);
					}
				}
			}
		});
		disableTypeComboBox.setSelectedIndex(2);
		
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.MONTH, Calendar.AUGUST);
		datePicker.setSelectedDate(cal.getTime());

		setLayout(new GridBagLayout());
		add(monthView, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(datePicker, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(disableTypeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(disableTypeComboBox, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(new JLabel(""), new GridBagConstraints(4, 0, 1, 4, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(toggleButton, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(new JLabel(""), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
	}

	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("MonthViewDisableSelectionDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		DisableSelectionDemo newContentPane = new DisableSelectionDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}

/**
 * A selection model that disables all weekend days. 
 */
class NoWeekendDateSelectionModel extends DefaultDateSelectionModel {
	private static Calendar cal = Calendar.getInstance();

	public boolean isDisabled(Date date) {
		cal.setTime(date);
		return (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY) || (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY);
	}
}

/**
 * A selection model that disables all the days but the days from the current week. 
 */
class ThisWeekOnlyDateSelectionModel extends DefaultDateSelectionModel {
	private static Calendar cal = Calendar.getInstance();
	private static int week = cal.get(Calendar.WEEK_OF_YEAR);

	public boolean isDisabled(Date date) {
		cal.setTime(date);
		return cal.get(Calendar.WEEK_OF_YEAR) != week;
	}
}
