/*
 * Created on Nov 10, 2003
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

import com.standbysoft.datepicker.JDatePicker;

/**
 * Shows how to use the date picker as an editor in a table. 
 */
public class TableDemo extends JPanel {
	private JTable table;

	public TableDemo() {
		table = new JTable();
		table.setPreferredScrollableViewportSize(new Dimension(100, 100));
		
		List projects = new Vector();
		projects.add(new ProjectInfo("Project A", new Date(), new Date()));
		projects.add(new ProjectInfo("Project B", new Date(), new Date()));
		TableModel model = new ProjectTableModel(projects);
		table.setModel(model);
		table.setDefaultRenderer(Date.class, new DateCellRenderer());
		table.setDefaultEditor(Date.class, JDatePicker.createTableCellEditor());
		
		setLayout(new BorderLayout());
		add(new JScrollPane(table), BorderLayout.CENTER);
	}
	
	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("TableDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		TableDemo newContentPane = new TableDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);	
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}

class DateCellRenderer extends DefaultTableCellRenderer {
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
		
		if (value instanceof Date) {
			DateFormat df = DateFormat.getDateInstance();
			setText(df.format((Date)value));
		}
		
		return c; 
	}
}

/**
 * A wrapper for the information displayed in a table row. 
 */
class ProjectInfo {
	private String name;
	private Date startDate;
	private Date deadlineDate;
	
	public ProjectInfo(String name, Date startDate, Date deadlineDate) {
		this.name = name;
		this.startDate = startDate;
		this.deadlineDate = deadlineDate;
	}
	
	public String getName() {
		return name;
	}
	
	public Date getStartDate() {
		return startDate;
	}
	
	public Date getDeadlineDate() {
		return deadlineDate;
	}
	
	public void setDeadlineDate(Date deadlineDate) {
		this.deadlineDate = deadlineDate;
	}
}

/**
 * The model used by the table that displays project information. 
 */
class ProjectTableModel extends AbstractTableModel {
	private static final String COLUMN_NAMES[] = {"Project", "Start Date", "Deadline"};
	private List projects;
	
	public ProjectTableModel(List projects) {
		this.projects = projects;
	}

	public int getRowCount() {
		return projects.size();
	}

	public int getColumnCount() {
		return 3;
	}
	
	public Class getColumnClass(int columnIndex) {
		if (columnIndex == 0) {
			return String.class;
		} else {
			return Date.class;
		}
	}
	
	public String getColumnName(int columnIndex) {
		return COLUMN_NAMES[columnIndex];
	}
	
	public Object getValueAt(int rowIndex, int columnIndex) {
		ProjectInfo info = (ProjectInfo)projects.get(rowIndex);
		
		if (columnIndex == 0) {
			return info.getName();
		} else if (columnIndex == 1) {
			return info.getStartDate();
		} else if (columnIndex == 2) {
			return info.getDeadlineDate();
		}

		return null;
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return columnIndex == 2;
	}

	public void setValueAt(Object value, int rowIndex, int columnIndex) {
		ProjectInfo info = (ProjectInfo)projects.get(rowIndex);
		info.setDeadlineDate((Date)value);
	}
}