/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Chat;

import jChatBox.Chat.Blacklist;
import jChatBox.Chat.ChatException;
import jChatBox.Chat.ChatroomParams;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.LogListener;
import jChatBox.Chat.Msg;
import jChatBox.Util.Conf;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Chatroom
implements Serializable,
LogListener {
    private ChatroomParams _$3112 = null;
    private Vector _$3288;
    private transient Hashtable _$3289 = null;
    private Blacklist _$3290 = null;
    private Date _$3291 = null;

    public Chatroom(ChatroomParams chatroomParams) {
        this._$3112 = chatroomParams;
        this._$3288 = new Vector();
        this._$3289 = new Hashtable();
        this._$3290 = new Blacklist();
        this.open();
        this._$2724(1, String.valueOf(String.valueOf(new StringBuffer("New Chatroom : ").append(this._$3112.getName()).append("/").append(this._$3112.getSubject()).append("/").append(this._$3112.getMaxUsers()))));
    }

    public void open() {
        this._$3291 = new Date();
    }

    public void reOpen() {
        this._$3289 = new Hashtable();
        this._$3291 = new Date();
        this._$2724(1, "reOpen : ".concat(String.valueOf(String.valueOf(this._$3112.getName()))));
    }

    public void close() {
        this._$3291 = null;
    }

    public Date getDate() {
        return this._$3291;
    }

    public void addUser(ChatroomUser chatroomUser) throws ChatException {
        if (this._$3291 == null) {
            throw new ChatException(Conf.CLOSED);
        }
        String string = chatroomUser.getName();
        if (this._$3290.isKickedOff(chatroomUser)) {
            throw new ChatException(Conf.KICKEDOFF);
        }
        if (this._$3290.isBanned(chatroomUser)) {
            throw new ChatException(Conf.BANNED);
        }
        if ((chatroomUser.getType() != 2 || chatroomUser.getType() != 1) && this._$3289.size() > this._$3112.getMaxUsers()) {
            throw new ChatException(Conf.NOVACANCIES);
        }
        ChatroomUser chatroomUser2 = (ChatroomUser)this._$3289.get(string);
        if (chatroomUser2 == null) {
            if (chatroomUser.getName().toUpperCase().equals(XMLConfig.SYSTEMLOGIN.toUpperCase()) && chatroomUser.getType() != 2) {
                throw new ChatException(Conf.NAMENOTAVAILABLE);
            }
            if (XMLConfig.getModerator(chatroomUser.getName()) != null && chatroomUser.getType() != 1) {
                throw new ChatException(Conf.NAMENOTAVAILABLE);
            }
        } else {
            throw new ChatException(Conf.NAMENOTAVAILABLE);
        }
        this._$3289.put(string, chatroomUser);
        this.addMsg(new Msg(new Date(), "Manager", "ALL", string, 1));
    }

    public ChatroomUser getUser(String string) {
        ChatroomUser chatroomUser = (ChatroomUser)this._$3289.get(string);
        return chatroomUser;
    }

    public int getTotalUsers() {
        return this._$3289.size();
    }

    public ChatroomParams getParams() {
        return this._$3112;
    }

    public void updateParams(ChatroomParams chatroomParams) {
        this._$3112 = chatroomParams;
        this._$2724(1, String.valueOf(String.valueOf(new StringBuffer("Chatroom updated: ").append(this._$3112.getName()).append("/").append(this._$3112.getSubject()).append("/").append(this._$3112.getMaxUsers()))));
    }

    public void addToBlacklist(ChatroomUser chatroomUser, String string) {
        this._$3290.add(chatroomUser, string);
    }

    public void removeFromBlacklist(String string) {
        this._$3290.remove(string);
    }

    public void resetBlacklist() {
        this._$3290.clear();
    }

    public Blacklist getBlacklist() {
        return this._$3290;
    }

    public void removeUser(String string) throws ChatException {
        ChatroomUser chatroomUser = (ChatroomUser)this._$3289.get(string);
        if (chatroomUser == null) {
            throw new ChatException(Conf.NAMENOTFOUND);
        }
        this._$3289.remove(chatroomUser.getName());
        this.addMsg(new Msg(new Date(), "Manager", "ALL", chatroomUser.getName(), 2));
    }

    public void addMsg(Msg msg) throws ChatException {
        this._$3288.addElement(msg);
    }

    public Vector getChat() {
        return this._$3288;
    }

    public Vector getChat(String string) {
        Vector<Msg> vector = new Vector<Msg>();
        Msg msg = null;
        for (int i = 0; i < this._$3288.size(); ++i) {
            msg = (Msg)this._$3288.elementAt(i);
            if (!msg.getTo().equals(string) && !msg.getTo().equals("ALL") && !msg.getTo().equals("BROADCAST") && (msg.getType() != 3 || !msg.getFrom().equals(string))) continue;
            vector.addElement(msg);
        }
        return vector;
    }

    public Hashtable getUsers() {
        return this._$3289;
    }

    public void clear() {
        this._$3288.removeAllElements();
    }

    public void performLogout(ChatroomUser chatroomUser) {
        try {
            this.removeUser(chatroomUser.getName());
        }
        catch (Exception exception) {
            this._$2724(2, String.valueOf(String.valueOf(new StringBuffer("").append(chatroomUser.getName()).append(" has already left room : ").append(this._$3112.getName()))));
        }
    }

    public void performLogin(ChatroomUser chatroomUser) {
    }

    private void _$2724(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

