/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Chat.Transcript;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.Msg;
import jChatBox.Chat.Transcript.Dump;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class XMLDump
extends Dump {
    public XMLDump() {
        this._id = "xml_dump";
        this._name = "XML Dump";
        this._description = "XML file dump";
    }

    public void init() {
    }

    public String process(Chatroom chatroom, String string) throws ChatException {
        String string2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(XMLConfig.LOGFOLDER))).append(XMLConfig.SEPARATOR).append(string)));
        try {
            int n;
            XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
            String string3 = xMLPropertyResourceBundle.getString("global.encoding");
            if (string3 == null) {
                string3 = "ISO-8859-1";
            }
            OutputFormat outputFormat = new OutputFormat("XML", string3, true);
            outputFormat.setIndent(1);
            outputFormat.setIndenting(true);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)fileOutputStream, outputFormat);
            Vector vector = chatroom.getChat();
            Msg msg = null;
            String string4 = "";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(xMLPropertyResourceBundle.getString("chatroom.date.format"));
            ContentHandler contentHandler = xMLSerializer.asContentHandler();
            contentHandler.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "DATE", "CDATA", simpleDateFormat.format(new Date()));
            contentHandler.startElement("", "", "TRANSCRIPT", attributesImpl);
            attributesImpl.clear();
            attributesImpl.addAttribute("", "", "DATE", "CDATA", simpleDateFormat.format(chatroom.getDate()));
            attributesImpl.addAttribute("", "", "NAME", "CDATA", chatroom.getParams().getName());
            attributesImpl.addAttribute("", "", "SUBJECT", "CDATA", chatroom.getParams().getSubject());
            attributesImpl.addAttribute("", "", "LANGUAGE", "CDATA", chatroom.getParams().getLanguage());
            String string5 = "";
            Vector vector2 = chatroom.getParams().getModerators();
            if (vector2 != null && vector2.size() > 0) {
                for (n = 0; n < vector2.size(); ++n) {
                    string5 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string5))).append(vector2.elementAt(n)).append(",")));
                }
                string5 = string5.substring(0, string5.length() - 1);
            }
            attributesImpl.addAttribute("", "", "MODERATORS", "CDATA", string5);
            contentHandler.startElement("", "", "CHATROOM", attributesImpl);
            contentHandler.endElement("", "", "CHATROOM");
            for (n = 0; n < vector.size(); ++n) {
                msg = (Msg)vector.elementAt(n);
                attributesImpl.clear();
                attributesImpl.addAttribute("", "", "DATE", "CDATA", simpleDateFormat.format(msg.getDate()));
                attributesImpl.addAttribute("", "", "FROM", "CDATA", msg.getFrom());
                attributesImpl.addAttribute("", "", "TO", "CDATA", msg.getTo());
                contentHandler.startElement("", "", "MSG", attributesImpl);
                char[] cArray = msg.getMsg().toCharArray();
                contentHandler.characters(cArray, 0, cArray.length);
                contentHandler.endElement("", "", "MSG");
            }
            contentHandler.endElement("", "", "TRANSCRIPT");
            contentHandler.endDocument();
            fileOutputStream.close();
            this.trace(1, String.valueOf(String.valueOf(new StringBuffer("Chatroom ").append(chatroom.getParams().getName()).append(" transcripted as ").append(string).append("(XMLDump)"))));
        }
        catch (Exception exception) {
            this.trace(1, String.valueOf(String.valueOf(new StringBuffer("Cannot transcript (XMLDump) (").append(string2).append(") : ").append(exception.getMessage()))));
            throw new ChatException(exception.getMessage());
        }
        return null;
    }
}

