/*
 * Decompiled with CFR 0.152.
 */
package jChatBox.Command;

import jChatBox.Chat.ChatException;
import jChatBox.Chat.Chatroom;
import jChatBox.Chat.ChatroomManager;
import jChatBox.Chat.ChatroomUser;
import jChatBox.Chat.Msg;
import jChatBox.Command.CommandException;
import jChatBox.Command.CommandParams;
import jChatBox.Command.ModeratorCommand;
import jChatBox.Util.Conf;
import jChatBox.Util.Debug;
import jChatBox.Util.XMLConfig;
import jChatBox.Util.XMLPropertyResourceBundle;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpSession;

public class UserCommand
extends ModeratorCommand {
    public String execute(String string, CommandParams commandParams, ChatroomUser chatroomUser) throws CommandException {
        if (string != null && !string.equals("")) {
            string = string.toUpperCase();
            ChatroomManager chatroomManager = ChatroomManager.getInstance();
            if (chatroomManager == null) {
                throw new CommandException(Conf.SYSTEMERROR);
            }
            if (string.equals("REFRESH")) {
                return Conf.COMMANDOK;
            }
            if (string.equals("LOGOUT")) {
                HttpSession httpSession = (HttpSession)commandParams.getParameter("session");
                if (httpSession != null) {
                    httpSession.invalidate();
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("QUIT")) {
                HttpSession httpSession = (HttpSession)commandParams.getParameter("session");
                if (httpSession != null) {
                    httpSession.removeValue(XMLConfig.USERSESSIONID);
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("CHAT")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                String string2 = (String)commandParams.getParameter("msg");
                String string3 = (String)commandParams.getParameter("to");
                if (string2 != null && !string2.trim().equals("") && string3 != null && !string3.equals("")) {
                    Msg msg = null;
                    msg = string3.toUpperCase().equals("ALL") ? new Msg(new Date(), chatroomUser.getName(), string3, string2) : new Msg(new Date(), chatroomUser.getName(), string3, string2, 3);
                    try {
                        chatroom.addMsg(msg);
                        String string4 = Conf.COMMANDOK;
                        return string4;
                    }
                    catch (ChatException chatException) {
                        throw new CommandException(Conf.CHATROOMNOTFOUND);
                    }
                }
                return Conf.COMMANDOK;
            }
            if (string.equals("TIME")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
                return new SimpleDateFormat(xMLPropertyResourceBundle.getString("user.command.time.format")).format(new Date());
            }
            if (string.equals("HELP")) {
                int n = chatroomUser.getParams().getChatroom();
                Chatroom chatroom = null;
                try {
                    chatroom = chatroomManager.getChatroom(n);
                }
                catch (ChatException chatException) {
                    throw new CommandException(Conf.CHATROOMNOTFOUND);
                }
                XMLPropertyResourceBundle xMLPropertyResourceBundle = (XMLPropertyResourceBundle)XMLConfig.RESOURCES.get(chatroom.getParams().getLanguage());
                String string5 = (String)commandParams.getParameter("command");
                if (string5 != null && !string5.equals("")) {
                    String string6 = string5.toUpperCase();
                    if (string6.equals("TIME")) {
                        return String.valueOf(String.valueOf(Conf.TIMEHELP)).concat(String.valueOf(String.valueOf(xMLPropertyResourceBundle.getString("user.command.time.help"))));
                    }
                    if (string6.equals("CHAT")) {
                        return String.valueOf(String.valueOf(Conf.CHATHELP)).concat(String.valueOf(String.valueOf(xMLPropertyResourceBundle.getString("user.command.chat.help"))));
                    }
                    if (string6.equals("QUIT")) {
                        return String.valueOf(String.valueOf(Conf.QUITHELP)).concat(String.valueOf(String.valueOf(xMLPropertyResourceBundle.getString("user.command.quit.help"))));
                    }
                    if (string6.equals("REFRESH")) {
                        return String.valueOf(String.valueOf(Conf.REFRESHHELP)).concat(String.valueOf(String.valueOf(xMLPropertyResourceBundle.getString("user.command.refresh.help"))));
                    }
                    if (string6.equals("LOGOUT")) {
                        return String.valueOf(String.valueOf(Conf.LOGOUTHELP)).concat(String.valueOf(String.valueOf(xMLPropertyResourceBundle.getString("user.command.logout.help"))));
                    }
                    throw new CommandException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string6))).append(" : ").append(Conf.UNKNOWNCOMMAND))));
                }
                return Conf.HELPHELP;
            }
            return super.execute(string, commandParams, chatroomUser);
        }
        throw new CommandException(Conf.UNKNOWNCOMMAND);
    }

    private void _$2724(int n, String string) {
        Debug.log(n, this.getClass().getName(), string);
    }
}

