/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.win32;

import com.develop.io.LittleEndianOutputStream;
import com.develop.io.NakedByteStream;
import com.develop.jawin.COMException;
import com.develop.jawin.FuncPtr;
import com.develop.jawin.marshal.GenericStub;
import com.develop.jawin.marshal.MarshalConstants;
import com.develop.jawin.marshal.SharedStubs;
import com.develop.jawin.marshal.StructConverter;
import com.develop.jawin.win32.SecurityConstants;
import java.io.IOException;

public class Security
implements SecurityConstants,
MarshalConstants {
    public static int OpenProcessToken(int n, int n2) throws COMException, IOException {
        FuncPtr funcPtr = new FuncPtr("ADVAPI32.DLL", "OpenProcessToken");
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeInt(n2);
        byte[] byArray = GenericStub.win32Invoke(funcPtr.getPeer(), "IIA:T3:lln4", 12, 12, nakedByteStream.getInternalBuffer(), null);
        return StructConverter.bytesIntoInt(byArray, 0);
    }

    public static byte[] GetTokenInformation(int n, int n2) throws IOException, COMException {
        FuncPtr funcPtr = new FuncPtr("ADVAPI32.DLL", "GetTokenInformation");
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        littleEndianOutputStream.writeInt(n);
        littleEndianOutputStream.writeInt(n2);
        byte[] byArray = GenericStub.win32Invoke(funcPtr.getPeer(), "IIkkA::L16n4", 20, 20, nakedByteStream.getInternalBuffer(), null);
        int n3 = StructConverter.bytesIntoInt(byArray, 0);
        littleEndianOutputStream.writeInt(n3);
        byte[] byArray2 = GenericStub.win32Invoke(funcPtr.getPeer(), "IIM" + n3 + "IA:T1:L8n" + n3, 20, 20, nakedByteStream.getInternalBuffer(), null);
        return byArray2;
    }

    public static byte[] GetTokenUserSid(int n) throws IOException, COMException {
        byte[] byArray = Security.GetTokenInformation(n, 1);
        byte[] byArray2 = new byte[byArray.length - 8];
        System.arraycopy(byArray, 8, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static byte[] GetSidIdentifierAuthority(byte[] byArray) throws COMException, IOException {
        FuncPtr funcPtr = new FuncPtr("ADVAPI32.DLL", "GetSidIdentifierAuthority");
        return SharedStubs.invokeP_S(byArray, 6, funcPtr.getPeer(), 1);
    }

    public static int GetSidSubAuthorityCount(byte[] byArray) throws COMException, IOException {
        FuncPtr funcPtr = new FuncPtr("ADVAPI32.DLL", "GetSidSubAuthorityCount");
        byte[] byArray2 = SharedStubs.invokeP_S(byArray, 1, funcPtr.getPeer(), 1);
        return byArray2[0];
    }

    public static int GetSidSubAuthority(byte[] byArray, int n) throws COMException, IOException {
        FuncPtr funcPtr = new FuncPtr("ADVAPI32.DLL", "GetSidSubAuthority");
        byte[] byArray2 = SharedStubs.invokePI_S(byArray, n, 4, funcPtr.getPeer(), 1);
        return StructConverter.bytesIntoInt(byArray2, 0);
    }

    public static String SidToString(byte[] byArray) throws COMException, IOException {
        int n;
        byte[] byArray2 = Security.GetSidIdentifierAuthority(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "(hex)";
        if (0 == (byArray2[0] & byArray2[1])) {
            string = Integer.toString(StructConverter.BEBytesIntoInt(byArray2, 2));
        } else {
            n = 0;
            while (n < 6) {
                string = string + Integer.toHexString(byArray2[6]) + ".";
                ++n;
            }
        }
        stringBuffer.append("S-").append(byArray[0]).append("-").append(string);
        n = Security.GetSidSubAuthorityCount(byArray);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("-").append(Security.GetSidSubAuthority(byArray, n2));
            ++n2;
        }
        return stringBuffer.toString();
    }
}

