/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import vscript.image.ImageKit;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.message.Messagable;
import vscript.message.Message;

public class VButton
extends JButton
implements Messagable,
MouseListener {
    private ImageIcon uIcon;
    private ImageIcon rIcon;
    private ImageIcon dIcon;
    private Image uImage;
    private Image rImage;
    private Image dImage;
    private int prevWidth;
    private int prevHeight;
    private int offset;
    private boolean state;
    private boolean toggle;
    private boolean resize = false;
    private boolean redraw = true;
    private EventTagManager etm;

    public VButton(String string, Image image, Image image2, Image image3, boolean bl, int n, boolean bl2) {
        super(string);
        this.uImage = image;
        this.dImage = image2;
        this.rImage = image3;
        this.toggle = bl2;
        this.offset = n;
        this.resize = bl;
        this.setHorizontalTextPosition(0);
        if (image != null) {
            this.uIcon = new ImageIcon(image);
            this.setIcon(this.uIcon);
            this.setDisabledIcon(this.uIcon);
        }
        if (image2 != null) {
            this.dIcon = new ImageIcon(image2);
            this.setPressedIcon(this.dIcon);
        }
        if (image3 != null) {
            this.rIcon = new ImageIcon(image3);
            this.setRolloverIcon(this.rIcon);
        }
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.prevWidth || n2 != this.prevHeight) {
            this.redraw = true;
        }
        if (this.uImage == null || this.uImage.getWidth(null) <= 0) {
            super.paintComponent(graphics);
            return;
        }
        this.prevWidth = n;
        this.prevHeight = n2;
        if (this.redraw && this.resize) {
            if (this.uIcon != null) {
                Graphics graphics2;
                this.uIcon.setImage(ImageKit.buildButtonImage(this.uImage, n, n2, null));
                if (this.dIcon == null) {
                    this.dImage = new BufferedImage(this.uImage.getWidth(null), this.uImage.getHeight(null), 1);
                    graphics2 = this.dImage.getGraphics();
                    graphics2.drawImage(this.uImage, 0, 0, null);
                    ImageKit.colorImage((BufferedImage)this.dImage, this.offset, this.offset, this.offset);
                    this.dIcon = new ImageIcon(this.dImage);
                }
                if (this.rIcon == null) {
                    this.rImage = new BufferedImage(this.uImage.getWidth(null), this.uImage.getHeight(null), 1);
                    graphics2 = this.rImage.getGraphics();
                    graphics2.drawImage(this.uImage, 0, 0, null);
                    ImageKit.colorImage((BufferedImage)this.rImage, this.offset / 2, this.offset / 2, this.offset / 2);
                    this.rIcon = new ImageIcon(this.rImage);
                }
            }
            if (this.dIcon != null) {
                this.dIcon.setImage(ImageKit.buildButtonImage(this.dImage, n, n2, null));
                this.setPressedIcon(this.dIcon);
            }
            if (this.rIcon != null) {
                this.rIcon.setImage(ImageKit.buildButtonImage(this.rImage, n, n2, null));
                this.setRolloverIcon(this.rIcon);
            }
        }
        super.paintComponent(graphics);
        this.redraw = false;
    }

    public void handleMessage(Message message) {
        TagInterpreter.handleMessageGUI(this, message);
        String string = message.getMessageString();
        if (string != null) {
            if (string.equals("settext")) {
                String[] stringArray = message.getArguments();
                if (stringArray.length == 1) {
                    this.setText(stringArray[0]);
                }
            } else if (this.toggle) {
                if (string.equals("on")) {
                    this.state = true;
                    this.setIcon(this.dIcon);
                    this.etm.processEvent("on");
                } else if (string.equals("off")) {
                    this.state = false;
                    this.setIcon(this.uIcon);
                    this.etm.processEvent("off");
                }
            }
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
        this.etm = eventTagManager;
    }

    public String getDataValue(String string) {
        if (string.equals("data")) {
            return this.getText();
        }
        if (this.toggle && string.equals("state")) {
            if (this.state) {
                return "on";
            }
            return "off";
        }
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            boolean bl = this.state = !this.state;
            if (this.toggle) {
                if (this.state) {
                    this.setIcon(this.dIcon);
                    this.etm.processEvent("on");
                }
                if (!this.state) {
                    this.setIcon(this.uIcon);
                    this.etm.processEvent("off");
                }
            }
            this.etm.processEvent("click");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.etm.processEvent("mousein");
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.etm.processEvent("mouseout");
    }
}

