/*
 * Decompiled with CFR 0.152.
 */
package vscript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import vscript.GUI.ScreenPos;
import vscript.interpreter.EventTagManager;
import vscript.message.Messagable;
import vscript.message.Message;
import vscript.parser.Parser;

public class VData
implements Messagable {
    private HashMap variables = new HashMap(8);
    private HashMap indexMap = new HashMap(8);
    private StringBuffer csb;
    private HashMap cmap;
    private List clist;
    private StringBuffer num1;
    private StringBuffer num2;
    private StringBuffer num3;
    private float f1;
    private float f2;
    private float r1;

    public VData(HashMap hashMap) {
        this.variables.putAll(hashMap);
    }

    public void handleMessage(Message message) {
        String string = message.getMessageString();
        String[] stringArray = message.getArguments();
        if (string == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        this.currentVar(stringArray[0]);
        if (string.equals("clear")) {
            if (this.csb != null) {
                this.csb.setLength(0);
            } else if (this.clist != null) {
                this.clist.clear();
            } else if (this.cmap != null) {
                this.cmap.clear();
            }
        } else if (string.equals("remove")) {
            if (stringArray.length == 2) {
                if (this.clist != null) {
                    this.clist.remove(stringArray[1]);
                } else if (this.cmap != null) {
                    this.cmap.remove(stringArray[1]);
                }
            }
        } else if (string.equals("set")) {
            if (stringArray.length == 2 && this.csb != null) {
                this.csb.setLength(0);
                this.csb.append(stringArray[1]);
            }
        } else if (string.equals("setlist")) {
            if (stringArray.length == 2 && this.clist != null) {
                List list = Parser.getElements(stringArray[1], 44);
                this.variables.put(stringArray[0], list);
            }
        } else if (string.equals("setmap")) {
            if (stringArray.length == 2 && this.cmap != null) {
                String[] stringArray2 = Parser.getElements(stringArray[1], 44).toArray(new String[0]);
                this.variables.put(stringArray[0], Parser.parseAttributes(stringArray2));
            }
        } else if (string.equals("assign")) {
            if (stringArray.length == 2) {
                Object v = this.variables.get(stringArray[1]);
                this.variables.put(stringArray[0], v);
            }
        } else if (string.equals("addval")) {
            if (stringArray.length == 2) {
                if (this.csb != null) {
                    this.csb.append(stringArray[1].trim());
                } else if (this.clist != null) {
                    this.clist.addAll(Parser.getElements(stringArray[1], 44));
                } else if (this.cmap != null) {
                    String[] stringArray3 = Parser.getElements(stringArray[1], 44).toArray(new String[0]);
                    this.cmap.putAll(Parser.parseAttributes(stringArray3));
                }
            } else if (stringArray.length == 3) {
                this.cmap.put(stringArray[1], stringArray[2]);
            }
        } else if (string.equals("add")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 + this.f2;
            this.num3.setLength(0);
            this.variables.put(stringArray[2], this.num3.append(String.valueOf(this.r1)));
        } else if (string.equals("sub")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 - this.f2;
            this.num3.setLength(0);
            this.variables.put(stringArray[2], this.num3.append(String.valueOf(this.r1)));
        } else if (string.equals("mul")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 * this.f2;
            this.num3.setLength(0);
            this.variables.put(stringArray[2], this.num3.append(String.valueOf(this.r1)));
        } else if (string.equals("div")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 / this.f2;
            this.num3.setLength(0);
            this.variables.put(stringArray[2], this.num3.append(String.valueOf(this.r1)));
        } else if (string.equals("inc")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 + 1.0f;
            this.num1.setLength(0);
            this.variables.put(stringArray[0], this.num1.append(String.valueOf(this.r1)));
        } else if (string.equals("dec")) {
            this.currentNum(stringArray);
            this.r1 = this.f1 - 1.0f;
            this.num1.setLength(0);
            this.variables.put(stringArray[0], this.num1.append(String.valueOf(this.r1)));
        } else if (string.equals("addpos") && this.csb != null) {
            ScreenPos screenPos = Parser.parsePos(this.csb.toString());
            ScreenPos screenPos2 = Parser.parsePos(stringArray[1]);
            screenPos.left += screenPos2.left;
            screenPos.right += screenPos2.right;
            screenPos.top += screenPos2.top;
            screenPos.bottom += screenPos2.bottom;
            this.variables.put(stringArray[0], screenPos.toString());
        }
        this.csb = null;
        this.clist = null;
        this.cmap = null;
    }

    private void currentNum(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Object object = this.variables.get(stringArray[n]);
            if (object instanceof String) {
                object = new StringBuffer((String)object);
                this.variables.put(stringArray[n], object);
            }
            if (n == 0) {
                this.num1 = (StringBuffer)object;
                this.f1 = this.getVal(this.num1);
            } else if (n == 1) {
                this.num2 = (StringBuffer)object;
                this.f2 = this.getVal(this.num2);
            } else if (n == 2) {
                this.variables.put(stringArray[2], object);
                this.num3 = (StringBuffer)object;
            }
            ++n;
        }
    }

    private float getVal(StringBuffer stringBuffer) {
        float f = 0.0f;
        if (stringBuffer != null) {
            try {
                f = Float.parseFloat(stringBuffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    private void currentVar(String string) {
        Object object = this.variables.get(string);
        if (object instanceof String) {
            object = new StringBuffer((String)object);
            this.variables.put(string, object);
        }
        if (object instanceof StringBuffer) {
            this.csb = (StringBuffer)object;
        } else if (object instanceof List) {
            this.clist = (List)object;
        } else if (object instanceof HashMap) {
            this.cmap = (HashMap)object;
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
    }

    public String getDataValue(String string) {
        List list = null;
        if (string == null) {
            return "null";
        }
        list = Parser.getElements(string, 46);
        String[] stringArray = list.toArray(new String[0]);
        this.csb = null;
        this.clist = null;
        this.cmap = null;
        this.currentVar(stringArray[0]);
        switch (stringArray.length) {
            case 1: {
                if (this.csb != null) {
                    return this.csb.toString();
                }
                if (this.clist != null) {
                    StringBuffer stringBuffer = new StringBuffer(80);
                    Iterator iterator = this.clist.iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append((String)iterator.next() + ",");
                    }
                    return stringBuffer.toString();
                }
                if (this.cmap == null) break;
                String string2 = this.cmap.toString();
                if (string2.length() == 0) {
                    return null;
                }
                return string2.substring(1, string2.length() - 1);
            }
            case 2: {
                if (stringArray[1].equals("next") || stringArray[1].equals("prev") || stringArray[1].equals("curr")) {
                    int[] nArray;
                    if (this.clist == null) {
                        return "null";
                    }
                    Object object = this.indexMap.get(stringArray[0]);
                    if (object == null) {
                        nArray = new int[]{-1};
                        this.indexMap.put(stringArray[0], nArray);
                        object = nArray;
                    }
                    nArray = (int[])object;
                    if (stringArray[1].equals("next")) {
                        if (nArray[0] < this.clist.size()) {
                            nArray[0] = nArray[0] + 1;
                        }
                    } else if (stringArray[1].equals("prev") && nArray[0] >= 0) {
                        nArray[0] = nArray[0] - 1;
                    }
                    if (nArray[0] < 0 || this.clist.size() <= nArray[0]) break;
                    return (String)this.clist.get(nArray[0]);
                }
                if (stringArray[1].equals("index")) {
                    Object v = this.indexMap.get(stringArray[0]);
                    if (v == null) {
                        return String.valueOf(-1);
                    }
                    int[] nArray = (int[])v;
                    return String.valueOf(nArray[0]);
                }
                if (stringArray[1].equals("size")) {
                    if (this.clist != null) {
                        return String.valueOf(this.clist.size());
                    }
                    if (this.cmap != null) {
                        return String.valueOf(this.cmap.size());
                    }
                    if (this.csb == null) break;
                    return String.valueOf(this.csb.length());
                }
                if (stringArray[1].equals("val")) {
                    String string3;
                    if (this.cmap == null || (string3 = this.cmap.values().toString()).length() <= 0) break;
                    return string3.substring(1, string3.length() - 1);
                }
                if (stringArray[1].equals("key")) {
                    String string4;
                    if (this.cmap == null || (string4 = this.cmap.keySet().toString()).length() <= 0) break;
                    return string4.substring(1, string4.length() - 1);
                }
                if (!stringArray[1].equals("colon")) break;
                if (this.csb != null) {
                    if (this.csb.charAt(0) == '(' && this.csb.charAt(this.csb.length() - 1) == ')') {
                        this.csb.setCharAt(0, '\"');
                        this.csb.setCharAt(this.csb.length() - 1, '\"');
                    } else {
                        this.csb.insert(0, '\"');
                        this.csb.insert(this.csb.length(), '\"');
                    }
                    return this.csb.toString();
                }
                return "null";
            }
            case 3: {
                if (stringArray[1].equals("val")) {
                    if (this.cmap == null) break;
                    String string5 = (String)this.cmap.get(stringArray[2]);
                    if (string5 == null) {
                        string5 = "null";
                    }
                    return string5;
                }
                if (stringArray[1].equals("index")) {
                    int n;
                    if (this.clist == null || (n = Integer.valueOf(stringArray[2]).intValue()) >= this.clist.size()) break;
                    String string6 = (String)this.clist.get(n);
                    return string6;
                }
                if (!stringArray[1].equals("check")) break;
                if (this.cmap != null) {
                    Object v = this.cmap.get(stringArray[2]);
                    if (v != null) {
                        return "true";
                    }
                    return "false";
                }
                if (this.clist == null) break;
                boolean bl = this.clist.contains(stringArray[2]);
                if (bl) {
                    return "true";
                }
                return "false";
            }
        }
        return "null";
    }
}

