/*
 * Decompiled with CFR 0.152.
 */
package vscript.interpreter;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import vscript.GUI.CardContainerPanel;
import vscript.GUI.DocumentPanel;
import vscript.GUI.LoadListener;
import vscript.GUI.PercentLayout;
import vscript.GUI.ScreenPos;
import vscript.Tag;
import vscript.VSRHelper;
import vscript.interpreter.TagInterpreter;
import vscript.message.MessageNode;
import vscript.parser.Parser;

public class DocumentInterpreter
extends TagInterpreter {
    private CardContainerPanel parentCardContainer;
    private DocumentPanel docPanel;

    public Object interpret(Tag tag, MessageNode messageNode, int n) {
        Object object = messageNode.getContainer();
        if (object == null) {
            object = messageNode.getInterpretedObject();
        }
        if (object instanceof CardContainerPanel) {
            this.parentCardContainer = (CardContainerPanel)messageNode.getInterpretedObject();
        }
        return super.interpret(tag, messageNode, n);
    }

    public Object interpretObject(Tag tag) {
        if (tag.getTagIdentifier() == null) {
            return null;
        }
        String string = tag.getAttributeValue("ver");
        if (string != null && Float.parseFloat(string) > VSRHelper.version) {
            System.out.println("Wrong interpreter version");
            return null;
        }
        String string2 = tag.getAttributeValue("bcolor");
        if (string2 != null) {
            VSRHelper.backColor = Parser.parseColor(string2);
        }
        string2 = null;
        string2 = tag.getAttributeValue("fcolor");
        if (string2 != null) {
            VSRHelper.foreColor = Parser.parseColor(string2);
        }
        string2 = null;
        string2 = tag.getAttributeValue("bordercolor1");
        if (string2 != null) {
            VSRHelper.borderColor = Parser.parseColor(string2);
        }
        string2 = null;
        string2 = tag.getAttributeValue("bordercolor2");
        if (string2 != null) {
            VSRHelper.borderColor2 = Parser.parseColor(string2);
        }
        string2 = null;
        string2 = tag.getAttributeValue("border");
        if (string2 != null) {
            VSRHelper.border = string2;
        }
        this.docPanel = new DocumentPanel(this.parentCardContainer, tag.getTagIdentifier());
        return this.docPanel;
    }

    public void addComponent(JComponent jComponent, JPanel jPanel, ScreenPos screenPos, String string) {
        ((DocumentPanel)jPanel).setFirstChild(string);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new PercentLayout());
        jPanel2.add((Component)jComponent, screenPos);
        jPanel2.setBackground(VSRHelper.backColor);
        jPanel.add((Component)jPanel2, string);
    }

    public void processObject(Object object) {
        if (object instanceof LoadListener) {
            this.docPanel.addLoadListener((LoadListener)object);
        }
    }

    public boolean validLevel(int n) {
        if (n == 0) {
            return true;
        }
        return true;
    }
}

